/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    COPYF - File copy functions
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: COPYF.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	File copy functions using the "fileIO.h" functions.

   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
   Known bugs:

   ----
	
*/

#include <stdio.h>
#include <portable.h>
#include <assert.h>
#ifndef _MICROC_
#include <stdlib.h>
#endif /*#	!defined(_MICROC_) */

#ifdef __TURBOC__
#pragma hdrstop
#endif /*#	defined(__TURBOC__) */

#include "fileIO.h"
#include "copyF.h"
#include "savemem.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: COPYF.C 2.3 1998/10/04 05:17:36 ska Exp ska $";
#endif /*#	defined(RCS_Version) */


/*
 *	Copy bytes from one file to another
 */
void copyfile(unsigned size, FILE *toFp, char *toFn, FILE *frFp, char *frFn)
{	byte *buf;

	assert(toFp);
	assert(toFn);
	assert(frFp);
	assert(frFn);

	if(!size) return;

	buf = getmem(COPYBUF);

	while(size >= COPYBUF) {
		Eread(buf, COPYBUF, frFp, frFn);
		Ewrite(buf, COPYBUF, toFp, toFn);
		size -= COPYBUF;
	}
	Eread(buf, size, frFp, frFn);
	Ewrite(buf, size, toFp, toFn);

	free(buf);
}
void copyfilel(dword iM(*) size, FILE *toFp, char *toFn, FILE *frFp, char *frFn)
{	word i;

#ifdef _MICROC_
#define N 32768
#else /*#	!(defined(_MICROC_)) */
#define N 32768U
#endif /*#	defined(_MICROC_) */

	i = DWP_HI(size);
	while(i--) {
		copyfile(N, toFp, toFn , frFp, frFn);
		copyfile(N, toFp, toFn , frFp, frFn);
	}
	if((i = DWP_LO(size)) > N) {
		i -= N;
		copyfile(N, toFp, toFn , frFp, frFn);
	}
	copyfile(i, toFp, toFn, frFp, frFn);
#undef N
}

/*
 *	Copy file to end of it
 */
void copyfilee(FILE *toFp, char *toFn, FILE *frFp, char *frFn)
{	dword pos;
	dword size;

	Egetpos(pos, frFp, frFn);
	Eseek(0, SEEK_END, frFp, frFn);
	Egetpos(size, frFp, frFn);
	Esetpos(pos, frFp, frFn);
	longsub(size, pos);
	copyfilel(size, toFp, toFn, frFp, frFn);
}

