/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    MSGIDS - Management of msgID association mappings
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: MSGIDS.H $
   $Locker: ska $	$Name:  $	$State: Exp $

	Management to handle the association between numerical and
	symbolical message ID.

   ----

   	typdef int (*ReadNxtMsgID)(void *arg, MSGID2 *id, char **name, int *length
   	 , int *buflen)
   	 	Type of the a function passed to scanMsgIDS() that extracts the
   	 	next available mapping. 'arg' is passed unchanged from the
   	 	caller of scanMsgIDS() to the nxtMsgID() function and must hold
   	 	all information to identify the next message(s).
   	 	*name is initialized with NULL and upon exit of scanMsgIDS()
   	 	free()'ed. *buflen is initialized with 0 and shall hold the
   	 	length of the currently allocated *name buffer. The allocated
   	 	buffer must be larger or equal to (length + 1)!
   	 	Return != 0 on success

   	typdef int (*DumpNxtMsgID)(void *arg, MSGID2 id, char *name, int length)
   	 	Dump the next mapping into the file fp/fn.
   	 	Return != 0 on success

	void clMsgIDs(struct MsgIDs *f)
		Free/unlink temporary files and buffer used by this msgIDs
		managment structure.

	unsigned hashMsgId(MSGID2 msgNum)
		Return unique hash number based upon msgNum.


	unsigned hashMsgName(char *msgName, int length)
		Return hash number from msgName


	int getSymID(struct MsgIDs *msgIDs, MSGID2 id, struct MsgIDhash *hash , char**name)
		Search the cached msgIDs assocs for the numerical msgID 'id'. On
		success fill *hash and place a pointer to a statical buffer that
		holds the symbolical msgID.
		Return 0 on failure.

	int getSymNam(struct MsgIDs *msgIDs, char *name, int length , struct MsgIDhash *hash)
		Search the cached msgIDs assocs for the symbolical msgID 'name'. On
		success fill *hash.
		Return 0 on failure.


	struct MsgIDs *scanMsgIDS(struct MsgIDs *currMsgIDs, ReadNxtMsgID nxt
	 , void *arg)
		Scan an MSG_MN_IDS item of the binary message library.
		If currMsgIDs != NULL, the read associations are verified with the
		ones already stored there. If non-conflicting, non-existing symbolic
		message IDs are found, they are appended to currMsgIDs.
		If currMsgIDs == NULL, a new structure is created.
		If nxt == NULL, no scanning is activate, only the new file
		is created.
		On failure the program is terminated with an error message.
		On success, currMsgIDs or the newly created structure is returned.

	void dumpMsgIDS(struct MsgIDs *msgIDs, DumpNxtMsgID nxt, void *arg)
		Pass all messages to the 'nxt' function in ascending order.

	void dumpBinMsgIDS(struct MsgIDs *msgIDs, FILE *fp, char *fn)
		Dump all messages into a binary message file.

	int addMsgID(struct MsgIDs *msgIDs, char *name, int length, int group)
		Add a message into the message group.
		If the message already exists in another group, an error is issued.
		If the message does not exist, a new one is created within msgIDs.

   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
	Known bugs:

   ----
	
*/

#ifndef __MSGIDS__H_
#define __MSGIDS__H_

#include <portable.h>

#include "tmpFile.h"
#include "hashFile.h"

#ifndef MSG_METHOD
#define MSG_METHOD 1			/* don't want method #2 encoding right now */
#endif
#include "../msgconf2.h"		/* method #2 structures */


struct MsgIDs {			/* The association of message IDs and message names */
	TempFile *dat;		/* see scanMsgIDs() for more details */
	HashFile *idx1, *idx2;
	int grpIDs[MSGGROUPMAX];	/* number of highest ID per msgGroup */
};


struct MsgIDhash {			/* entry within DAT file */
	dword next;				/* chain the hashed linked list of msgName */
	MSGID2 msgid;
	int length;
};

#ifndef _MICROC_
typedef int (*ReadNxtMsgID)(void *arg, MSGID2 *id, char **name, int *length
 , int *buflen);
typedef int (*DumpNxtMsgID)(void *arg, MSGID2 id, char *name, int length);
#else /*#	!(!defined(_MICROC_)) */
#define ReadNxtMsgID int
#define DumpNxtMsgID int
#endif /*#	!defined(_MICROC_) */

void clMsgIDs(struct MsgIDs *f);
unsigned hashMsgId(MSGID2 msgNum);
unsigned hashMsgName(char *msgName, int length);
int getSymID(struct MsgIDs *msgIDs, MSGID2 id, struct MsgIDhash *hash , char**name);
int getSymNam(struct MsgIDs *msgIDs, char *name, int length , struct MsgIDhash *hash);
struct MsgIDs *scanMsgIDS(struct MsgIDs *currMsgIDs, ReadNxtMsgID nxt, void *arg);
void dumpMsgIDS(struct MsgIDs *currMsgIDs, DumpNxtMsgID nxt, void *arg);
void dumpBinMsgIDS(struct MsgIDs *msgIDs, FILE *fp, char *fn);
int addMsgID(struct MsgIDs *msgIDs, char *name, int length, int group);

#endif /*#	!defined(__MSGIDS__H_) */
