/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    SHSTR - Shared string implementation
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: SHSTR.H $
   $Locker: ska $	$Name:  $	$State: Exp $

	Strings are duplicated into the dynamic memory and, if more than
	one string is equal to another string, both strings will share the
	same memory area.
	The internal structure (control area) of the shared strings is
	hidden, the shared strings are addressed by the pointer to the
	(char*) string a shared strings holds.

   ----

	int genStrHashID(byte *s, unsigned length)
		Create a hash value for the string. This value is stored within
		the control area of each cached shared string to prevent to
		"strcmp()" unnecessarily.

	char *makeString(char *s)
		Generate a shared string or re-use a previously generated one.
		Returns the duplicate of "s".

	void disposeString(char *s)
		Free()'s one shared string. The string itself is only _physically_
		deleted, if the last link is free'ed.  
   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
	Known bugs:

   ----
	
*/

#ifndef __SHSTR__H_
#define __SHSTR__H_

extern int genStrHashID(byte *s, unsigned length);
extern char *makeString(char *s);
extern void disposeString(char *s);


#endif /*#	!defined(__SHSTR__H_) */ 
