/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: IDNTSTR0.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	int msg2IdentMSGLIB(MsgStru0 *msg0)

 	Identify if the structure #0 contains valid values
 	Currently only the member ms0_id is checked.

 	Return:
 		== 0: OK
 		 > 0: specific error
 		 < 0: unspecific error

*/

#include <assert.h>
#include <string.h>
#include "msg2.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: IDNTSTR0.C 1.2 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

int msg2IdentMSGLIB(const MsgStru0 * const msg0)
{	
	assert(msg0);

	if(!(memcmp(msg0->ms0_id, MSG_IDSTRING, sizeof(MSG_IDSTRING) - 1) == 0
	 && msg0->ms0_magicnumber == MSG_MN_STRU0))
		return -1;
	if(msg0->ms0_version != 0)
		return 1;
	return 0;
}

