/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG2LMSG.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	MsgStr *msg2MsgLock(MSGID2 id)

	Fetch message with the id from the global catalogue
	If failed, generate a default message.

	Return:
		always != NULL; a pointer to a valid MsgBuf structure.

*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include "msg2.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG2LMSG.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

static char dflt_msg[] = "Message #????";

MsgStr *msg2MsgLock(MSGID2 id)
{	MsgStr *str;
	static MsgStr errDfltMsg = {
		iM((int)) NULL, (MSGID2)0, 1, iM((char))255, 'I', '\0'};
	static MsgStr *dfltMsg = NULL;

	/* Fetch the message from the global catalogue */
	IF_GCAT if((str = msg2Get(PAS_GCAT id)) != NULL)
		return str;

	/* Generate default message */
	if(!dfltMsg) {
		if((dfltMsg = malloc(sizeof(MsgStr) + sizeof(dflt_msg))) == NULL)
			return aS(errDfltMsg);
		memcpy(dfltMsg, aS(errDfltMsg), sizeof(errDfltMsg));
		strcpy(dfltMsg->text, dflt_msg);
	}

	/* Generate default message */
	itoa((int)id, dfltMsg->text + sizeof(dflt_msg) - 5, 16);
	dfltMsg->id = id;

	return dfltMsg;
}
