/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: SCANMSG1.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	int msg2ScanMsg1(MSGFILE f, msgLng *lng)

	Read the constant and variant fields fromout f and fill *lng.

	Transforms the relative ms2_ms3 members into absolute positions.

	Return:	0 on success

*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include "msg2.h"
#include "fileIO.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: SCANMSG1.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

int msg2ScanMsg1(MSGFILE f, msgLng *lng)
{	int i, rv;
	register MsgStru1 *msg1;
	MsgStru2 *msg2;
	dword pos;

	assert(lng);

	if(!MSread(f, lng->msg1))
		return 1;

	msg1 = aS(lng->msg1);

	/* check the incoming stru1 */
	if(!msg1->ms1_lng			/* invalid language code */
	 || !msg1->ms1_charsets		/* one supported charset is required */
	 || !msg1->ms1_groups)		/* one defined group is required */
	 	return 2;

	lng->aliases = NULL;		/* prepare missing variant field */
	lng->charsets = NULL;
	lng->msg2 = NULL;

	if((lng->charsets = malloc(sizeof(msgTCharset) * msg1->ms1_charsets))
	 == NULL
	  || (msg2 = lng->msg2 = malloc(sizeof(MsgStru2) * msg1->ms1_groups))
	   == NULL
	  || (msg1->ms1_aliases
	   && (lng->aliases = malloc(sizeof(msgTLngcode) * msg1->ms1_aliases))
	    == NULL)) {
	   	rv = 3;
	   	goto errRet;
	}

	for(i = 0; i < msg1->ms1_charsets;)
		if(!MOread(f, lng->charsets[i++])) {
			rv = 4;
			goto errRet;
		}

	for(i = 0; i < msg1->ms1_aliases;)
		if(!MOread(f, lng->aliases[i++])) {
			rv = 5;
			goto errRet;
		}

	for(i = msg1->ms1_groups; i--; sInc(msg2))
		if(MPread(f, msg2)
		 && Mgetpos(f, pos)) {		/* stru2 successfully read */
			/* make the ms2_ms3 member an absolute position */
			longadd(msg2->ms2_ms3, pos);
		}
		else {
			rv = 6;
			goto errRet;
		}

	return 0;		/* successfully read */

errRet:
	free(lng->charsets);
	free(lng->aliases);
	free(lng->msg2);
	return rv;
}
