/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: SRCH_STR.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	MsgStr *msg2Find(msgStr *strings, MSGID2 id, char *text, msgStr **prev)

	Search the chain of cached messages for a msgID or text member.

	id may be 0.
	text may be NULL.
	prev may be NULL.

	If neither id nor text is 0, the item is returned, that matches id,
	text, or both.

	If text is searched, it must be a pointer to the 'text' member of
	the msgStr item.

	Return:
		NULL: no match
		else: found match; if prev != NULL, *prev receives the previous
			item in the chain; if *prev becomes NULL, it's the first entry

*/

#include "msg2.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: SRCH_STR.C 1.2 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

MsgStr *msg2Find(MsgStr *str, MSGID2 id, char *text, MsgStr **Xprev)
{	MsgStr *prev;


	prev = NULL;
	if(str) do {
		if(str->id == id || str->text == text) {
			if(Xprev) *Xprev = prev;
			return str;
		}
	} while((str = (prev = str)->nxt) != NULL);

	return NULL;
}
