/* type.c */

/* Displays the contents of a text file */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>			/* Borland: exit() */
#include <string.h>			/* for strcmp */


/* Functions */

void cat (FILE *stream);
void usage (void);


/* The program starts here */

int
main (int argc, char **argv)
{
  FILE *stream;
  int i;

  /* Check command line */

  for (i = 1; i < argc; i++)
    {
      if (strncmp (argv[i], "/?", 2) == 0)
	{
	  usage ();
	  exit (0);
	} /* if /? */

      else
	{
	  stream = fopen (argv[i], "r");
	  if (stream)
	    {
	      cat (stream);
	      fclose (stream);
	    } /* if open */

	  else
	    {
	      fprintf (stderr, "TYPE: cannot read file: %s\n", argv[i]);
	    } /* else, not open */
	} /* else */
    } /* for */

  exit (0);
}

/* cat - actually display the contents of the stream */

void
cat (FILE *stream)
{
  int ch;

  while ((ch = fgetc (stream)) != EOF)
    {
      putchar (ch);
    } /* while */
}

/* usage - display the program usage.  do not exit from here */

void
usage (void)
{
  /* Display usage */

  fprintf (stderr, "TYPE - Displays the contents of a text file\n");
  fprintf (stderr, "Usage:\n");
  fprintf (stderr, "\tTYPE [drive:][path]filename..\n");
}
