/*
   Free-DOS Function Library GETOPT.C - Returns command line options
   Written by: Morgan "Hannibal" Toal, based upon original source by James Hall
   Compiler: MICRO-C 3.13/ARROWASM/VALLINK
*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "freedos.h"

#define ARGCHAR '='
#define SWCHAR '/'

void usage(void);

int optind = 1, optchar = 0;
char *optarg;

int getopt (int argc, char *argv[], char *options, char *argoptions)

{

    int c;
    while (optind < argc)

    {
        optarg = NULL;

/* If the current argv is a switch (i.e. starts with SWCHAR)... */

        if (argv[optind][0] == SWCHAR)
            switch (c = toupper(argv[optind][optchar]))

            {

/* ...advance to next argument if optchar is NULL or ARGCHAR */

            case NULL:
                optchar = 0;
                optind++; 
                break;

/* ...skip SWCHAR, but return ? if next optchar is SWCHAR or NULL */

            case SWCHAR:
                c = toupper(argv[optind][++optchar]);
                if ((c == SWCHAR) || (c == NULL))
                    return ('?');
                break;

/* ...return the optchar if in options or argoptions, or return ? */

            default:

		optchar++;

/* ...call usage if we have a "?" */

		if (c == '?')
			usage();

/* ...check to see if it is an argument-required option */

		if (strchr(argoptions, c) != NULL)
                	if ((argv[optind][optchar] == ARGCHAR)
                        	&& (argv[optind][optchar+1] != NULL))
			    	{
			    	optarg = &argv[optind++][optchar+1];
			    	optchar = 0;
			    	return (c);
				}
			else
				{
				fprintf (stderr, "%s: ERROR: Argument for option \"/%c\" not specified.\n", argv[0], c);
				usage ();
				}

/* ...check to see if it is a non-argument option */

                if (strchr(options, c) != NULL)
                   	if (argv[optind][optchar] != ARGCHAR)
	                	return (c);
			else
				{
				fprintf (stderr, "%s: ERROR: Argument not allowed for option \"/%c\".\n", argv[0], c);
				usage ();
				}
/* ...what the hell is it? */

                else
			fprintf (stderr, "%s: ERROR: Unrecognized option \"/%c\".\n", argv[0], c);
			usage ();
            }

/* return EOF because we have discovered a non-option argument */

        else 

            return (EOF);

    }

/* return EOF because we have run out of arguments */

    return (EOF);

}

#ifdef TEST

main (int argc, char **argv)

{
    int i;
    while ((i = getopt (argc, argv, "ABC", "XYZ")) != EOF)
    { 
        switch (i)
        {
        case 'A':
        case 'B':
        case 'C':
            printf ("Option %c selected.\n", i);
            break;

        case 'X':
        case 'Y':
        case 'Z':
            printf ("Option %c selected, with argument %s.\n", i, optarg);
            break;

        default:
            printf ("Unknown Error.\n");

        }
    }
    if (optind < argc)
    {
        printf ("The rest of the arguments are...\n");
        for (i = optind ; i < argc; i++)
            printf ("%d. %s\n", 1+i-optind, argv[i]);

    }

    printf ("This program would now be doing something useful.\n");

}

usage()
{
printp ("GETOPT", "Test program for GETOPT.C function");
printu ("GETOPT", "[\A] [\B] [\C] [\X=argument] [\Y=argument] [\Z=argument] [argument..]");
printo ("A", "Bogus option");
printo ("B", "Bogus option");
printo ("C", "Bogus option");
printo ("X", "Bogus option that requires an argument");
printo ("Y", "Bogus option that requires an argument");
printo ("Z", "Bogus option that requires an argument");
abort (1);
}

#endif
