;prn7bit.com - map 8 bit ASCII to 7 bit ASCII for 7 bit printers
;Copyright (C) 1996-1998  Karsten Hilbert

;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.

;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.

;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;Please see COPYING for a copy of the GNU General Public License.

;The author (me) can be reached at:
; Karsten Hilbert
; Hauptstrasse 30b
; 02999 Gross Saerchen
; Germany
; med94ecz@studserv.uni-leipzig.de
;################################################################
;mapping of ASCII > 127 to codes below 127 for 7 bit printers
;like MPS 1230 (Commodore)
;################################################################
code segment
	assume cs:code, ds: code
	org 2Ch
Env_adr dw  ?
	org 100h
new_print:
	jmp install

prog_name   db      'MPS 1230',0h

;OnOff       db 0FFh                   ;to be used for deactivation

;translation table for character replacement
tab_1to1 db '-<>||\\--|+~||\\||\///||\/--|=+----\\//++//   *Caeeiiouaiou/\ ',0,0,'$'

;translation table for actual mapping
tab_countries  db '{@/}[',0,0
					db '{[|\}]~',0,0
					db '#',0,0
					db '}]{[/',0,0
					db '@',0,0
					db '~|`',0,0
					db '#|/]['l,0,0
					db '/',0,0,'$'

;translation table for soft character downloading
;not yet implemented
;tab_str db 'y',8,27,82,1,'~',27,82,0,'#'
;        db '',15,27,83,48,'1',27,84,'/',27,83,49,'2',27,84,18,'#'
;        db '',15,27,83,48,'1',27,84,'/',27,83,49,'4',27,84,18,'#'
;        db '=',8,'_#'

old_prn_int    dw      ?,?

preamble       db 27,80          ;invoke mapping for
countrycode    db ?              ;this country
char           db ?
postamble      db 27,80,0        ;revoke mapping

new_prn_int proc far
	cmp ah,00h           ;print char request via int 0x17 ?
	je translate         ;yes - translate
								;nope - call old vector
use_old_int:
	jmp dword ptr cs:old_prn_int
	
translate:
	test al,80h          ;char > 128 ?
	jz use_old_int       ;nope - don't map (has to change for soft char downloading)
;  test OnOff,80h       ;translation active ?
;  jz use_old_int       ;nope - call old vector
	
	push si
	push bx
		
	lea si,tab_1to1      ;point to replacement tab
	call scan_tab        ;scan replacement tab
	cmp bh,1             ;char found ?
	je print_1to1        ;yes - replace and print

	lea si,tab_countries ;nope - load national tab
	call scan_tab        ;scan national tab
	cmp bh, 1            ;char found ?
	je print_national    ;yes - print mapped version
	jmp print_it         ;nope - print as is (some chars will fail to print correctly at this point)
	
print_1to1:
	mov al,cs:[si]    ;load successor from tab into AL
print_it:
	pop bx
	pop si
	jmp use_old_int
		
print_national:
	mov bl,cs:[si]    ;load successor from tab into BL
	mov char,bl       ;backup into char
	pop bx
	pop si

	mov di, 0
 again:
	 mov ah, 0
	 mov al, preamble[di]
	 cmp al,0
	 je done
	 inc di
	 cli
	 pushf
	 call dword ptr cs:old_prn_int
	 jmp again
 done:
	 jmp use_old_int
new_prn_int endp

scan_tab proc near
	mov countrycode,0
 scan_init:
	 inc countrycode
 scan:
	 mov bl,cs:[si]          ;load symbol from tab
	 inc si                  ;point to next
	 cmp al, bl              ;is symbol = char to print ?
	 je found                ;yes - indicate the find
	 inc si                  ;nope - point to next
	 cmp bl, 0h              ;was symbol a NULL ?
	 jne scan                ;nope - scan next symbol
	 mov bl, cs:[si]         ;yes - load next symbol
	 cmp bl,'$'              ;is it a '$' ?
	 jne scan_init           ;nope - scan next part of tab
	 mov bh,0                ;yes - end of tab
	 ret
 found:
	 mov bh,1
	 ret
scan_tab endp

install:
	assume ds:code
	push cs
	pop ds

 ;? get int 0x17 vector for installation check ?
	mov al,17h
	mov ah,35h
	int 21h

 ;? does int 0x17 point to a copy of THIS programm ?
	lea di,prog_name
	mov si,di
	mov cx,9h
	repe cmpsb
	jcxz installed

 ;nope - install
	lea dx,start_text
	call text_out
	mov al,17h
	mov ah,35h
	int 21h
	mov old_prn_int,bx
	mov old_prn_int+2,es

 ;free environment mem (at PSP)
	mov ax,[Env_Adr]
	mov es,ax
	mov ah,49h
	int 21h

 ;install new int
	lea dx,new_prn_int
	mov al,17h
	mov ah,25h
	int 21h

 ;terminate and stay resident up to label "install:"
	lea dx,install
	mov cl,4
	shr dx,cl
	inc dx
	xor al,al
	mov ah,49
	int 21h

 ;already running -> deinstall
installed:
	lea dx,installed_text
	call text_out
	mov ah,35h
	mov al,17h
	int 21h
;  not es:OnOff
	
	push ds
	mov dx,es:old_prn_int+2
	mov ds,dx
	mov dx,es:old_prn_int
	mov ah,25h
	int 21h
	pop ds
	mov ah,49h
	int 21h
	mov ax,4c00h
	int 21h

text_out proc near
	mov ah,9
	int 21h
	ret
text_out endp

start_text db 10,10,13
	db '   software by NCQ   ͻ',10,13
	db '  PRN7BIT v1.0    Copyright (C) 1998    Karsten Hilbert   ',10,13
	db ' PRN7BIT comes with ABSOLUTELY NO WARRANTY; for  details  ',10,13
	db ' see COPYING. This is free software, and you are welcome  ',10,13
	db ' to redistribute it under certain conditions; see COPYING ',10,13
	db ' for details.                                             ',10,13
	db 'ͼ',10,13
	db '$'
	
installed_text db 10,13,'ASCII conversion (7 bit -> 8 bit) deinstalled !',10,13,'$'
	
code ends
end new_print
;##########################################################################
;Hi !

;Prn7bit is a TSR that allows mapping of characters at print time.
;I use it to map international characters and symbols from ASCII codes
;above 127 to codes below 128 according to international font support
;to enable my MPS 1230 to print them at request.

;Currently the conversion tables are inside the TSR. I would like to
;move them to a file. Unfortunately I don't know how to conveniently
;read a file in assembler. Also, soft character downloading is not
;supported yet.

;I make this software liable to GPL.

;Have fun with it, include it in FreeDOS, use it...

;Karsten Hilbert
;med94ecz@studserv.uni-leipzig.de
