/*  Replace

    Copyright (c) Express Software 1997.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <bios.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// G L O B A L S ////////////////////////////////////////////////////////////

char newpath[MAXPATH], pathname[MAXPATH],newname[MAXPATH], oldname[MAXPATH];
char drive[MAXDRIVE], subdir[MAXDIR], file[MAXFILE], ext[MAXEXT];
char helpname[MAXPATH], sourcename[MAXPATH];

struct ffblk dta;

// P R O T O T Y P E S //////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[]);

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.
            
        } // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    int len, done, count=0, wassubdir=1, loop, gavename=0, star=0, n_options, n_files, index, help_flag=0, popt=0, ropt=0, wopt=0, ch;
    struct diskinfo_t di;
    char *fileargs[64], *optargs[64];
    unsigned attrib;

    n_options = classify_args(argc, argv, fileargs, optargs);
    n_files = argc - n_options;
    ch=ch;

    for (index=0;index<n_options;index++)
        {
        if (optargs[index][0] == '?') help_flag=1;
        else if (optargs[index][0] == 'A' || optargs[index][0] == 'a') goto resume;
        else if (optargs[index][0] == 'P' || optargs[index][0] == 'p') popt=1;
        else if (optargs[index][0] == 'R' || optargs[index][0] == 'r') ropt=1;
        else if (optargs[index][0] == 'W' || optargs[index][0] == 'w') wopt=1;
        else
            {
            printf("Invalid parameter - /%s\n", strupr(optargs[index]));
            exit(1);
            } // end else.

        } // end for.

    if (help_flag)
        {
        printf("Replaces files in a destination directory with files in a source directory\n"
               "that have the same name.\n\n"
               "Syntax: REPLACE [drive1:][path1]filename [drive2:][path2] [/A] [/P] [/R] [/W]\n"
               "  drive1:[path1]filename Specifies source or set of files\n"
               "  drive2:[path2]         Specifies the destination file\n"
               "  /A                     Adds new files to destination directory\n"
               "  /P                     Prompts for confirmation\n"
               "  /R                     Replaces read-only and unprotected files\n"
               "  /W                     Waits for you to insert a disk before copying\n");
        exit(1);
        } // end if.

    if (n_files < 2)
        {
        printf("Source path required\n");
        return(1);
        } // end if.

    if (popt)
        {
        strcpy(sourcename, fileargs[1]);
        strcpy(newpath, fileargs[2]);
        strcpy(subdir, fileargs[2]);
        strcpy(helpname, fileargs[2]);
        len = strlen(newpath);              // Destination path length.

        if (newpath[len-1] == 92)
            {
            wassubdir=0;
            if (len > 1)
                subdir[len-1] = 0;

            } // end if.
        else
            {
            newpath[len] = 92;              // Add the '\'.
            newpath[len+1] = 0;             // Don't forget to terminate it.
            } // end else.

        getcwd(newname,MAXPATH);        // Save the directory we were called from.

        // Suppose that user wants to rename a file.
        if (chdir(subdir) * wassubdir)
            {
            fnsplit(helpname,drive,subdir,file,ext); // Break up the destination file name.
            gavename=1;                 // Name for renaming was given.
            newpath[len] = 0;
            strcat(file,ext);
            len=strlen(subdir);
            subdir[len-1] = 0;
            wassubdir=0;

            for (loop=0;sourcename[loop]!=0;loop++)
                {
                if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                    star++;             // Check if you want to rename several files, which is impossible.

                } // end for.

            for (loop=0;file[loop]!=0;loop++)
                {
                if ((file[loop]=='*') || (file[loop]=='?'))
                    star++;

                } // end for.

            if (star)
                {
                printf("Invalid file argument\n");
                return 11;
                } // end if.

            } // end if.

        // This line is new for the second modification.
        chdir(newname);

        if (chdir(subdir) * wassubdir)  // See if the destination directory exists.
            {
            printf("Error changing directories\n");
            return 1;
            } // end if.

        chdir(newname);                         // Go back to home directory.
        fnsplit(fileargs[1],drive,subdir,file,ext); // Break up the source file name.
        sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));  // Save path of source file(s).
        done = findfirst(fileargs[1],&dta,47);      // Go look for first file.

cont:
        printf("Add %s? (Y/N) ", strupr(fileargs[1]));
        ch = bdos(1, 0, 0) & 0x00ff;
        if ((ch == 'y') || (ch == 'Y'))
            {
            while (!done)
                {
                strcpy(oldname,pathname);   // Start "creating" the old filename.
                strcat(oldname,dta.ff_name);
                strupr(oldname);            // Make it all upper case for DOS.
                strcpy(newname,newpath);    // Start "creating" destination filename.

                if (!gavename)              // Real moving without rename.
                    {
                    strcat(newname,dta.ff_name);
                    } // end if.

                strupr(newname);
                if (rename(oldname,newname) == 0) // Try to rename the file.
                    {
                    count++;                // Increment total files moved.
                    printf("%s => %s\n", strupr(oldname), strupr(newname));
                    done=findnext(&dta);    // Look for next one.
                    continue;
                    } // end if.

                if (_chmod(newname,1,0))
                    printf("Cannot replace files\n");
                else
                    if (remove(newname))
                        printf("Error replacing files\n");
                    else
                        continue;

                done=findnext(&dta);
                } // end while.

            } // end if.
        else
            {
            printf("%s not added\n", strupr(fileargs[1]));
            goto cont;
            } // end else.

        if (count == 0)
            printf("File not found\n");

        } // end if.

    if (ropt)
        {
        _dos_getfileattr(fileargs[1], &attrib);
        if (attrib & _A_RDONLY)
            {
            strcpy(sourcename, fileargs[1]);
            strcpy(newpath, fileargs[2]);
            strcpy(subdir, fileargs[2]);
            strcpy(helpname, fileargs[2]);
            len = strlen(newpath);

            if (newpath[len-1] == 92)
                {
                wassubdir=0;
                if (len > 1)
                    subdir[len-1] = 0;

                } // end if.
            else
                {
                newpath[len] = 92;
                newpath[len+1] = 0;
                } // end else.

            getcwd(newname,MAXPATH);

            // Suppose that user wants to rename a file.
            if (chdir(subdir) * wassubdir)
                {
                fnsplit(helpname,drive,subdir,file,ext);
                gavename=1;
                newpath[len] = 0;
                strcat(file,ext);
                len=strlen(subdir);
                subdir[len-1] = 0;
                wassubdir=0;

                for (loop=0;sourcename[loop]!=0;loop++)
                    {
                    if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                        star++;

                    } // end for.

                for (loop=0;file[loop]!=0;loop++)
                    {
                    if ((file[loop]=='*') || (file[loop]=='?'))
                        star++;

                    } // end for.

                if (star)
                    {
                    printf("Invalid file argument\n");
                    return 11;
                    } // end if.

                } // end if.

            // This line is new for the second modification.
            chdir(newname);
            if (chdir(subdir) * wassubdir)
                {
                printf("Error changing directories\n");
                return 1;
                } // end if.

            chdir(newname);
            fnsplit(fileargs[1],drive,subdir,file,ext);
            sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));
            done = findfirst(fileargs[1],&dta,47);

            while (!done)
                {
                strcpy(oldname,pathname);
                strcat(oldname,dta.ff_name);
                strupr(oldname);
                strcpy(newname,newpath);

                if (!gavename)
                    {
                    strcat(newname,dta.ff_name);
                    } // end if.

                strupr(newname);
                if (rename(oldname,newname) == 0)
                    {
                    count++;
                    printf("%s => %s\n", strupr(oldname), strupr(newname));
                    done=findnext(&dta);
                    continue;
                    } // end if.

                if (_chmod(newname,1,0))
                    printf("Cannot replace files\n");
                else
                    if (remove(newname))
                        printf("Error replacing files\n");
                    else
                        continue;

                done=findnext(&dta);
                } // end while.

            if (count == 0)
                printf("File not found\n");

            } // end if.
        else
            {
            fprintf(stderr, "File is not read-only.  Cannot replace files.\n");
            exit(1);
            } // end else.

        } // end if.

    if (wopt)
        {
        if ((di.drive = toupper(optargs[index][0]) - 'A') > 1)
            {
            printf("Drive specified is not a floppy disk drive\n");
            exit(1);
            } // end if.
        else
            {
            printf("Insert diskette and press\nany key to continue...\n");
            ch = getch();

            strcpy(sourcename, fileargs[1]);
            strcpy(newpath, fileargs[2]);
            strcpy(subdir, fileargs[2]);
            strcpy(helpname, fileargs[2]);
            len = strlen(newpath);

            if (newpath[len-1] == 92)
                {
                wassubdir=0;
                if (len > 1)
                    subdir[len-1] = 0;

                } // end if.
            else
                {
                newpath[len] = 92;
                newpath[len+1] = 0;
                } // end else.

            getcwd(newname,MAXPATH);

            // Suppose that user wants to rename a file.
            if (chdir(subdir) * wassubdir)
                {
                fnsplit(helpname,drive,subdir,file,ext);
                gavename=1;
                newpath[len] = 0;
                strcat(file,ext);
                len=strlen(subdir);
                subdir[len-1] = 0;
                wassubdir=0;

                for (loop=0;sourcename[loop]!=0;loop++)
                    {
                    if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                        star++;

                    } // end for.

                for (loop=0;file[loop]!=0;loop++)
                    {
                    if ((file[loop]=='*') || (file[loop]=='?'))
                        star++;

                    } // end for.

                if (star)
                    {
                    printf("Invalid file argument\n");
                    return 11;
                    } // end if.

                } // end if.

            // This line is new for the second modification.
            chdir(newname);

            if (chdir(subdir) * wassubdir)
                {
                printf("Error changing directories\n");
                return 1;
                } // end if.

            chdir(newname);
            fnsplit(fileargs[1],drive,subdir,file,ext);
            sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));
            done = findfirst(fileargs[1],&dta,47);

            while (!done)
                {
                strcpy(oldname,pathname);
                strcat(oldname,dta.ff_name);
                strupr(oldname);
                strcpy(newname,newpath);

                if (!gavename)
                    {
                    strcat(newname,dta.ff_name);
                    } // end if.

                strupr(newname);
                if (rename(oldname,newname) == 0)
                    {
                    count++;
                    printf("%s => %s\n", strupr(oldname), strupr(newname));
                    done=findnext(&dta);
                    continue;
                    } // end if.

                if (_chmod(newname,1,0))
                    printf("Cannot replace files\n");
                else
                    if (remove(newname))
                        printf("Error replacing files\n");
                    else
                        continue;

                done=findnext(&dta);
                } // end while.

            if (count == 0)
                printf("File not found\n");

            } // end else.

        } // end if.

resume:

    strcpy(sourcename, fileargs[1]);
    strcpy(newpath, fileargs[2]);
    strcpy(subdir, fileargs[2]);
    strcpy(helpname, fileargs[2]);
    len = strlen(newpath);

    if (newpath[len-1] == 92)
        {
        wassubdir=0;
        if (len > 1)
            subdir[len-1] = 0;

        } // end if.
    else
        {
        newpath[len] = 92;
        newpath[len+1] = 0;
        } // end else.

    getcwd(newname,MAXPATH);

    // Suppose that user wants to rename a file.
    if (chdir(subdir) * wassubdir)
        {
        fnsplit(helpname,drive,subdir,file,ext);
        gavename=1;
        newpath[len] = 0;
        strcat(file,ext);
        len=strlen(subdir);
        subdir[len-1] = 0;
        wassubdir=0;

        for (loop=0;sourcename[loop]!=0;loop++)
            {
            if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                star++;

            } // end for.

        for (loop=0;file[loop]!=0;loop++)
            {
            if ((file[loop]=='*') || (file[loop]=='?'))
                star++;

            } // end for.

        if (star)
            {
            printf("Invalid file argument\n");
            return 11;
            } // end if.

        } // end if.

    // This line is new for the second modification.
    chdir(newname);
    if (chdir(subdir) * wassubdir)
        {
        printf("Error changing directories\n");
        return 1;
        } // end if.

    chdir(newname);
    fnsplit(fileargs[1],drive,subdir,file,ext);
    sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));
    done = findfirst(fileargs[1],&dta,47);
    while (!done)
        {
        strcpy(oldname,pathname);
        strcat(oldname,dta.ff_name);
        strupr(oldname);
        strcpy(newname,newpath);

        if (!gavename)
            {
            strcat(newname,dta.ff_name);
            } // end if.

        strupr(newname);
        if (rename(oldname,newname) == 0)
            {
            count++;
            printf("%s => %s\n", strupr(oldname), strupr(newname));
            done=findnext(&dta);
            continue;
            } // end if.

        if (_chmod(newname,1,0))
            printf("Cannot replace files\n");
        else
            if (remove(newname))
                printf("Error replacing files\n");
            else
                continue;

        done=findnext(&dta);
        } // end while.

    if (count == 0)
        printf("File not found\n");

    return 1;

} // end main.
