program which;

(*
 *  which  -- display full pathname for executable command
 *  Copyright (C) 1998 Trane Francks
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  
 *  Author and Maintainer:  Trane Francks <trane@twh.gol.com>
 *
 *  To reach me by snail-mail, contact me at:
 *
 *                          Sento Hills Tsurukawa #305
 *                          1856-4 Kanai-cho, Machida City
 *                          Tokyo 195-0071
 *                          JAPAN
 *
 *  Comments, suggestions, and bug reports should be sent to me, preferably
 *  by e-mail. I'd like to hear from you if you find this program useful.
 *  Constructive critisism is nice; flames will go quietly into /dev/null.
 *)

(*
 *  NAME
 *    which -- display full pathname for executable command
 *
 *  SYNOPSIS
 *    which [/? | --help | /v | --version | /a | -a] [command ...]
 *
 *  DESCRIPTION
 *    DOS uses the PATH environment variable to determine which directories
 *    to search when attempting to execute a program. For each command
 *    specified, which searches directories defined in PATH and prints the
 *    name of the first executable file that matches command. When /a or -a
 *    is specified on the command line, which returns all executables
 *    found in PATH that match the command name.
 *
 *    Typically, one would not specify the file extension of a command to
 *    search for; doing so limits the search to that specific file name.
 *    In such a limited search, it's possible that which would return the
 *    name of an executable that is farther down the PATH than the actual
 *    file that is being executed. For example, if you have TEST.COM,
 *    TEST.EXE, and TEST.BAT all residing in the current directory, specifying
 *    TEST.BAT on the command line would cause which to report that TEST.BAT
 *    is being executed when, in fact, TEST.COM is the program being run. A
 *    better way is to simply search for TEST unless you really need to
 *    find an executable with a specific extension.
 *  
 *    In keeping with the execution order used by DOS, which displays COM
 *    files first, followed by EXE files, and then BAT files (for searches
 *    that do not have the extension specified). which searches the current
 *    directory before searching the directories defined in PATH.
 *
 *  OPTIONS
 *    which accepts the following options:
 *
 *    /?
 *    --help
 *                 Displays a short summary of how to use the program. When
 *                 this switch is in the first position on the command line,
 *                 which ignores all other command-line entries and displays
 *                 help information
 *
 *    /v
 *    --version
 *                 Displays version and licensing information. When this
 *                 switch is in the first position on the command line, which
 *                 ignores all other command-line entries and displays
 *                 version information
 *
 *    /a
 *    -a
 *                 Displays all executable files matching command that are
 *                 found in PATH, rather than just the first match. This
 *                 option cannot be used with other options
 *
 *  ENVIRONMENT VARIABLES
 *    which uses the following environment variables:
 *
 *    PATH         The list of directories to search for command
 *
 *  DIAGNOSTICS
 *    Possible exit values are:
 *
 *    0    Success:
 *             -- An executable file matching command was found
 *             -- Help or version information was displayed
 *    1    Failure due to the following:
 *             -- A matching executable file could not be found
 *             -- Invalid command-line option
 *
 *  NOTE
 *    This command has no way of knowing about COMMAND.COM internal commands
 *    and, therefore, is unable to help you resolve such conflicts. Under
 *    DOS, COMMAND.COM executes internal commands before searching PATH to
 *    find the executable being called.
 *
 *    If which is searching for multiple files and is able to locate one or
 *    more, the exit value will be 0 even if other commands are not found.
 *    Only the first position on the command line is tested for options; all
 *    other entries will be treated as filenames.
 *
 *  BUGS
 *    Oh, probably.
 *
 *  AUTHOR
 *    Trane Francks <trane@twh.gol.com>
 *
 *    I prefer being contacted via e-mail; however, you can snail-mail me at:
 *
 *      Trane Francks
 *      Sento Hills Tsurukawa #305
 *      1856-4 Kanai-cho, Machida City
 *      Tokyo 195-0071
 *      JAPAN
 *
 *
 *  DOS Extensions		24 August 1998
 *
 *)

(*
 *  which was coded using Emacs 19.34.4 for, and compiled under,
 *  BTP7. which may compile under other compilers; I don't know.
 *)


uses Crt, Dos;

const
   version				= '0.06'; { program version number }
   extension : array[1..3] of string[4]	= ('.COM', '.EXE', '.BAT');

var
   path		: string;     { directories in PATH environment variable }
   currentDir	: string;     { current directory to search }
   foundCurrent	: boolean;    { true if current filename is found }
   cmd2Find	: string;     { user-defined command to search for }
   userInput	: string;     { temp variable to contain cmd-line parms }
   index	: integer;    { array counter }
   counter	: byte;       { position on command line - file to find }
   i		: byte;       { current file position }
   findAll	: boolean;    { true if -a specified; otherwise, false }
   allExt	: boolean;    { search all extensions? Default = true }
   dirIndex	: integer;    { current position in PATH }
   endOfPath	: boolean;    { true if we've exhausted the path }
   foundFile	: boolean;    { true if we found a match; otherwise, false }
   extCounter	: byte;       { index for walking through extension array }
   pathExists	: boolean;    { true if PATH is set; otherwise, false }
   cwd		: string;     { current working directory on default drive }
   dirString	: dirStr;     { Turbo Pascal fsplit function built-in vars... }
   nameString	: nameStr;    { ...for directory, name, and extension part... }
   extString	: extStr;     { ...of fully qualified filename }

procedure displayhelp;
(*
 *  display help information
 *)
begin { procedure displayhelp }
   writeln('which ', version);
   writeln('usage: which [option] [command ...]');
   writeln;
   writeln('options: /? | --help     display help information');
   writeln('         /v | --version  display version information');
   writeln('         /a | -a         display all matching executables');
   writeln;
   writeln('examples: which /?');
   writeln('          which edit');
   writeln('          which /a descent turbo move');
end; { procedure displayhelp }


procedure displayversion;
(*
 *  display version information
 *)
begin { procedure display version }
   writeln('which ', version);
   writeln('Copyright (C) 1998 Trane Francks');
   writeln('which comes with NO WARRANTY');
   writeln('to the extent permitted by law.');
   writeln('You may redistribute copies of which');
   writeln('under the terms of the GNU General Public License.');
   writeln('For more information about these matters,');
   writeln('see the file LICENSE.TXT.');
   writeln;
   writeln('Report bugs to "Trane Francks" <trane@twh.gol.com>');
   writeln('Snail-mail address: Trane Francks');
   writeln('                    Sento Hills Tsurukawa #305');
   writeln('                    1856-4 Kanai-cho, Machida City');
   writeln('                    Tokyo 195-0071');
   writeln('                    JAPAN');
end; { procedure display version }


procedure dir2search(var index	    : integer;
			 path	    : string;
		     var currentDir : string;
		     var endOfPath  : boolean);
(*
 *  This proceudre is used to parse the PATH setting to determine the current
 *  directory to search in. It returns the position in the path along with
 *  the directory to search.
 *)
var
   i : byte;
   
begin { procedure dir2search() }
   currentDir := ''; { initialize the string to bugger-all }
   if (index >= length(path)) then
      exit { we're at or beyond the end of path }
   else
      while ((index <= length(path)) and (path[index] <> ';')) do
      begin { parse directory }
	 currentDir := concat(currentDir, path[index]);
	 inc(index);
      end; { parse directory }
   if (index < length(path)) then
      inc(index) { to move us past the ; character delimiting PATH }
   else
      endOfPath := true;
end; { procedure dir2search() }


procedure findcommand(	  cmd2Find     : string;
			  currentDir   : string;
		      var foundFile    : boolean;
		      var foundCurrent : boolean);
(*
 *  findcommand takes the string cmd2Find and searches the given directory
 *  to see if the file exists.
 *
 *  uses: subprocedure printfilename
 *)
var
   dirInfo : searchRec;

procedure printfilename;
(*
 *  prints filename of matching command in PATH
 *
 *  subprocedure of findcommand()
 *)
var
   dirString  : dirStr;  { Turbo Pascal fsplit function built-in vars }
   nameString : nameStr;
   extString  : extStr;
begin { subprocedure printfilename }
   if (currentDir = cwd) then { we're in the user's current working directory }
      writeln('.\', dirInfo.name) { don't print absolute path }
   else if (currentDir = '') then { user specified drive & filename }
   begin { split filename }
      fsplit(cmd2Find, dirString, nameString, extString);
      writeln(dirString, dirInfo.name);
   end { split filename }
   else
      writeln(currentDir, dirInfo.name); { print absolute path }
end; { subprocedure printfilename }

begin { procedure findcommand() }
   if ((currentDir <> '') and (currentDir[length(currentDir)] <> '\')) then
      currentDir := concat(currentDir, '\');
   cmd2Find := concat(currentDir, cmd2Find);
   findfirst(cmd2Find, archive, dirInfo);
   if ((pos('*', cmd2Find) <> 0) or (pos('?', cmd2Find) <> 0)) then
   begin { process wildcards }
      while (dosError = 0) do
      begin { loop through matching file spec }
	 printfilename;
	 findnext(dirInfo);
	 foundFile := true;
	 foundCurrent := true;
      end; { loop through matching file spec }
   end { process wildcards }
   else
      if (dosError = 0) then
      begin { only process single filename }
	 printfilename;
	 foundFile := true;
	 foundCurrent := true;
      end; { only process single filename }
end; { procedure findcommand() }
   

begin { program which }
   directVideo := false; { use BIOS screen-writes to support other codepages }
   findAll := false; { default behaviour is to find first executable only }
   allExt := true; { default behaviour is to check all extensions }
   dirIndex := 1; { start at the beginning of PATH }
   foundCurrent := false; { we haven't found any files yet... }
   foundFile := false; { we haven't found any files yet... }
   path := getenv('PATH');
   if (path = '') then
      pathExists := false
   else
      pathExists := true;
   if (paramcount = 0) then
   begin { no parameters given }
      writeln('which: no filename specified');
      displayhelp;
      halt(1);
   end { no parameters given }
   else
   begin { check specified parameters }
      userInput := paramstr(1);
      for index := 1 to length(userInput) do { uppercase user input }
	 userInput[index] := upcase(userInput[index]);
      if ((userInput = '--HELP') or (userInput = '/?')) then
      begin { display help }
	 displayhelp;
	 halt(0);
      end { display help }
      else if ((userInput = '--VERSION') or (userInput = '/V')) then
      begin { display version }
	 displayversion;
	 halt(0);
      end; { display version }
      if (((userInput = '-A') or (userInput = '/A')) and (paramcount > 1)) then
	 findAll := true
      else if (((userInput = '-A') or (userInput = '/A')) and
	       (paramcount = 1)) then
      begin { no filenames specified }
	 writeln('which: no filename specified');
	 displayhelp;
	 halt(1);
      end { no filesnames specified }
      else if ((userInput[1] = '-') or (userInput[1] = '/')) then
      begin { invalid option specified }
	 writeln('which: ', paramstr(1), ': invalid option');
	 displayhelp;
	 halt(1);
      end; { invalid option specified }
   end; { check specified parameters }
   begin { find files }
      { First, initialize paramstr(counter) to pull the first filename }
      if (findAll = true) then
	 counter := 2
      else
	 counter := 1;
      getdir(0, cwd); { search current drive/directory first }
      if not (cwd[length(cwd)] = '\') then
         cwd := concat(cwd, '\'); { add trailing backslash if not in root }
      currentDir := cwd;
      for i := counter to paramcount do
      begin { work through all filenames on command line }
	 while (endOfPath = false) and ((findAll = true) or
					(foundFile = false) or
					(foundCurrent = false)) do
	 begin {check files }
	    cmd2Find := paramstr(i);
	    fsplit(cmd2Find, dirString, nameString, extString);
	    if (dirString <> '') then
	       { we set currentDir to null so that we don't try to work our }
	       { way through PATH later on; the user is looking for a file }
	       { in a specific location }
	       currentDir := '';
	    for index := 1 to length(cmd2Find) do { uppercase command name }
	       cmd2Find[index] := upcase(cmd2Find[index]);
	    if (extString <> '') then { user specified extension }
	    begin { find fully qualified filename }
	       allExt := false;
	       findcommand(cmd2Find, currentDir, foundFile, foundCurrent);
	    end { find fully qualified filename }
	    else
	       for extCounter := 1 to 3 do
	       begin { search through all extensions }
		  if (extCounter > 1) then
		     delete(cmd2Find, length(cmd2Find) - 3, 4);
		  cmd2Find := concat(cmd2Find, extension[extCounter]);
		  findcommand(cmd2Find, currentDir, foundFile,
			      foundCurrent);
		  if (foundCurrent = true) and (findAll = false) then
		     break;
	       end; { search through all extensions }
	    if ((endOfPath = false) and (pathExists = true) and
		(currentDir <> '')) and ((findAll = true) or
					 (foundCurrent = false)) then
	       {work through path }
	       dir2Search(dirIndex, path, currentDir, endOfPath);
	    if (currentDir = '') then { set endOfPath to avoid endless loop }
	       endOfPath := true;
	 end; { check files }
	 if (path <> '')  then
	    endOfPath := false;
	 currentDir := cwd;
	 dirIndex := 1;
	 foundCurrent := false;
      end; { work through all filenames on command line }
   end; { find files }
   if (foundFile = false) then
      halt(1)
   else
      halt(0);
end. { program which }

