/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: BYTE2PAR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	word BLK_byte2para(unsigned bytes)

	Returns the number of paragraphes needed to store bytes bytes in.

   Target compilers: Micro-C, Borland C v2.0, v3.1, v4.52

*/

#include "initsupl.inc"


#include <portable.h>

word BLK_byte2para(nM(unsigned) bytes)
#ifdef _MICROC_
asm {
	mov ax, asmName(bytes, 4)
	mov ch, al
	mov cl, 4
	shr ax, cl
	and ch, 0Fh
	jz b2para1		; /* no partially used paragraphe */
	inc ax
b2para1:
}
#else
{ return (bytes >> 4) + ((bytes & 0xF)? 1: 0);	}
#endif
