/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: CTRLBRK.C $
   $Locker:  $	$Name:  $	$State: Exp $

	^Break function handler installer.	(see cb_catch.asm)

	Installs a handler for the ^Break signal.
	longjmp() should be possible inside that handler.
	If the handler is NULL, ^Break is ignored.

	Micro-C only.

*/

#include "initsupl.inc"

#ifdef _MICROC_
#define COMPILE
#else
#ifdef _PAC_NOCLIB_
#define COMPILE
#endif
#endif

#ifdef COMPILE
#include <portable.h>

#ifdef _MICROC_
extern void _cbreak_catcher(void);
#else
extern far void interrupt _cbreak_catcher_ll(void);
extern far void interrupt _cbreak_catcher_ss(void);
#endif

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CTRLBRK.C 2.4 1998/08/19 07:26:56 ska Exp $";
#endif

#ifdef _PAC_NOCLIB_
extern int (*_fct_cbreak)(void);
int (*_fct_cbreak)(void) = NULL;
#else
unsigned _fct_cbreak = 0		; /* addr of fct to invoke */
#endif

void ctrlbrk(inM(int *fct, int (*fct)(void)))
/* Install the ^Break catcher */
{	_fct_cbreak = fct;

#ifndef _MICROC_
#ifdef SMALL_CODE
	set_isrfct(0x23, _cbreak_catcher_ss);
#else
	set_isrfct(0x23, _cbreak_catcher_ll);
#endif
#else
	set_isrfct(0x23, _cbreak_catcher);
#endif
}
#endif
