/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_CHK.C 2.3 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_CHK.C - part of the enviroment handling.
 *
 *	Check environment
 *
 *	Functions: env_check()
 *
 *  Comments:
 *
 *	int env_check(unsigned segm);
 *	Check the environemnt, the return value:
 *		0:	environment OK
 *		1:	no environment at all (segm is NULL)
 *		2:	PSP corrupt (segm points to an invalid memory block)
 *		3:	variable's space corrupted
 *		4:	no string table
 *		5:	string table corrupted or no string table at all
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"
#include "mcb.h"
#include "suppl.h"

int env_check(const unsigned segm)
{	unsigned offset, length, len, cnt;

	if(!(length = mcb_length(segm)) || !(length + 1))	/* length not allowed
													for an environment */
		return 2;

	offset = 0;				/* all environments start at offset 0 */
	/* check variable's space */
	while(peekb(segm, offset)) {
		len = env_varlen(segm, offset);
		if(addu(&offset, len))
			return 3;		/* segment warp || segment overflow */
	}

	/* check string table */
	if(offset > 0xffff - 3 || (offset += 3) >= length)
		return 3;
	cnt = peekw(segm, offset - 2);
	if(cnt == 0)
		return 4;			/* no string table */

	while(cnt--) {
		len = env_varlen(segm, offset);
		if(addu(&offset, len))
			return 5;		/* segment warp || segment overflow */
	}

	return 0;
}
