/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_DVAR.C 1.2 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_DVAR.C - part of the enviroment handling.
 *
 *	Functions: dupvar(), env_dupvar()
 *
 *  Comments:
 *
 *	char *dupvar(char *var);
 *	char *env_dupvar(word segm, char *var);
 *
 *	Locate the variable var in the environment and duplicate the complete
 *	contents into the heap.
 *
 *	If segm == 0, the current used environment is processed.
 *
 *	Return value:
 *		NULL: not found, no more memory, or var == NULL
 *		else: pointer to the malloc'ed string
 *
 *	Target compilers:	Micro-C v3.14; Borland C v2.0, v3.1, v4.52
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#endif
#include <portable.h>
#include "environ.h"
#include "fmemory.h"

char *dupvar(const char var[])
{	return env_dupvar(0, var);	}
char *env_dupvar(word segm, const char var[])
{	int ofs;						/* offset of the variable */
	int cpyLen;						/* length of variable's value */
	char *h;						/* temporary pointer to malloc'ed string */

	if(var == NULL						/* nothing to do */
	 || !segm && !(segm = env_glbSeg)	/* Locate the environment segment */
	 || (ofs = env_findVar(segm, var)) == -1)	/* variable not found */
		return NULL;

	ofs += strlen(var) + 1;			/* skip the name & the equal sign */
	if((h = malloc(cpyLen = env_varlen(segm, ofs))) != NULL)
	/* Copy the contents including the NUL terminator */
		_fmemcpy(TO_FP(h), MK_FP(segm, ofs), cpyLen);

	return h;
}
