/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_FANY.C $
   $Locker:  $	$Name:  $	$State: Exp $

	Functions: env_findAnyVar()

	Comments:

	int env_findAnyVar(word segm, char var[], word *ecase, word *icase)

	Try to match the variable var in the environment segm.

	Normally all environment functions within this package are case-sensitive.
	This is uncommon to DOS and may lead to improper functionality, but this
	allows to process uncommon variables, such as "windir" and "winbootdir".

	This function searches the environment and return within:
		*ecase	the offset of the first variable that name is
			case-sensitively equal to var[] (via _fstrcmp())
		*icase	the offset of the first variable that name is
			case-insensitively equal to var[] (via _fStrCmp())

	If one is not matched, the particulare value is set to -1.

	If segm == NULL, the current used environment is processed.

	ecase && icase must be != NULL. If both point to the same memory
	area, the case-insensitive match is stored.

	Return:
		0: success, *ecase and *icase altered
		1: var == NULL
		2: no match found, *ecase & *icase unaltered
		3: no environment at all, var[] unaltered

	Note: If at least one of the bits 4 or 16 is set, the var[] is not
		modified.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "fmemory.h"

#include "suppl.h"
#include "dynstr.h"
#include "environ.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_FANY.C 1.3 1998/08/19 02:40:21 ska Exp $";
#endif

int env_findAnyVar(word segm, char var[], word *Xecase, word *Xicase)
{	word ecase, icase, ofs;
	int varLen;

	if(!var || !Xicase || !Xecase) return 1;

	if(!segm && !(segm = env_glbSeg))
		return 3;				/* no environment at all */

	ofs = 0;
	varLen = strlen(var);		/* offset of '=' sign */
	ecase = icase = (word)-1;
	while(peekb(segm, ofs)) {
		if(peekb(segm, ofs + varLen) == '=') {	/* length is OK */
			if(ecase == (word)-1
			 && _fmemcmp(MK_FP(segm, ofs), TO_FP(var), varLen) == 0) {
				/* case-sensitive match */
				ecase = ofs;
				if(icase != (word)-1)
					break;
			}
			else if(icase == (word)-1
			 && _fMemiCmp(MK_FP(segm, ofs), TO_FP(var), varLen) == 0) {
				/* case-insensitive match */
				icase = ofs;
				if(ecase != (word)-1)
					break;
			}
		}
		ofs += env_varlen(segm, ofs);
	}

	if(ecase == (word)-1 && icase == (word)-1)		/* no match found */
		return 2;

	*Xecase = ecase;
	*Xicase = icase;

	return 0;
}
