/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_FIND.C 2.3 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_FIND.C - part of the enviroment handling.
 *
 *	Supplemental functions shared by several environment functions.
 *
 *	unsigned env_findVar(unsigned segm, char *var)
 *	Return the offset of the variable var in the environment. -1 means
 *	not found. This function is case-sensitve.
 *
 *	Return:		0xFFFF:	not found or no environment at all
 *				else:	offset of environment (variable name portion)
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"
#include "fmemory.h"

unsigned env_findVar(const unsigned segm, const char var[])
{	unsigned offset;
	int len;

	/* for security reason, check if environment is present at all */
	if(!segm || !var)
		return -1;			/* No env --> no var can be found */
							/* No var --> nothing to search for */

	offset = 0;			/* env starts always at location 0 */
	len = strlen(var);

	while(peekb(segm, offset)) {			/* there is another variable */
		if(peekb(segm, offset + len) == '='
		 && _fmemcmp(MK_FP(segm, offset), TO_FP(var), len) == 0)
			return offset;		/* we found it */

		/* skip to the next variable */
		offset += env_varlen(segm, offset);
	}

	/* all variables were tested, nothing found */
	return -1;
}
