/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_NOST.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int env_nullStrings(word segm);

	Set the counter how many strings are in the string table to zero.

	Return:
		0: OK
		1: no room to place the counter
		4: no environment at all

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"
#include "mcb.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_NOST.C 1.4 1998/08/19 02:40:21 ska Exp $";
#endif

int env_nullStrings(word segm)
{	word ofs;

	if(!segm && (segm = env_glbSeg) == 0)
		return 4;

	ofs = env_endOfVars(segm) + 1;		/* offset of string counter word */
	if(mcb_length(segm) - 2 <= ofs)
		return 1;

	pokew(segm, ofs, 0);
	return 0;
}
