/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_PUT.C 2.3 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_PUT.C - part of the enviroment handling.
 *
 *	Functions: putenv()
 *
 *  Comments:
 *
 *	int putenv(char * var);
 *	
 *	Depending on the value of *var, a variable will be inserted/replaced
 *	into the environment or removed from the environment.
 *
 *	var:	The string must contain an '=' sign, which delimits the name
 *			of the variable (left portion) and the value (right portion).
 *			If the value is empty (an null-string), the variable is removed.
 *			The name may be empty and may contain wildcards, but no '=' sign.
 *			The name is *case-sensitive*.
 *
 *	Return value:
 *	 	0: Cannot insert variable.	// environment too small
 *		1: variable replaced.		// variable was already in the env
 *									// and was removed or replaced successfully
 *		2: variable not found.		// remove failed, because variable is not in env
 *		3: variable newly inserted.	// variable has been inserted successfully
 *		-1: No '=' sign in var.		// ill-formed parameter var, or var == NULL
 *
 *	This function calls chgenv() to achieve its goal.
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"

int putenv(const char *var)
{	char *p;		/* Pointer to the '=' sign */
	int err;

	if(var == NULL || (p = strchr(var, '=')) == NULL)
		return -1;		/* ill-formed parameter */

	*p = '\0';			/* mark the end of the name to call chgenv() */

	err = chgenv(var, p[1]? p + 1: NULL);
		/* if empty value => remove variable */

	*p = '=';			/* restore original string */

	return err;
}
