/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_SIZE.C 2.7 1998/08/19 07:26:56 ska Exp $
 *
 *  ENV_SIZE.C - part of the enviroment handling.
 *
 *	Functions: env_resize(), env_newsize()
 *
 *  Comments:
 *
 *	word env_newsize(word segm, unsigned length);
 *	Set the length of the environment segment. Else, behave like the
 *	following function.
 *
 *	unsigned env_resize(word segm, int deltaSize);
 *	Shirnk/Grow the environment block by deltaSize bytes. The block shrinks,
 *	if deltaSize < 0.
 *
 *	If segm == 0, the current used environment is processed.
 *
 *	Return value:
 *		0: no environment at all or resize failed
 *		else:	if deltaSize == 0: size of the environment block
 *				if deltaSize != 0: the (possibly new) segment address
 *
 *	Note: env_resize(0) returns the current size, but does not change
 *	the block.
 *	Note: If the block shrinks below the current first free byte limit or
 *	the block must be moved, the global variable env_resizeCtrl controls
 *	various special modes.
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>
#include "environ.h"
#include "mcb.h"
#include "suppl.h"

word env_newsize(word Osegm, unsigned newLength)
{	unsigned segm, length;

	if(newLength == 0) {		/* remove segment */
		env_delete(Osegm);
		return 0;
	}

	if(!(segm = Osegm)) segm = env_glbSeg;
	length = mcb_length(segm);

	if(length > newLength) {		/* shrink the block */
		if(segm) {		/* there is a segment to shrink */
			length = env_firstFree(segm);
			resizeBlk(segm, (length > newLength
					 && !(env_resizeCtrl & ENV_SHRINKBELOW))
			  ? length		/* don't shrink below last used byte */
			  : newLength);
			/* shrinking cannot fail --> ignore return value */
		}
	}
	else if(length != newLength) {			/* grow block */
		if(resizeBlk(segm, newLength)	/* resize failed or segm == 0 */
			/* Grow failed --> try to allocate a new block */
		 && (env_resizeCtrl & ENV_ALLOWMOVE)) {
			segm = length? env_replace(Osegm
				 , ENV_DELETE | ENV_COPY | ENV_CREATE, newLength)
			 : env_create(newLength);
			if(!Osegm) env_setGlbSeg(segm);
		}
	}

	return segm;		/* return the segment address */
}

word env_resize(word segm, int delta)
{	unsigned length;

	length = mcb_length(segm? segm: env_glbSeg);

	if(delta == 0)		/* it's a request of the current length */
		return length;

	/* honor the arethmetic (int) warp in the expressions */
	if(delta < 0)		/* shrink block */
		return env_newsize(segm, length <= -delta? 0: length + delta);

	/* grow block */
	return env_newsize(segm
	 , (unsigned)65535 - length < (unsigned)delta? (unsigned)65535
	 	: length + (unsigned)delta);
}
