/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: LONGSHLN.C $
   $Locker:  $	$Name:  $	$State: Exp $

	longshln(num, cnt)

	shift the number cnt times left (== multiplying by 2^cnt)
	Micro-C only.

	Return:
		== 0: if no bit was shifted out.
		!= 0: otherwise

*/

#include "initsupl.inc"

#ifdef _MICROC_

#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LONGSHLN.C 2.3 1998/08/19 02:40:21 ska Exp $";
#endif

longshln(dword *num, unsigned cnt)
{	FLAG ret;

	if(cnt >= sizeof(dword) * 8) {
		ret = longtst(num);
		longset(num, 0);
		return ret;
	}
	ret = 0;
	if(cnt >= sizeof(word) * 8) {
		ret = !!num->hi;
		num->hi = num->lo;
		num->lo = 0;
		cnt -= sizeof(word) * 8;
	}
	while(cnt--)
		ret = longshl(num) || ret;
	return ret;
}
#endif
