/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MCB_ENV.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int isEnv(const unsigned mcb);

	Returns	1, if the MCB number (*not* mem handle) is an environment;
			0, otherwise.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>
#include "mcb.h"

static isEnvcomp(void *arg, unsigned mcb)
{	return isPSP(mcb) && peekw(mcb, SEG_OFFSET + 0x2c) == (unsigned)arg;
}

int isEnv(const unsigned mcb)
{	return mcb_walk(0, aF(isEnvcomp), (void*)MCB2SEG(mcb));
}
