;
; Ranish Partition Manager   Copyright (C) 1998 by Mikhail Ranish
; This code is distributed under GNU General Public License (GPL)
; The full text of the license can be found at http://www.gnu.org
;
; ext32 - 32-bit extender: code to switch CPU into protected mode 
;
PAGE 255,132
LOCALS
.386p


STACK_SIZE	EQU	10000h	; 64k stack for 32-bit user program


SGROUP	GROUP _TEXT16, _DATA16, _ENDS16

_TEXT16	segment	para public use16 'START'
_TEXT16 ends
_DATA16	segment para public use16 'START'
_DATA16	ends
_ENDS16	segment para public use16 'START'
group16_end label byte
_ENDS16	ends


MODEL	SMALL	; Need to make offsets relative to groups


CODE	GROUP _TEXT, _TEXTEND
DGROUP	GROUP _DATA, _DATAEND, _BSS, _BSSEND

_TEXT	 segment public use32 'CODE'
_TEXT	 ends
_TEXTEND segment para   use32 'CODE'
code32_end label byte
_TEXTEND ends
_DATA	 segment public use32 'DATA'
_DATA	 ends
_DATAEND segment para   use32 'DATA'
data32_end label byte
bss_start  label byte
_DATAEND ends
_BSS	 segment public use32 'BSS'
_BSS	 ends
_BSSEND  segment para 	use32 'STACK' stack
bss_end    label byte
	 DB 512 Dup(?); for temporary stack
dgroup_end label byte
_BSSEND  ends


;----------------------------------------------------------------------

_DATA16		segment

printf_tab	DB "0123456789ABCDEF"

err_msg_cpu	DB "This program needs 386 or better CPU.", 13, 10, 0
err_msg_mem	DB "There isn't enough conventional memory.", 13, 10, 0
err_msg_dpmi	DB "DPMI initialization error after check point %d", 13, 10, 0
err_no_dpmi	DB "Couldn't find DPMI interface.", 13, 10
		DB "Please run this program under Windows 95/98",13,10
		DB "or run CWSDPMI -P to provide DPMI services.", 13, 10, 0
align	2

psp_seg		dw	?
video_seg	dw	?

data16_seg	label	word
code16_seg	dw	?
buffer_seg	dw	?
stack_seg	dw	?

code32_seg	dw	?
data32_seg	dw	?

heap_seg	dw  	?
heap_len	dw	?    ;  length of the heap in paragraphs

align	2
detected_os	dw	?
last_check_pt	dw	?

align	4
DPMI_switch	dd	?

_DATA16		ends

;----------------------------------------------------------------------

check_point	macro	n
		mov	last_check_pt, n
endm

;----------------------------------------------------------------------

 ASSUME	CS:SGROUP, DS:SGROUP

_TEXT16		segment	; 16-bit real mode BIOS and DOS startup code

;----------------------------------------------------------------------

bios_startup	proc	near
		;
		;  This is entry point when IPL
		;  loads this code to 0840h:0000h
		;
		mov	ax, cs
		mov	ds, ax

		;
		;  Checking that CPU is 386+
		;
		push	sp	; CPUs prior to 386 would decrement SP 
		pop	ax	; and then push it.
		cmp	ax, sp	; On 386+ these values should be equal
		jne	@@err1

		;
		;  Setting up data and stack segment
		;
		int	12h		; Returns AX = conv. memory in kb.
		shl	ax, 6
		mov	bx, ax
		call	setup_segs
		jc	@@err2

		mov	detected_os, 0	; Running under BIOS - no OS at all
		
;		jmp	raw_init

@@err1:		mov	si, offset err_msg_cpu
		jmp	@@perr
@@err2:		mov	si, offset err_msg_mem
		jmp	@@perr
@@perr:
		mov	ax, last_check_pt
		push	ax
		push	si
		call	printf_16rm
		add	sp, 4
@@halt:
		jmp	@@halt

bios_startup	endp

;----------------------------------------------------------------------

dos_startup	proc	near
		;
		;  This is entry point when program is called from DOS
		;
		mov	ax, cs
		mov	ds, ax

		;
		;  Checking that CPU is 386+
		;
		push	sp	; CPUs prior to 386 would decrement SP 
		pop	ax	; and then push it.
		cmp	ax, sp	; On 386+ these values should be equal
		jne	@@err1

		;
		;  Setting up data and stack segment
		;
		mov	bx, 2		; Num of paragrphs of conventional
		mov	bx, es:[bx]	; memory available to the program
		call	setup_segs
		jc	@@err2

		;
		;  Checking OS
		;
		call	check_os
		mov	detected_os, ax

		;
		;  Check if DPMI host is present
		;
		mov	ax, 1687h	; Get DPMI host address
		int	2fh
		cmp	ax, 0
		jne	@@no_dpmi	; DPMI host is not installed
		
		check_point 1
		test	bl, 1
		jz	@@err3		; DPMI cannot run 32-bit code
		
		check_point 2
		cmp	dx, 90		; DPMI version	dh = major
		jb	@@err3		;		dl = minor
		
		check_point 3
		cmp	si, heap_len
		ja	@@err3		; Not enough memory for DPMI
		
		mov	Word Ptr DPMI_switch, di
		mov	Word Ptr DPMI_switch+2, es
		
		mov	ax, heap_seg	; Giving memory to DPMI host
		sub	heap_len, si	; from the top of the free
		add	ax, heap_len	; conventional memory

		mov	es, ax
		mov	ax, 1		; 32-bit application

		check_point 4
		call	DPMI_switch	; switch to protected mode
		jc	@@err3

		;
		;  Now we are in protected mode
		;
		jmp	DPMI_init_PM	; see "ext32dpm.inc"

@@no_dpmi:
		mov	si, offset err_no_dpmi
		jmp	@@perr
		
		mov	al, 0
		jmp	@@exit
		
@@err1:		mov	si, offset err_msg_cpu
		jmp	@@perr
@@err2:		mov	si, offset err_msg_mem
		jmp	@@perr
@@err3:		mov	si, offset err_msg_dpmi
		jmp	@@perr
@@perr:	
		mov	ax, last_check_pt
		push	ax
		push	si
		call	printf_16rm
		add	sp, 4
		mov	al, 1
@@exit:
		mov	ah, 4Ch
		int	21h

dos_startup	endp

;----------------------------------------------------------------------

setup_segs	proc	near
		;
		;  Setting up segments
		;
		;  Argument: BX - num paragraphs of available memory
		;  Returns:  CF - set if there are not enough memory
		;	     else SS:SP will be set to correct values
		;  Destroys: EAX, EBX, ECX
		;
		mov	ax, cs
		mov	code16_seg, ax
		
		mov	cx, offset group16_end
		shr	cx, 4
		add	ax, cx
		mov	code32_seg, ax
		
		mov	ecx, offset code32_end
		shr	ecx, 04
		add	ax,  cx
		mov	data32_seg, ax
		
		mov	ecx, offset data32_end
		shr	ecx, 04
		add	ax,  cx
		mov	buffer_seg, ax

		add	ax, 1000h	; 64k buffer
		jc	@@error
		dec	ax
		add	ax,  0FFFh	; align on 64k boundary
		and	ax, 0F000h
		jc	@@error
		mov	stack_seg, ax	; 1k stack for real mode
		add	ax, 400h
		jc	@@error
		mov	heap_seg, ax
		sub	bx, ax
		jc	@@error
		mov	heap_len, bx

		pop	bx		; Remember return address
		mov	ss, buffer_seg
		mov	sp, 4000h
		push	bx

		mov	psp_seg, es

		mov	ah,0Fh		; Check current video mode
		int	10h

		cmp	al, 03h
		je	@@color
		cmp	al, 07h
		je	@@mono

		mov	ax,03		; If unknown set "Color 80x25"
		int	10h
@@color:
		mov	video_seg, 0B800h
		jmp	@@done
@@mono:
		mov	video_seg, 0B000h
@@done:
		clc
@@error:		
		ret
		
setup_segs	endp

;----------------------------------------------------------------------

check_os	proc	near
		;
		;  Arguments:	none
		;  Returns:	AX - OS type
		;  Destroys:	ax, bx, cx, dx, si, di, es
		;
		;	1 - MS-DOS <5.00
		;	2 - MS-DOS  5.xx-7.xx
		;	3 - Windows 2.xx-3.xx
		;	4 - Windows 95/98/...
		;	5 - Windows NT
		;
		mov	si, 1		; DOS < 5.00

		mov	ax, 3000h	; Get DOS version
		int	21h
		cmp	al, 5
		jb	@@check_win

		mov	si, 2		; DOS 5.xx - 7.xx

		mov	ax, 3306h	; Get true DOS version
		int	21h
		
		cmp	bx, 3205h	; Win NT dos box returns v5.50
		jne	@@check_win
		
		mov	si, 5		; Win NT
		jmp	@@end
@@check_win:
		mov	ax, 1600h	; Get Windows version
		int	2Fh
		cmp	al, 0
		je	@@no_win
		cmp	al, 80h
		je	@@no_win

		mov	si, 3		; Windows 2.xx - 3.xx
		
		cmp	al, 0FFh	; Windows 2.xx
		je	@@end

		cmp	al, 3		; else al=major (>=3)
		je	@@end		;      ah=minor (.xx)

		mov	si, 4		; Windows 95/98 GUI
		jmp	@@end
@@no_win:
@@end:
		mov	ax, si

		ret
check_os	endp

;----------------------------------------------------------------------

printf_16rm	proc	far

		push	bp
		mov	bp, sp
		push	ax
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		cld
		mov	si, [bp+6]
		mov	di, bp
		add	di, 8
@@next_char:
		lodsb
		cmp	al, 0
		je	@@end
		cmp	al, '%'
		jne	@@print_char
		lodsb
		cmp	al, 0
		je	@@end
		cmp	al, '%'
		je	@@print_char
		mov	bx, 10
		cmp	al, 'd'
		je	@@print_num
		cmp	al, 'u'
		je	@@print_num
		mov	bx, 16
		cmp	al, 'x'
		je	@@print_num
		cmp	al, 'X'
		je	@@print_num
@@print_char:
		mov	ah, 0Eh
		mov	bh, 00h
		int	10h
		jmp	@@next_char
@@print_num:
		mov	ax, ss:[di]
		add	di, 2
		xor	cx, cx
@@next_div:
		xor	dx, dx
		div	bx
		push	bx
		mov	bx, dx
		mov	dl, cs:printf_tab[bx]
		pop	bx
		push	dx
		inc	cx
		or	ax, ax
		jnz	@@next_div
@@print_dg:
		pop	ax
		mov	ah, 0Eh
		mov	bh, 00h
		int	10h
		loop	@@print_dg
		jmp	@@next_char
@@end:		
		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		
		pop	bp
		retf

printf_16rm	endp

;----------------------------------------------------------------------
_TEXT16		ends		; That's all we have to do in real mode
;----------------------------------------------------------------------

_DATA16		segment		; Data for the protected mode functions

align	2

psp_sel		dw	?
video_sel	dw	?

code16_sel	dw	?
data16_sel	dw	?

buffer_sel	dw	?
data3x_sel	dw	?

code32_sel	dw	?
data32_sel	dw	?

align	4

pm32_stack	label	fword
pm32_esp	dd	?
pm32_ss		dw	?
		dw	?

pm32_entry	label	fword
pm32_eip	dd	?
pm32_cs		dw	?
		dw	?

big_data_size	dd	?	; total size of the data32_seg (0..ESP)

_DATA16	ends

;----------------------------------------------------------------------
include		ext32dpm.inc	; DPMI protected mode stuff
;----------------------------------------------------------------------

_TEXT16		segment		; 16-bit protected mode code 

switch_to32bit	proc	near	; PM initialization routines will jump
								; here
		;
		;  Copy initialized DATA above 1M and clear BSS
		;  
		;
		push	ds

		cld
		mov	es, data32_sel
		mov	ds, data3x_sel
		mov	esi, 0
		mov	edi, 0
		mov	ecx, offset data32_end
		shr	ecx, 2
		rep			; copy data
		  movsd

		xor	eax, eax
		mov	ecx, offset bss_end
		sub	ecx, offset bss_start
		shr	ecx, 2
		rep			; clear bss
		  stosd
		
		pop	ds

		;
		;  Prepare segment registers and jump 
		;
		mov	gs, data16_sel
		mov	fs, buffer_sel

		mov	ax,  data32_sel		; Setting up stack
		mov	ebx, big_data_size

		mov	pm32_ss, ax
		mov	pm32_esp, ebx

		mov	ax,  code32_sel		; Setting up entry point
		mov	ebx, offset start32

		mov	pm32_cs,  ax
		mov	pm32_eip, ebx

		lss	esp, pm32_stack		; Switching stack
		mov	es,  data32_sel		; Switching extra segment
		mov	ds,  data32_sel		; Switching data  segment

		jmp	cs: pm32_entry

switch_to32bit	endp

_TEXT16		ends

;----------------------------------------------------------------------

ASSUME	CS:CODE, DS:DGROUP, GS:SGROUP

public	idle
public	exit
public  detected_system

_BSS		segment
cmd_line	DB	80h Dup(?)
_BSS		ends

_TEXT		segment			; 32-bit protected mode code

start32		proc	far

	extrn	main: near
	extrn	mem_lib_init: near

		mov	ebx, esp	; Initializing memory management
		sub	ebx, STACK_SIZE
		mov	eax, offset bss_end
		sub	ebx, eax
		push	ebx	; heap_size
		push	eax	; heap_start
		call	mem_lib_init
		add	esp, 8
		
		push	ds		; Copy command line arguments
		mov	ds, psp_sel
		mov	esi, 81h
		movzx	ecx, byte ptr[esi-1]
		mov	edi, offset cmd_line
		cld
		mov	al, '*'		; fake argv[0]
		stosb
		rep
		  movsb
		pop	ds

		
		xor	ebx, ebx	; Now lets split command line
		push	ebx
@@kill_spaces:
		mov	byte ptr[edi], 0
		cmp	edi, offset cmd_line
		jbe	@@cmd_done
		dec	edi
		cmp	byte ptr[edi], 32	; Space
		je	@@kill_spaces
		cmp	byte ptr[edi], 9	; Tab
		je	@@kill_spaces
@@skip_words:
		mov	esi, edi
		cmp	edi, offset cmd_line
		jbe	@@last_arg
		dec	edi
		cmp	byte ptr[edi], 32	; Space
		je	@@white_space
		cmp	byte ptr[edi], 9	; Tab
		jne	@@skip_words
@@white_space:
		push	esi		; Remember argument address 
		inc	ebx		; Increase argument's count
		jmp	@@kill_spaces
@@last_arg:
		push	esi
		inc	ebx
@@cmd_done:
		mov	eax, esp
		push	eax		; Array of arguments  (argv)
		push	ebx		; Number of arguments (argc)
		call	main		; Now calling main procedure
		add	esp, 8
		
		push	eax
		call	exit

start32		endp

;----------------------------------------------------------------------

exit		proc	C	near

		arg	@@status: dword
		
		mov	al, byte ptr @@status
		mov	ah, 4Ch
		int	21h

exit		endp

;----------------------------------------------------------------------

rm_int		macro	int_num, seg_mode

		push	int_num
		push	seg_mode
		call	dpmi_rm_int
		add	esp, 6
		popf

		endm

;----------------------------------------------------------------------

dpmi_rm_int	proc	C	near

		arg	@@seg_mode: dword, @@int_num: dword
		local	@@r: registers

		mov	@@r.reg_eax, eax
		mov	@@r.reg_ebx, ebx
		mov	@@r.reg_ecx, ecx
		mov	@@r.reg_edx, edx
		mov	@@r.reg_esi, esi
		mov	@@r.reg_edi, edi

		pushf
		pop	ax
		mov	@@r.reg_flags, ax

		mov	ax, data16_seg
		mov	bx, buffer_seg
		
		cmp	@@seg_mode, 1
		jne	@@dont_switch
		xchg	ax, bx
@@dont_switch:

		mov	@@r.reg_ds, ax
		mov	@@r.reg_es, bx

		mov	ax, stack_seg
		mov	@@r.reg_ss, ax
		mov	@@r.reg_sp, 400h

		mov	ax, 0300h		; Generate real mode int
		mov	bl, byte ptr @@int_num
		mov	bh, 0
		xor	cx, cx
		lea	edi, @@r
		push	es
		push	ss
		pop	es
		int	31h
		pop	es

		mov	ax, @@r.reg_flags
		mov	word ptr @@int_num+2, ax

		mov	eax, @@r.reg_eax
		mov	ebx, @@r.reg_ebx
		mov	ecx, @@r.reg_ecx
		mov	edx, @@r.reg_edx
		mov	esi, @@r.reg_esi
		mov	edi, @@r.reg_edi

		ret

dpmi_rm_int	endp

;----------------------------------------------------------------------

detected_system	proc	C	near

		movzx	eax, detected_os
		ret

detected_system	endp

;----------------------------------------------------------------------

idle		proc	C	near

		cmp	detected_os, 0	; Is it a bare system?
		je	@@end

		rm_int	28h, 0		; DOS / Windows IDLE 
@@end:
		ret

idle		endp

;----------------------------------------------------------------------
_TEXT		ends
;----------------------------------------------------------------------

include		ext32con.inc	; 32-bit console I/O functions
include		ext32dsk.inc	; 32-bit hard disk I/O functions

;----------------------------------------------------------------------

		end	dos_startup
