#ifndef _EXT32_H
#define _EXT32_H

/*--------------  Keyboard and Screen IO  --------------*/

int detected_system(void);
/*
	1 - MS-DOS <5.00
	2 - MS-DOS  5.xx-7.xx
	3 - Windows 2.xx-3.xx
	4 - Windows 95/98/...
	5 - Windows NT
*/

int kb_hit(void);
int get_key(void);
int put_key(int scan_code); /* put key into keyb buffer */

void move_cursor( int  x, int  y );
void save_cursor( int *x, int *y );

void write_string( int attr, int x, int y, char *str );
void write_block( int attr, int x, int y, char *str );
void save_window( int x, int y, int w, int h, char *buf );
void load_window( int x, int y, int w, int h, char *buf );
void clear_window( int attr, int x, int y, int w, int h );
void border_window( int attr, int x, int y, int w, int h, char *border );

/*-------------------  Hard Disk IO  -------------------*/

typedef unsigned long  Sector;

typedef struct disk_info
    {
     long   flags;
     long   hd_num;
     long   num_cyls;
     long   num_heads;
     long   sect_per_track;
     long   sect_per_cyl;
     Sector total_sects;
    }DiskInfo;

int disk_get_info(int hd, DiskInfo *); /* returns num_disks, on error -1 */

int disk_read(DiskInfo *, Sector rel_sect, void *buf, Sector num_sects);
int disk_write(DiskInfo *, Sector rel_sect, void *buf, Sector num_sects);
int disk_verify(DiskInfo *, Sector rel_sect, Sector num_sects);

/*---------------------  File IO  ---------------------*/

#define O_RDONLY 0
#define O_WRONLY 1
#define O_RDWR   2

#define O_CREAT  0x0100
#define O_TRUNC  0x0200

#define O_TEXT   0x4000   /* Not implemented */
#define O_BINARY 0x8000   /* Not implemented */

#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

#define stdin  0
#define stdout 1
#define stderr 2

int open(char *path, int mode);
int close(int fd);

int lseek(int fd, int offset, int fromwhere);

int read(int fd, void *buf, int len);
int write(int fd, void *buf, int len);

/*------------------------  std C staff  ------------------------*/

void exit(int status);

void *malloc(int len);
void free(void *);
int mem_left(void);
int mem_largest(void);

int printf(char *, ... );
int sprintf(char *, char *, ... );
int fprintf(int fd, char *, ... );
int vsprintf(char *, char *, void *);
int vfprintf(int fd, char *, void *);

int cprintf(int attr, int x, int y, char *, ... );
int vcprintf(int attr, int x, int y, char *, void *);

int  memcmp(void *s1, void *s2, int n); 
void *memset(void *dest, int c, int n);       /* returns dest */
void *memmove(void *dest, void *src, int n ); /* returns dest */

int strlen(char *s);
int strcmp(char *s1, char *s2);
int strcmpi(char *s1, char *s2);
int strncmp(char *s1, char *s2, int n);
int strncmpi(char *s1, char *s2, int n);
char *strcat(char *dest, char *src);         /* returns dest */
char *strcpy(char *dest, char *src);         /* returns dest */
char *strncpy(char *dest, char *src, int n); /* returns dest */

/*------------------------  Colors  ------------------------*/

#define  Black      0x00               /* Foreground colors */
#define  Blue       0x01
#define  Green      0x02
#define  Cyan       0x03
#define  Red        0x04
#define  Magenta    0x05
#define  Brown      0x06
#define  White      0x07
            
#define  Gray       0x08
#define  BrBlue     0x09
#define  BrGreen    0x0A
#define  BrCyan     0x0B
#define  BrRed      0x0C
#define  BrMagenta  0x0D
#define  Yellow     0x0E
#define  BrWhite    0x0F


#define  BakBlack      0x00            /* Background colors */
#define  BakBlue       0x10
#define  BakGreen      0x20
#define  BakCyan       0x30
#define  BakRed        0x40
#define  BakMagenta    0x50
#define  BakBrown      0x60
#define  BakWhite      0x70

#define  Blink         0x80

/*------------------------  ??????  ------------------------*/

#endif
