;
;  Protected mode DPMI initialization functions
;

registers	struc
reg_edi		dd	?
reg_esi		dd	?
reg_ebp		dd	?
reg_reserved	dd	?
reg_ebx		dd	?
reg_edx		dd	?
reg_ecx		dd	?
reg_eax		dd	?
reg_flags	dw	?
reg_es		dw	?
reg_ds		dw	?
reg_fs		dw	?
reg_gs		dw	?
reg_ip		dw	?
reg_cs		dw	?
reg_sp		dw	?
reg_ss		dw	?
		ends

DPMI_mem_info	struc
largest_block	dd	?	; largest available block in bytes
max_unlocked_pg	dd	?	; maximum unlocked page allocation
max_locked_pg	dd	?	; maximum locked page allocation
total_linear_pg	dd	?	; total linear address space in pages
total_unlocked	dd	?	; total unlocked pages
free_pages	dd	?	; free pages
total_phy_pg	dd	?	; total physical pages
free_linear_pg	dd	?	; free linear address space in pages
swap_size_pg	dd	?	; size of paging file/partition in pages
dpmi_mi_resrvd	db  12 Dup(?) 	; reserved
		ends


allocate_dsc	macro	sel

		mov	ax, 0000h	; Allocate one descriptor
		mov	cx, 0001h
		int	31h
		jc	@@error
		mov	sel, ax
endm


get_seg_base	macro	sel		; On return CX:DX = segment base 

		mov	ax, 0006h	; Get segment base
		mov	bx, sel
		int	31h
		jc	@@error
endm


set_seg_base	macro	sel		; On entry CX:DX = segment base

		mov	ax, 0007h	; Get segment base
		mov	bx, sel
		int	31h
		jc	@@error
endm


get_seg_limit	macro	sel		; On return CX:DX = segment limit

		push	eax
		mov	ax, sel
		movzx	eax, ax
		lsl	eax, eax	; Load segment limit
		mov	dx, ax
		shr	eax, 16
		mov	cx, ax
		pop	eax
endm


set_seg_limit	macro	sel		; On entry CX:DX = segment limit

		mov	ax, 0008h	; Get segment base
		mov	bx, sel
		int	31h
		jc	@@error
endm


get_seg_rights	macro	sel		; On return CX = segment access rights

		mov	cx, cs
		lar	cx, cx		; Load access rights
endm

set_seg_rights	macro	sel		; On entry CX = segment access rights

		mov	ax, 0009h	; Set descriptor access rights
		mov	bx, sel
		int	31h
		jc	@@error
endm

;----------------------------------------------------------------------

_TEXT16		segment		; 16-bit protected mode code


DPMI_init_PM	proc	C	near

		local	@@mem_addr: dword, \
			@@mem_hndl: dword, \
			@@mem_size: dword, \
			@@r:registers, \
			@@d:DPMI_mem_info

		;
		; Protected mode DPMI initializations
		;
		mov	psp_sel, es
		
		mov	code16_sel, cs
		mov	data16_sel, ds
		mov	buffer_sel, ss

		check_point 5

		;
		;   Allocate and locks largest block of available memory
		;
		mov	ax, 0500h	; Get memory info
		push	ss
		pop	es
		lea	edi, @@d
		int	31h
		jc	@@error
		
		check_point 6

		mov	ebx, @@d.largest_block	; of available memory
		cmp	detected_os, 3
		jb	@@not_windows
@@split:
		shr	ebx, 1		; We will take only half
@@not_windows:
		sub	ebx,     10000h ; Leaving 64k of memory alone
		jc	@@error
		and	ebx, 0FFFFF000h	; Align on 4k page boundary
		mov	@@mem_size, ebx
		
		mov	ax, 0501h	; Allocate memory block
		mov	bx, word ptr @@mem_size+2
		mov	cx, word ptr @@mem_size
		int	31h
		;jc	@@error
		jc	@@split
		
		check_point 7

		mov	word ptr @@mem_addr+2, bx
		mov	word ptr @@mem_addr,   cx
		mov	word ptr @@mem_hndl+2, si
		mov	word ptr @@mem_hndl,   di
		
		mov	ax, 0600h	; Lock linear region
		mov	si, word ptr @@mem_size+2
		mov	di, word ptr @@mem_size
		int	31h
		jc	@@error

		check_point 8

		mov	eax, @@mem_size	  ; Do we have enough memory?
		mov	ebx, STACK_SIZE
		add	ebx, offset dgroup_end
		cmp	eax, ebx
		jb	@@error
		
		check_point 9
		
		mov	big_data_size, eax

		;
		;  Now we are setting up CODE32 descriptor
		;

		allocate_dsc	code32_sel
		
		get_seg_rights	code16_sel
		mov	cl, ch  ;   ;   ;   ;
		and	cx, 0000000001100000b   ; We need only DPL
		or	cx, 0100000010011010b	; 32-bit code segment
		set_seg_rights	code32_sel

		movzx	ecx, code32_seg
		shl	ecx, 4
		mov	dx, cx
		shr	ecx, 16
		set_seg_base code32_sel
		
		mov	ecx, offset code32_end
		shl	ecx, 4
		sub	ecx, 1
		mov	dx, cx
		shr	ecx, 16
		set_seg_limit	code32_sel

		check_point 10
		
		;
		;  Allocating selector to access video memory
		;
		mov	ax, 0002h   ; Real mode segment to descriptor
		mov	bx, video_seg
		int	31h
		jc	@@error
		mov	video_sel, ax

		check_point 11
		
		;
		;  Now we are setting up DATA32 descriptors
		;

		allocate_dsc	data3x_sel	; data under 1M
		allocate_dsc	data32_sel	; data above 1M (large)

		get_seg_rights	data16_sel
		mov	cl, ch  ;   ;   ;   ;
		and	cx, 0000000001100000b   ; We need only DPL (60h)
		or	cx, 0100000010010010b	; small 32-bit data segment
		set_seg_rights	data3x_sel
		and	cx, 0000000001100000b   ; We need only DPL (60h)
		or	cx, 1100000010010010b	; large 32-bit data segment
		set_seg_rights	data32_sel
		
		movzx	ecx, data32_seg
		shl	ecx, 4
		mov	dx, cx
		shr	ecx, 16
		set_seg_base data3x_sel
		
		mov	ecx, offset data32_end
		shl	ecx, 4
		sub	ecx, 1
		mov	dx, cx
		shr	ecx, 16
		set_seg_limit	data3x_sel

		mov	cx, word ptr @@mem_addr+2
		mov	dx, word ptr @@mem_addr
		set_seg_base	data32_sel

		mov	ecx, @@mem_size
		sub	ecx, 1
		mov	dx, cx
		shr	ecx, 16
		set_seg_limit	data32_sel

		check_point 12
		
		;
		;  Now we are going to switch to 32-bit code
		;

		jmp	switch_to32bit

		;
		;  Print error and exit
		;
@@error:
		mov	ax, last_check_pt
		push	ax
		mov	si, offset err_msg_dpmi
		push	si

		mov	ax, data16_seg
		mov	@@r.reg_ds, ax

		mov	ax, stack_seg
		mov	@@r.reg_ss, ax
		mov	@@r.reg_sp, 400h

		mov	ax, code16_seg
		mov	@@r.reg_cs, ax
		mov	@@r.reg_ip, offset printf_16rm

		mov	ax, 0301h	; Call real mode function
		mov	bh, 0
		mov	cx, 4		; copy 4 bytes from stack
		push	ss
		pop	es
		lea	edi, @@r
		int	31h

		pop	ax
		pop	ax

		mov	al, 1
		mov	ah, 4Ch
		int	21h

DPMI_init_PM	endp

;----------------------------------------------------------------------
_TEXT16		ends
;----------------------------------------------------------------------
