; Ranish Partition Manager   Copyright (C) 1998 by Mikhail Ranish
; This code is distributed under GNU General Public License (GPL)
; The full text of the license can be found at http://www.gnu.org
;
; ipl.asm - code for the Initial Program Loader that resides in MBR
;
PAGE 255,132
.MODEL SMALL
.DATA
LOCALS
ASSUME	CS:_DATA, DS:_DATA
PUBLIC	BM_IPL, STD_IPL, EMP_IPL
.386

VIRUS		EQU	(M1-start-100h)
ERROR		EQU	(M2-start-100h)
NL_BOOT		EQU	(M3-start-100h)
BOOTING		EQU	(M4-start-100h)
HD_NUM		EQU	(M5-start-100h)
NL		EQU	(M6-start-100h)

BM_NUM_SECT	EQU	62

		;
		;  Known problems:
		;
		;     1. IPL will always read BM_NUM_SECT sectors from hd
		;     2. IPL will always use LBA mode iff Cyl=1023 and Sect=1
		;     3. ...
		;

BM_IPL		PROC	NEAR
		;
		;  BIOS loads MBR at 0000:7C00h
		;
start:
		xor	bp, bp
		mov	ds, bp
		mov	es, bp
		mov	ss, bp		; CPU disables ints for the next op
		mov	sp, 7C00h
		mov	si, sp
		push	si		; This is where we jump to boot sector
		mov	di, 0600h	; First we move the code to 0000:0600h
		mov	cx, 0100h
		cld
		rep	movsw
		;jmp to new location
		  DB	0E9h
		  DW	-(7C00h-0600h)
		;
		;  Check hard disk number
		;
		cmp	dl, 80h
		jae	@@hd_ok
		mov	dl, 80h
@@hd_ok:
		mov	al, dl
		sub	al, 80h-'1'
		mov	[di-800h+700h+HD_NUM], al
		;
		;
		mov	bl, BOOTING
		test	byte ptr[di-800h+7BAh],1 ;test OPTIONS,1
		jz	@@no_virus	; Don't check for viruses
		;
		;  Check interrupt vectors
		;
		mov	si, 04*1Ch+03	; Check interrupts 0 to 1Ch
		mov	al, 0C0h	; they must be >= C000:0000
		cmp	al, [si+0B4h]	; int 4Ah - User Alarm
		ja	@@int_changed
		cmp	al, [si+14Ch]	; int 70h - Real-Time Clock
		ja	@@int_changed
@@next_int:
		sub	si, 4
		jc	@@no_virus	; all checked - no virus found
		cmp	al, [si]
		jbe	@@next_int
@@int_changed:
		mov	bl, VIRUS
		call	print
@@get_a_key:
		mov	ah, 0		;  Get a key
		int	16h
		cmp	al, 0Dh		;  Is it Enter?
		jne	@@get_a_key
		mov	bl, NL_BOOT
@@no_virus:
		call	print

		mov	al, [di-800h+7BBh]
		cmp	al, 0		; is there default partition
		jg	@@m4

		;
		;  Find active partition
		;
@@pt1:
		mov	al, '0'
		mov	di, 07AEh
@@pt2:
		cmp	[di], ch ; 00
		mov	[di], dl
		jnz	@@pt3		; Active partition found
		mov	[di], ch ; 00
		add	di, 10h
		inc	ax
		cmp	al, '4'
		jbe	@@pt2
		;
		mov	di, 7B2h	; No active partition found
		cmp	[di], ch ; 00
		mov	al, 26		; Booting from the next hard drive
		jne	@@pt3
		mov	al, 'A'		; Booting from the first floppy disk
		xor	bp, bp		; Don't save changes in this case
@@pt3:
		mov	ah, 0Eh
		mov	bh, 00h
		int	10h		; Print a character
		;
		;  Load boot sector from disk
		;
		pop	bx	 	; Destination Address = 7C00h
		push	bx

		mov	cl, 3		; We will try at most three times
@@read_again:
		pusha
		mov	bp, sp

		mov	ax,  0201h	; Read using CHS mode
		mov	cx, [di+02]	; Cyl#, Sect#
		mov	dx, [di+00]	; Head, Drive in DL

		cmp	cl, al		; if partition is empty (sect=0)
		jb	@@skip_int13

		cmp	dl, al		; If we are on HD read BM_NUM_SECT
		jb	@@call_int13
		mov	al, BM_NUM_SECT

		cmp	cx, 0FFC1h	; Cyl=1023, Sect=1
		jne	@@call_int13

		push	ds	; 0	; Read using LBA mode
		push	ds	; 0
		push	dword ptr[di+8]	; rel_sect
		push	ds		;  segment
		push	bx		;  address
		mov	ah, 0
		push	ax		; num_sect
		mov	al, 10h
		push	ax		; pkt_size
		mov	ah, 42h
		mov	si, sp
@@call_int13:
		int	13h
@@skip_int13:
		mov	sp, bp
		jnc	@@read_ok
@@disk_reset:
		mov	ah, 0		; We get here if there was an error
		int	13h		; We will try to reset device
		popa

		loop	@@read_again
		mov	bl, ERROR	; We tried three times, so we give up
		jmp	short @@m2
@@read_ok:
		popa
		;
		;  Print dots and check if key is pressed
		;
		mov	ax, 092Eh	; Print 30 dots
		mov	bx, 0007h
		mov	cl, 30
		int	10h

		cmp	di, 7AEh	; if we are loading boot manager
		je	@@dont_wait
@@check_key:
		mov	ah, 01h		; Check if key is pressed
		int	16h
		jz	@@print_sp

		cmp	al, 1Bh		; There is a key - is it ESC?
		jne	@@end

		mov	ah, 00		; Remove ESC from keyboard buffer
		int	16h
		jmp	short @@end
@@print_sp:
		mov	ax, 0E20h
		int	10h		; Print a SPACE
		pusha
		mov	ah, 86h		; Wait for a while
		mov	cl, [bx-7+7BAh]	; TIMEOUT
		shr	cx, 2
		sar	dh, 1
		int	15h
		popa

		loop	@@check_key
@@dont_wait:
		mov	al, 1Bh
@@end:
		push	ax
		mov	ax, 0920h	; Print rest of SPACEs
		int	10h
		mov	bl, NL
		call	print
		pop	ax

		cmp	al, 1Bh		; User hit ESC or timeout
		je	@@save

		mov	bl, 0
		cmp	al, ' '		; On Space print prompt and wait
		jne	@@m4
		;
		; Select new partition
		;
@@m1:
		mov	bl, BOOTING
@@m2:
		call	print
@@m3:
		mov	ah, 00h
		int	16h		; Read character
@@m4:
		mov	si, 7B2h	; FD_PARAMS
		mov	ah, 0

		cmp	al, 'A'		; Floppy disk
		je	@@m6

		cmp	al, 'a'		; Floppy disk
		je	@@m6

		mov	ah, dl
		inc	ah
	
		cmp	al, 09		; Tab - Next hard drive
		je	@@m6

		sub	al, '0'		; One of the partitions
		cmp	al, 05h
		jb	@@m5
		or	bl, bl
		;jz	@@save		; wrong key, but not for us
		jnz	@@m3		; wrong key, so lets ask again
		;
		; Save changes to disk
		;
@@save:
		or	bp, bp		; Do we have to save (0=don't)
		jz	@@boot
		mov	ax, 0301h	; Write (AH=03) 1 Sector (AL=01)
		mov	bx, 0600h	; Source located at address 600h
		mov	cl, 01h		; Cyl = 0, Sect = 1
		mov	dh, 00h		; Head = 0, Drive in DL
		int	13h
@@boot:
		mov	dl, [di]	; Boot sector expects Drive# in DL
		;jmp	7C00h		; Transfer control to the boot sector
		ret			; We've pushed 7C00h at the beginning
		;
		;  Setting active partition
		;
@@m5:
		mov	si, 7AEh
		mov	ah, 10h
		mul	ah
		add	si, ax
		mov	ah, dl

		cmp	[si], ah
		jne	@@m6
		dec	bp
@@m6:
		or	bl, bl
		jz	@@m1

	      ;	mov	bx, 07AEh
		mov	bl, 00AEh ; Assuming bh=07 (left from print function)
		mov	cl, 5
@@cl1:
		mov	[bx], ch ;ch=0
		add	bl, 10h
		loop	@@cl1

		mov	[si], ah
		inc	bp
		jmp	@@pt1

		;
		;  Print
		;
@@next_char:
		mov	bh, 00h
		int	10h
		inc	bx
print:
		mov	ax, 0E00h
		mov	bh, 07h
		add	al, [bx]
		jnz	@@next_char
		ret
		;
		;
		;
M1:		DB "Virus! ",0
M2:		DB " Error!"
M3:		DB 13, 10
M4:		DB "Booting HD"
M5:		DB "1/",0
M6:		DB 13, 10, 0

GAP:
GAPLEN		EQU	(1AEh-(GAP-start))
IF GAPLEN
	DB	GAPLEN DUP(0)
ENDIF

;BM_CHS  DD	0		; 7AEh
;FD_CHS  DB	00,00,01,00	; 7B2h
;BM_REL  DD	0		; 7B6h
;TIMEOUT DB	0		; 7BAh
;DEFAULT DB	0		; 7BBh
;BM_SIGN DB	'BM'		; 7BCh

;	DB	40h DUP(0)
;	DB	055h, 0AAh

	DB	  2 DUP(0)	; Align to multiple of 16 bytes

BM_IPL		ENDP



STD_IPL		PROC	NEAR

		;
		;   IPL that comes with MS-DOS's fdisk.exe
		;

		CLI
		XOR	AX,AX
		MOV	SS,AX
		MOV	SP,7C00h
		MOV	SI,SP
		PUSH	AX
		POP	ES
		PUSH	AX
		POP	DS
		STI
		CLD
		MOV	DI,0600h
		MOV	CX,0100h
		REPNZ
		MOVSW
	      ;	JMP	0000:061D
		DB	0EAh
		DW	061Dh, 0000h
@@_061D:
		MOV	SI,07BEh
		MOV	BL,04h
@@_0622:
		CMP	BYTE PTR [SI],80h
		JZ	@@_0635
		CMP	BYTE PTR [SI],00h
		JNZ	@@_0648
		ADD	SI,10h
		DEC	BL
		JNZ	@@_0622
		INT	18h
@@_0635:
		MOV	DX,[SI]
		MOV	CX,[SI+02]
		MOV	BP,SI
@@_063C:
		ADD	SI,10h
		DEC	BL
		JZ	@@_065D
		CMP	BYTE PTR [SI],00
		JZ	@@_063C
@@_0648:
		MOV	SI,068Bh
@@_064B:
		LODSB
		CMP	AL,00
		JZ	@@_065B
		PUSH	SI
		MOV	BX,0007
		MOV	AH,0Eh
		INT	10h
		POP	SI
		JMP	@@_064B
@@_065B:
		JMP	@@_065B
@@_065D:
		MOV	DI,0005h
@@_0660:
		MOV	BX,7C00h
		MOV	AX,0201h
		PUSH	DI
		INT	13h
		POP	DI
		JNB	@@_0678
		XOR	AX,AX
		INT	13h
		DEC	DI
		JNZ	@@_0660
		MOV	SI,06A3h
		JMP	@@_064B
@@_0678:
		MOV	SI,06C2h
		MOV	DI,7DFEh
		CMP	WORD PTR [DI],0AA55h
		JNZ	@@_064B
		MOV	SI,BP
	      ;	JMP	0000:7C00
		DB	0EAh
		DW	7C00h, 0000h

@@_068B:	DB	"Invalid partition table",0
@@_06A3:	DB	"Error loading operating system",0
@@_06C2:	DB	"Missing operating system",0

              ;	DB	291 DUP(0)	; Align to 510 bytes
	      ;	DB	055h, 0AAh

		DB	  5 DUP(0)	; Align to multiple of 16 bytes

STD_IPL		ENDP


EMP_IPL		PROC
		;
		;  Code for empty boot record to display message like
		;
		;  "Partition is not bootable ..."
		;
		;  Then wait until user hits a key and reboot.
		;
		jmp	short @@call
@@print:	pop	si
		mov	ah, 0Eh
		mov	bh, 00h
@@next_char:
		lodsb
		int	10h
		cmp	[si], bh
		jne	@@next_char
		
		mov	ah, 0
		int	16h
		mov	ax, 0E0Dh
		int	10h
		mov	al, 0Ah
		int	10h
		int	19h
@@call:
		call	@@print
@@msg:
		; Put the null terminated message here (after the code)

EMP_IPL		ENDP

END
