/*
 Ranish Partition Manager   Copyright (C) 1998 by Mikhail Ranish
 This code is distributed under GNU General Public License (GPL)
 The full text of the license can be found at http://www.gnu.org
*/

#define   PART_C
#include "part.h"


void main(int argc, char **argv)
{
 int hd=0x80;

 if( argc>2 && strcmpi(argv[1],"-d")==0 &&
     argv[2][0]>='1' && argv[2][0]<='8' )
   {
    hd+=argv[2][0]-'1';
    argc-=2;
    argv+=2;
   }

 if( argc>1 )
   {
    start_cmd(hd,argc,argv);
   }
 else 
   {
    gui_init();
    start_gui(hd);
    gui_done();
   }

 exit(0);
}

#define FORCE(x)    ((force) |=  (x))
#define RESET(x)    ((force) &= ~(x))
#define NEED_TO(x)  ((force)  &  (x))

#define GET_DISK_INFO     0x0001
#define REDRAW_SCREEN     0x0002
#define REDRAW_PART_TABLE 0x0004
#define READ_PART_TABLE   0x0008
#define SAVE_PART_TABLE   0x0010
#define SORT_PART_TABLE   0x0020
#define CLEAR_PART_TABLE  0x0040

void start_gui(int hd)
{
 char *hint, *mesg, *warn;
 int i, j, k, n, n_pri, mode, num_disks;
 int top, row, col, old_top, old_row, old_col, force;
 int mbr_hash, bm_hash, changed;
 Part part[N_ROWS], part2[4], *p;
 Sector sv_start_cyl, sv_last_sect;
 DiskInfo disk_info, *di=&disk_info;

 mode=MODE_CHS;
 
 top=0;
 row=0;
 col=1;
 warn=0;
 mesg=0;
 force=0;

 FORCE(GET_DISK_INFO);

 if( detected_system() >= 3 )
  warn="Warning! Modifying partitions under Windows may cause data corruption";
  
 while(1)
    {
     if( NEED_TO(CLEAR_PART_TABLE) )
       {
        for( i=0 ; i<N_ROWS ; i++ )
          free_part_info(&part[i]);
        RESET(CLEAR_PART_TABLE);
       }

     if( NEED_TO(GET_DISK_INFO) ) 
       {
        memset(di,0,sizeof(DiskInfo));
        di->hd_num=hd;
        redraw_main_screen(di,mode);
        redraw_main_hint(HINT,MESG_GETTING);
        if( (num_disks=disk_get_info(hd,di))==-1 )
          {
           show_error(ERROR_DISK_INFO);
           if( hd==0x80 ) break;
           hd=0x80;
           continue;
          }
        RESET(GET_DISK_INFO);
        FORCE(REDRAW_SCREEN + READ_PART_TABLE);
       }

     if( NEED_TO(REDRAW_SCREEN) ) 
       {
        redraw_main_screen(di,mode);
        RESET(REDRAW_SCREEN);
        FORCE(REDRAW_PART_TABLE);
       }

     if( NEED_TO(READ_PART_TABLE) )
       {
        redraw_main_hint(HINT,MESG_READING);
        if( read_part_table(di,part)==-1 )
          {
           show_error(ERROR_READ_PART_TABLE);
           if( hd==0x80 ) break;
           hd=0x80;
           FORCE(GET_DISK_INFO);
           continue;
          }
        changed=0;
        RESET(READ_PART_TABLE);
        FORCE(SORT_PART_TABLE);
       }

     if( NEED_TO(SORT_PART_TABLE) )
       {
        n=sort_part_table(di,part,&row);
        RESET(SORT_PART_TABLE);
        FORCE(REDRAW_PART_TABLE);
       }

     if( row >= n  ) row = n-1;
     if( top > row ) top = row;
     if( top+8 <= row ) top = row-7;
     if( top+8 > n   ) top = (n>8) ? (n-8) : 0;

     p = &part[row];

     if( top != old_top  ||  row != old_row  ||  col != old_col ) 
       {
        if( row != old_row )  clear_preview_box(0);
        if( col==0 && LOGICAL(p) )  col = 1; 
        old_top = top;
        old_row = row;
        old_col = col;
        FORCE(REDRAW_PART_TABLE);
       }

     if( NEED_TO(REDRAW_PART_TABLE) )
       {
        n_pri=prepare_mbr_records( part, part2 );
        redraw_part_table( top, row, col, part+top, 8, mode );
        redraw_part_table(   1,  -1,  -1, part2,    4, MODE_MINI );
        redraw_main_prompt( changed );

        for( i=0 ; i<n ; i++ )
         if( !VALID(&part[i]) )
           {
            if( i>=top && i<top+8 ) continue;
            clear_error( (i<top)?(-1):(+1) );
            break;
           }
        if( i==n ) clear_error(0);

        if( p->flags & P_ERR_ZERO      ) popup_error( ERR_ZERO      );
        if( p->flags & P_ERR_RANGE     ) popup_error( ERR_RANGE     );
        if( p->flags & P_ERR_OVERLAP   ) popup_error( ERR_OVERLAP   );
        if( p->flags & P_ERR_LOG_ORPH  ) popup_error( ERR_LOG_ORPH  );
        if( p->flags & P_ERR_LOG_STRU  ) popup_error( ERR_LOG_STRU  );
        if( p->flags & P_ERR_CANT_READ ) popup_error( ERR_CANT_READ );
        if( p->flags & P_ERR_BOOT_SECT ) popup_error( ERR_BOOT_SECT );


        RESET(REDRAW_PART_TABLE);
       }
     
     if( n_pri>4 )
       warn="You cannot have more than four primary partitions with this version";

          if( warn!=0 ) redraw_main_hint( WARNING, warn );
     else if( mesg!=0 ) redraw_main_hint( MESSAGE, mesg );
     else 
       {
             if( row==0 ) hint = HINT_MBR;
        else if( col==0 ) hint = HINT_ROW;
        else if( col==1 ) hint = UNUSED(p) ? HINT_WIZ : HINT_INS;
        else
          {
           hint=tmp;
           if( mode==MODE_CHS )
              sprintf(tmp,HINT_CHS, di->num_cyls - 1,
                                    di->num_heads - 1,
                                    di->sect_per_track );
           else
              sprintf(tmp,HINT_LBA, di->total_sects - 1,
                                    di->total_sects - p->rel_sect );
          }
        
        redraw_main_hint( HINT, hint );
       }

     warn=mesg=hint=0;

     OP_HANDLER( OP_PREVIEW, di, p, 0 );
     
     sv_start_cyl = p->start_cyl;
     sv_last_sect = p->last_sect;

     k = edit_part_col(p,col,mode);

     if( k==-1 ) /* numeric column was modified - we need to recalculate */
       {
        if( mode==MODE_CHS && p->start_cyl != sv_start_cyl )
          {
           if( p->start_cyl==0 && p->start_head==0 ) p->start_head=1;
           if( sv_start_cyl==0 && p->start_head==1 ) p->start_head=0;
          }
        recalculate_partition(di,p,mode);
        if( row>0 && LOGICAL(p) && EXTENDED(p-1) &&
            sv_last_sect == (p-1)->last_sect &&
            p->last_sect != (p-1)->last_sect &&
          !( p->last_sect < sv_last_sect && !LOGICAL(p-1) ) )
          {
           (p-1)->num_sect = p->last_sect + 1 - (p-1)->rel_sect;
           recalculate_partition(di,p-1,MODE_LBA);
          }
        changed = 1;
        FORCE(SORT_PART_TABLE+REDRAW_PART_TABLE);
        continue;
       }

     /* otherwise we got a key to handle */


     if( k>='a' && k<='z' )
       k -= 'a'-'A';       /* converting to uppercase */
     
     if( k==0x3B00 )  /* F1 - Help */
       {
        show_help(0);
        continue;
       }

     if( k=='S' || k=='L' )
       {
        show_error("Not implemented yet. Please, run \"part -p -r > some_file\" and print it.");
       }
       
     
     if( col==1 && k==13 )
       {
        if( UNUSED(p) )
          {
           part_new_wiz( di, part, &row, &n );
           FORCE(SORT_PART_TABLE + REDRAW_PART_TABLE);
          }
        else if( p->flags & OP_SETUP )
          {
           OP_HANDLER( OP_SETUP, di, p, 0 );
           FORCE(SORT_PART_TABLE + REDRAW_PART_TABLE);
          }
        continue;
       }

     if( changed && (k==27 || k==0x3F00) )   /* ESC or F5 */
       {
        i=dialog_box("You have made changes since the last save",
                     " Save MBR "," Don't save "," Continue editing ", 0 );
        if( i==0 || i==3 ) continue;
        if( i==1 ) FORCE(SAVE_PART_TABLE);
       }

     if( changed && (k=='F' || k=='R') )
       {
        i=dialog_box("You cannot do this opration until you save changes",
                     " Save MBR and proceed "," Continue editing ", 0 );
        if( i==0 || i==2 ) continue;
        if( i==1 ) FORCE(SAVE_PART_TABLE);
       }

     if( NEED_TO(SAVE_PART_TABLE) || k==0x3C00 )  /* F2 - Save */
       {
        RESET(SAVE_PART_TABLE);
        
        for( i=0 ; i<n ; i++ )
         if( !VALID_LOC(&part[i]) ) break;
        
        if( i!=n || n_pri>4 )
          {
           i=dialog_box("There are invalid records. Do you want to save them?",
                        " Yes. Save them as they are. "," No. Let me go back. ", 0 );
           if( i==0 || i==2 ) continue;
          }

        if( save_part_table(di,part)==-1 )
          {
           show_error(ERROR_SAVE_PART_TABLE);
           continue;
          }

        changed=0;
        mesg=MESG_PART_TABLE_SAVED;
        FORCE(SORT_PART_TABLE);    // ???
        if( k==0x3C00 ) /* F2 */
        continue;
       }

     if( k==27 ) break;


     if( k==0x3D00 ) /* F3 - Undo */
       {
        row=0;
        FORCE(CLEAR_PART_TABLE + READ_PART_TABLE);
        continue;
       }

     if( k==0x3E00 ) /* F4 - Mode */
       {
        if( mode==MODE_CHS )
          {
           mode = MODE_LBA;
                if( col>=5 ) col=3;
           else if( col>=2 ) col=2;
          }
        else
          {
           mode = MODE_CHS;
           if( col==3 ) col=5;
          }
        FORCE(REDRAW_SCREEN);
        continue;
       }

     
     if( k==0x3F00 ) /* F5 - Next HD */
       {
        row=0;
        hd=(hd-128+1)%num_disks + 128;     /* go to the next disk */
        FORCE(CLEAR_PART_TABLE + GET_DISK_INFO);
        continue;
       }
      
     if( k=='V' ) /* Verify */
       {
        int x;
        unsigned long bbt[9];
        x=verify_part(di,p,bbt,9);
             if( x==EV_OK     ) mesg = MESG_VERIFY_OK;
        else if( x==EV_CANCEL ) mesg = WARN_VERIFY_CANCEL;
        else show_bad_blocks(di,p,bbt,x);
        FORCE(REDRAW_SCREEN);
        continue;
       }

     if( k=='F' ) /* Format */
       {
        if( p->flags & OP_FORMAT )
          {
           OP_HANDLER( OP_FORMAT, di, p, 0 );
           OP_HANDLER( OP_VALIDATE, di, p, 0 );
           FORCE(REDRAW_SCREEN);
          }
        continue;
       }

     /*----------------------- Navigation ----------------------*/
     
     if( k==9 || k==13 ) /* tab or enter */
       {
        if( mode==MODE_CHS )
          {
                if( col<1 ) col=1;
           else if( col<2 ) col=2;
           else if( col<5 ) col=5;
           else col=1;
          }
        else
          {
                if( col<1 ) col=1;
           else if( col<2 ) col=2;
           else if( col<3 ) col=3;
           else col=1;
          }
        continue;
       }

     if( k==0x4700 ) /* home */
       {
        top=0;
        row=0;
        continue;
       }

     if( k==0x4F00 ) /* end */
       {
        row = n-1;
        continue;
       }

     if( k==0x4B00 ) /* left */
       {
        if(col>0) col--;
        continue;
       }

     if( k==0x4D00 ) /* right */
       {
        if(col<(mode==MODE_CHS?7:3) ) col++;
        continue;
       }

     if( k==0x4800 ) /* up */
       {
        if( row>0 ) row--;
        continue;
       }

     if( k==0x5000 ) /* down */
       {
        if( row<n-1 ) row++;
        continue;
       }
     if( k==0x4900 ) /* PgUp */
       {
        if( row==top )
          {
           top-=8;
           if( top<0 ) top=0;
          }
        row=top;
        continue;
       }
     if( k==0x5100 ) /* PgDn */
       {
        if( row==top+7 )
          {
           top+=8;
          }
        row=top+7;
        continue;
       }


     if( EMPTY(p) || row==0 ) continue;


     /*------------------- Editing ------------------------*/

     if( k==0x5200 ) /* ins */
       {
        i=p->fs_id;

        select_fs_type(p);

        if( p->fs_id!=i )
          {
           changed=1;
           free_part_info(p);
          }

        if( i==0 && p->fs_id!=0 )  /* was unused, but now some FS */
          {
           col=2;
           part_ins_wiz(di,part,&row,&n);
          }

        FORCE(REDRAW_SCREEN + SORT_PART_TABLE);
        continue;
       }

     if( UNUSED(p) ) continue;

     if( col==1 && k==0x5300 ) /* del */
       {
        free_part_info(p);
        memset(p,0,sizeof(Part));
        changed=1;
        FORCE(SORT_PART_TABLE);
        continue;
       }

     if( col==0 && (k==' ' || k==0x5300 || k>='1' && k<='4' ) )
       {
        p->mbr_row = ((k==' ' || k==0x5300) ? 0 : (k-'0'));
        changed=1;
        FORCE(REDRAW_PART_TABLE);
        continue;
       }

     if( k=='B' )
       {
        if( p->tag==0 && (EXTENDED(p) || LOGICAL(p)) )
          {
           warn="You cannot boot from extended or logical partitions with this version";
           continue;
          }

        p->tag=p->tag?0:0x80;
        if( p->tag!=0 )
         for( i=0 ; i<n ; i++ )
          if( i!=row ) part[i].tag=0;
          
        changed=1;
        FORCE(REDRAW_PART_TABLE);
        continue;
       }

     if( k=='H' || k=='h' ) /* Hide/Unhide */
       {
        if( p->flags & P_HIDABLE )
          {
           p->fs_id += 0x1000;
           find_fs_num(p);
           changed=1;
           FORCE(REDRAW_PART_TABLE);
          }
        else if( p->flags & P_UNHIDABLE )
          {
           p->fs_id -= 0x1000;
           find_fs_num(p);
           changed=1;
           FORCE(REDRAW_PART_TABLE);
          }
        continue;
       }

     sprintf(tmp,"key=%04X",k);
     write_string(White,70,5,tmp);
    }

 return;
}/* start_gui */


int h_deflt( int op, DiskInfo *di, Part *p, char **argv )
{
 if( op==OP_PREVIEW   ) clear_preview_box( UNUSED(p) ? MESG_WIZARD :
                                                       MESG_UNSUPPORTED );
 if( di==0 || argv==0 ) return 0;      /* this will make compiler happy */
 return 0;
}/* h_dflt */



int ipl_handler( int op, DiskInfo *di, Part *p, char **argv )
{
 BmData *bm;

 read_boot_sect(di,p,1);

 if( !BTS_LOADED(p) ) return 0;

 if( op==OP_VALIDATE || argv!=0 ) return 0;

 bm  = (BmData *)(p->part_misc_info);

 if( op==OP_PREVIEW ) redraw_ipl_options(bm,-1);
 else /* OP_SETUP */    edit_ipl_options(bm);
 
 return 0;
}/* ipl_handler */


int ext_handler( int op, DiskInfo *di, Part *p, char **argv )
{
 int i;
 Mbr *mbr;
 Part part2[4];

 if( argv!=0 ) return 0;

 read_boot_sect(di,p,1);

 if( !BTS_LOADED(p) )
   {
    return 0;
   }
 
 mbr = (Mbr *)(p->part_boot_sect);

 p->flags &= ~P_ERR_BOOT_SECT; /* assuming it is good */
 
 if( mbr->magic_num!=MAGIC_NUM )  p->flags |= P_ERR_BOOT_SECT;

 /* heuristic rule - EMBR usually is filled with zeros */
 if( count_zeros(mbr,512)<256 ) p->flags |= P_ERR_BOOT_SECT;
 
 memset(part2,0,4*sizeof(Part));

 for( i=0 ; i<4 ; i++ )
    {
     unpack_part_rec(&mbr->part_rec[i],&part2[i]);
     if( !UNUSED(&part2[i]) )
       {
        part_import( di, &part2[i], p->ext_base, p->rel_sect );
        if( part2[i].start_sect!=1 )
          {
           part2[i].flags |= P_ANY_ERROR;
           p->flags |= P_ERR_BOOT_SECT;
          }
       }
    }

 if( op==OP_PREVIEW ) redraw_ext_details(part2);

 return 0;
}/* ext_handler */


int edit_part_col( Part *p, int col, int mode )
{
 int k;
 
 static long chs_lim[] = { 65535, 255, 63, 65535, 255, 63 };
 static long lba_lim[] = { 268435455, 268435455 };  /* IDE limit: 128G */

 if( col>=2 &&  /* numeric fields */
    !UNUSED(p) && p->fs_id!=FS_MBR )
   {
    if( mode==MODE_CHS )
      k=edit_int( chs_lim[col-2], &(p->start_cyl) + (col-2) );
    else
      k=edit_int( lba_lim[col-2],  &(p->rel_sect) + (col-2) );
   }
 else k=get_key();

 return k;
}/* edit_part_col */
