/*
 Ranish Partition Manager   Copyright (C) 1998 by Mikhail Ranish
 This code is distributed under GNU General Public License (GPL)
 The full text of the license can be found at http://www.gnu.org
*/

#define PART_CMD_C
#include "part.h"


void start_cmd(int hd, int argc, char **argv)
{
 int i, x, details=0;
 Part part[N_ROWS];
 BmData *bm;
 DiskInfo disk_info, *di=&disk_info;

 printf("%s\r\n\r\n",PROGRAM_TITLE);

 if( argc<2 || strcmpi(argv[1],"-p")!=0 )
   {
    printf(CMD_HELP_TEXT);
    return;
   }

 if( argc>2 && strcmpi(argv[2],"-r")==0 ) details=1;
 
 memset(part,0,sizeof(part));
 
 if( disk_get_info(hd,di)==-1 )
   {
    fprintf(stderr,"%s\r\n",ERROR_DISK_INFO);
    return;
   }

 print_part_table(di,part,details);

 return;
}/* start_cmd */



void print_part_table( DiskInfo *di, Part *part, int details )
{
 int i, j, x, n;
 Mbr *mbr;
 Part *p, ptmp;
 
 if( details )
    printf("HD %d (%03d) %,6dM [ %,6d cyls x %d heads x %d sects = %,11d sects ]\r\n\r\n",
            di->hd_num-127, di->hd_num,    di->total_sects/2048,
            di->num_cyls,   di->num_heads, di->sect_per_track, di->total_sects );

 if( read_part_table(di,part)==-1 )
   {
    fprintf(stderr,"%s\r\n",ERROR_READ_PART_TABLE);
    return;
   }

 i=0;
 n=sort_part_table(di,part,&i);
 
printf(
"Problems           File                Starting         Ending      Partition\r\n"
"  # Type Row   System Type         Cyl Head Sect    Cyl Head Sect  Size [KB]\r\n\r\n");
 
 x=0;
 for( p=part, i=0 ; i<n ; i++, p++ )
    {
     if( !VALID(p) ) x=1;
     if( LOGICAL(p) && EXTENDED(p) && details==0 ) continue;
     sprintf_partition(tmp,i,p,MODE_CHS);
     printf("%c %s\r\n",!VALID(p)?'!':' ',tmp);
    }

 printf("\r\n");

 if( details==0 )
   {
    if( x!=0 )
      printf("Some records are invalid. Run \"part -p -r\" to see more details.\r\n");
    return;
   }

 printf("Partition table details:\r\n\r\n"
"Problems            Starting       Ending     Starting   Number of      Ending\r\n"
"  # Type R FS    Cyl Head Sct  Cyl Head Sct    sector     sectors      sector\r\n\r\n");

 for( p=part, i=0 ; i<n ; i++, p++ )
    {
     sprintf_partition(tmp,i,p,MODE_MISC);
     printf("%c %s\r\n", !VALID(p)?'!':' ', tmp );
    }

 printf("\r\n");

 for( p=part, i=0 ; i<n ; i++, p++ )
  if( !VALID(p) )
    {
     printf("%s%d:\r\n\r\n", ERR_PROBLEMS, i);
     if( p->flags & P_ERR_ZERO      ) printf("   %s\r\n", ERR_ZERO      );
     if( p->flags & P_ERR_RANGE     ) printf("   %s\r\n", ERR_RANGE     );
     if( p->flags & P_ERR_OVERLAP   ) printf("   %s\r\n", ERR_OVERLAP   );
     if( p->flags & P_ERR_LOG_ORPH  ) printf("   %s\r\n", ERR_LOG_ORPH  );
     if( p->flags & P_ERR_LOG_STRU  ) printf("   %s\r\n", ERR_LOG_STRU  );
     if( p->flags & P_ERR_CANT_READ ) printf("   %s\r\n", ERR_CANT_READ );
     if( p->flags & P_ERR_BOOT_SECT ) printf("   %s\r\n", ERR_BOOT_SECT );
     printf("\r\n");
    }

// print IPL info here

printf("Partition records exactly as they appear in MBR (EMBR):\r\n\r\n"
"                   Starting          Ending        Starting   Number of\r\n"
"    #  HD  FS    Cyl Head Sect    Cyl Head Sect      sector     sectors\r\n");

 for( p=part, i=0 ; i<n ; i++, p++ )
  if( i==0 || EXTENDED(p) )
    {
     printf("(%d,%d,%d):\r\n", p->start_cyl, p->start_head, p->start_sect );
     if( !BTS_LOADED(p) )
       {
        printf("Boot sector is not loaded!!!\r\n");
        continue;
       }
     mbr = p->part_boot_sect;
     if( mbr->magic_num!=MAGIC_NUM )
        printf("Magic number is invalid!!!\r\n");
       
     for( j=0 ; j<4 ; j++ )
        {
         unpack_part_rec(&mbr->part_rec[j],&ptmp);
         sprintf_partition(tmp,j+1,&ptmp,MODE_EXACT);
         printf("   %s\r\n",tmp);
        }
    }

 printf("\r\n\r\nDetailed information about each partition:\r\n\r\n");

 for( p=part+1, i=1 ; i<n ; i++, p++ )
  if( !UNUSED(p) && !EXTENDED(p) )
    {
     sprintf_partition(tmp,i,p,MODE_TITLE);
     printf("\r\n--- Partition %d ---\r\nType: %s\r\n\r\n", i, tmp );
     if( p->flags & OP_PRINT )
        OP_HANDLER( OP_PRINT, di, &part[i], 0 );
     else
        printf("Print info function is not available for this file system.\r\n");
     printf("\r\n");
    }

}/* print_part_table */



void print_fat_details( FatInfo *fi )
{
 printf("      Volume Label: %s\r\n", fi->label );
 printf("         System id: %s\r\n", fi->sysid );
 printf("       File system: %s\r\n", fi->fs_id );
 printf("      Cluster size: %,dk (%ds)\r\n", fi->clust_size/2, fi->clust_size );
 printf("          FAT size: %,dk\r\n", fi->fat_size/2 );
 printf("      Drive number: %d   Exp: %d\r\n", fi->drive_num, 
                                                fi->exp_drive_num );
 printf("   Starting sector: %,u\r\n", fi->rel_sect );
 printf("    Expected value: %,u\r\n", fi->exp_rel_sect );
 printf(" Number of sectors: %,u\r\n", fi->num_sect );
 printf("    Expected value: %,u\r\n", fi->exp_num_sect );
// printf("   Minimum num sect: %,11d\r\n", fi->_sect );
}/* print_fat_details */