/*
 Ranish Partition Manager   Copyright (C) 1998 by Mikhail Ranish
 This code is distributed under GNU General Public License (GPL)
 The full text of the license can be found at http://www.gnu.org
*/

#define PART_FAT_C
#include "part.h"


/* Don't look at the code below. It isn't in the good shape yet.
   I will format it nicely later.
*/

struct boot_fat16
    {
     unsigned char  jmp[3];	/* Must be 0xEB, 0x3C, 0x90		*/
     unsigned char  sys_id[8];	/* Probably:   "MSDOS5.0"		*/
     unsigned short sect_size;	/* Sector size in bytes (512)		*/
     unsigned char  clust_size;	/* Sectors per cluster (1,2,4,...,128)	*/
     unsigned short res_sects;	/* Reserved sectors at the beginning	*/
     unsigned char  num_fats;	/* Number of FAT copies (1 or 2)	*/
     unsigned short root_entr;	/* Root directory entries		*/
     unsigned short snum_sect;	/* Total sectors (if less 64k)		*/
     unsigned char  media_desc;	/* Media descriptor byte (F8h for HD)	*/
     unsigned short fat_size;	/* Sectors per fat			*/
     unsigned short num_sects;	/* Sectors per track			*/
     unsigned short num_sides;	/* Sides				*/
     unsigned long  rel_sect;	/* Special hidden sectors		*/
     unsigned long  num_sect;	/* Big total number of sectors  	*/
     unsigned short drive_num;	/* Drive number				*/
     unsigned char  ext_signat;	/* Extended Boot Record signature (29h)	*/
     unsigned long  serial_num;	/* Volume serial number			*/
     unsigned char  label[11];	/* Volume label				*/
     unsigned char  fs_id[8];	/* File system id			*/
     unsigned char  code[448];	/* Loader executable code		*/
     unsigned short magic_num;	/* Magic number (Must be 0xAA55) 	*/
    };

struct boot_fat32
    {
     /* Sector 1 */
     
     unsigned char  jmp[3];	/* Must be 0xEB, 0x58, 0x90 = jmp 5A	*/
     unsigned char  sys_id[8];	/* Probably:   "MSWIN4.1"		*/

     unsigned short sect_size;	/* Sector size in bytes (512)		*/
     unsigned char  clust_size;	/* Sectors per cluster (1,2,4,...,128)	*/
     unsigned short res_sects;	/* Reserved sectors at the beginning (33)*/
     unsigned char  fat_copies;	/* Number of FAT copies (2)		*/

     unsigned char  resrvd1[4];	/* Reserved				*/
     unsigned char  media_desc;	/* Media descriptor byte (F8h)		*/
     unsigned short sfat_size;	/* Sectors per FAT			*/

     unsigned short track_size;	/* Sectors per track			*/
     unsigned short num_sides;	/* Sides				*/

     unsigned long  rel_sect;	/* Special hidden sectors		*/
     unsigned long  num_sect;	/* Big total number of sectors  	*/
     unsigned long  fat_size;	/* Sectors per FAT (big)		*/
     unsigned char  fat_attr;	/* FAT attributes (I guess)		*/

     unsigned char  fs_ver_maj;	/* File System Version (major)		*/
     unsigned short fs_ver_min;	/* File System Version (minor)		*/

     unsigned long  root_clust;	/* First cluster in root		*/

     unsigned short fs_sect_num; /* FS Sector number (1) ???		*/
     unsigned short bs_bak_sect; /* Boot sector backup (6)		*/

     unsigned char  resrvd2[12];	/* Reserved				*/
     unsigned char  drive_num;	/* Physical drive number (80h)		*/
     unsigned char  resrvd3[1];	/* Reserved				*/

     unsigned char  ext_signat;	/* Extended Boot Record signature (29h)	*/
     unsigned long  serial_num;	/* Volume serial number			*/
     unsigned char  label[11];	/* Volume label				*/
     unsigned char  fs_id[8];	/* File system id ("FAT32   ")		*/
     unsigned char  xcode[418];	/* Boot loader code (first part)	*/
     unsigned long  magic_num;	/* Magic number (Must be 0xAA550000) 	*/
     
     /* Sector 2 */
     
     unsigned long  ext_sign2;	 /* Ext Boot Record Sign (0x41615252)	*/
     unsigned char  resrvd4[480];/* Reserved				*/
     unsigned long  ext_sign3;	 /* FS Info Signature    (0x61417272)	*/
     unsigned long  free_clust;	 /* Number of free clusters		*/
     unsigned long  next_free;	 /* Next free cluster			*/
     unsigned char  resrvd5[12]; /* Reserved				*/
     unsigned long  magic_num2;	 /* Ext Boot Record Sign (0xAA550000)	*/

     /* Sector 3 */

     unsigned char  resrvd6[508];/* Reserved				*/
     unsigned long  magic_num3;	 /* Ext Boot Record Sign (0xAA550000)	*/
    };


int fat_handler(int op, DiskInfo *di, Part *p, char **argv)
{
 int i, sys, color;
 FatInfo *fi;
 struct boot_fat16 *f16;
 struct boot_fat32 *f32;
 Sector rel, num;

 if( op==OP_FORMAT ) 
   {
    fat_format(di,p,fi);
    free_part_info(p);
    return 0;
   }

 read_boot_sect(di,p,1);

 if( !BTS_LOADED(p) )
   {
    return 0;
   }

 f16 = (struct boot_fat16 *)(p->part_boot_sect);
 f32 = (struct boot_fat32 *)(p->part_boot_sect);

 if( p->part_misc_info==0 )
   {
    if( (p->part_misc_info=malloc(sizeof(FatInfo)))==0 )
      {
       show_error(ERROR_MALLOC);
       return 0;
      }
    memset( p->part_misc_info, 0, sizeof(FatInfo) );
   }

 fi = p->part_misc_info;

 update_fat_info(di,p,fi);

 fi->exp_rel_sect = p->rel_sect - p->ext_base;
 fi->exp_num_sect = p->num_sect;
 fi->exp_drive_num = di->hd_num;
 
 if( fi->rel_sect == p->rel_sect ) fi->exp_rel_sect = p->rel_sect;

 p->flags &= ~P_ERR_BOOT_SECT;  /* Assuming that boot sector is ok */

// if( count_zeros(f16,512)==512 )  /* looks like unformatted */
//   {
//    p->flags |= P_ERR_BOOT_SECT;
//   }

 if( f16->magic_num != MAGIC_NUM ||
     fi->rel_sect != fi->exp_rel_sect ||
     (fi->last_data_sect==0 && fi->num_sect != fi->exp_num_sect) ||
     (fi->last_data_sect!=0 && (fi->num_sect > min(fi->exp_num_sect,fi->max_num_sect) ||
                                fi->num_sect < fi->last_data_sect ) ) )
    p->flags |= P_ERR_BOOT_SECT;

 if( op==OP_VALIDATE ) return 0;
 if( op==OP_PRINT )   print_fat_details(fi);
 if( op==OP_PREVIEW ) bgview_fat_details(di,p,fi,-1);
 if( op==OP_SETUP ) edit_fat_details(di,p,fi);

 return 0;
}/* fat_handler */


void bgview_fat_details(DiskInfo *di, Part *p, FatInfo *fi, int act)
{
 while(1)
    {
     redraw_fat_details(fi,act);
     if( fi->fat_sect_read >= fi->fat_size ) break;
     if( kb_hit() ) break;
     read_fat_table(di,p,fi);
    }
}



void update_fat_info(DiskInfo *di, Part *p, FatInfo *fi)
{
 struct boot_fat16 *f16;
 struct boot_fat32 *f32;

 if( fi->rel_sect_loaded == p->rel_sect_loaded ) return;
 
 fi->rel_sect_loaded = p->rel_sect_loaded;

 f16 = (struct boot_fat16 *)(p->part_boot_sect);
 f32 = (struct boot_fat32 *)(p->part_boot_sect);
 
      if( memcmp(f16->fs_id,"FAT12   ",8)==0 ) fi->sys=12;
 else if( memcmp(f16->fs_id,"FAT16   ",8)==0 ) fi->sys=16;
 else if( memcmp(f32->fs_id,"FAT32   ",8)==0 ) fi->sys=32;
 else if( p->fs_id==0x0B00 || p->fs_id==0x0C00 ||
          p->fs_id==0x1B00 || p->fs_id==0x1C00 ) fi->sys=32;
                                            else fi->sys=16;
 if( fi->sys==32 )
   {
    fi->fat_size = f32->fat_size;
    fi->rel_sect = f32->rel_sect;
    fi->num_sect = f32->num_sect;
    fi->drive_num = f32->drive_num;
   }
 else
   {
    fi->fat_size =  f16->fat_size;
    fi->rel_sect =  f16->rel_sect;
    fi->num_sect = (f16->snum_sect ? f16->snum_sect : f16->num_sect);
    fi->drive_num = f16->drive_num;
   }

 fi->clust_size = f16->clust_size;
 fi->fat_rel_sect = f16->res_sects;


 strncpy( fi->sysid, f16->sys_id, 8 );
 strncpy( fi->fs_id, fi->sys==32 ? f32->fs_id : f16->fs_id, 8 );
 strncpy( fi->label, fi->sys==32 ? f32->label : f16->label, 11 );

 fi->boot_fix = 0;
 if( fi->sys!=32 && memcmp(f16, FAT16_BOOT, 3)==0 &&
                    memcmp(f16->code, FAT16_BOOT+0x3E, 448)==0 )
    fi->boot_fix = 1;

 fi->fat_sect_read = 0;
 fi->num_data_sect = 0;
 fi->last_data_sect = 0;
 fi->first_data_sect = fi->fat_rel_sect + 2*fi->fat_size +
                    ( (fi->sys==32) ? (0) : (f16->root_entr/16) );

 fi->max_num_sect = fi->first_data_sect + 
                (fi->fat_size*512*8/fi->sys - 2) * fi->clust_size;


 /* if FAT is greater than 100M for FAT-32 and 200k for FAT-12 
    there must be garbage in the boot sector */

 if( fi->fat_size<0 ) fi->fat_size=0;
 
 if( fi->fat_size > (fi->sys==32 ? 200000L : 400) )
     fi->fat_sect_read = fi->fat_size;

}/* update_fat_info */



void read_fat_table(DiskInfo *di, Part *p, FatInfo *fi)
{
 int i, l;
 unsigned short *fat16 = (unsigned short *)tmp;
 unsigned long  *fat32 = (unsigned long *)tmp;

 if( fi->sys==12 ) /* we dont deal with FAT12 yet */
   {
    fi->fat_sect_read = fi->fat_size;
    fi->num_data_sect = fi->num_sect;
    fi->last_data_sect = fi->num_sect;
    return;
   }

 if( read_part_rel(di, p, fi->fat_rel_sect + fi->fat_sect_read, tmp, 1)==-1 )
   {
    fi->fat_sect_read = fi->fat_size;
    fi->num_data_sect = -1;
    fi->last_data_sect = -1;
    return;
   }

 if( fi->sys==16 )
   {
    for( l=0, i=0 ; i<256 ; i++ )
     if( fat16[i]!=0 )
       {
        l=i;
        fi->num_data_sect += fi->clust_size;
       }
    if( l!=0 ) fi->last_data_sect = fi->first_data_sect +
                                   (fi->fat_sect_read*256+l-1)*fi->clust_size-1;
   }
 else /* must be fat32 */
   {
    for( l=0, i=0 ; i<128 ; i++ )
     if( fat32[i]!=0 )
       {
        l=i;
        fi->num_data_sect += fi->clust_size;
       }
    if( l!=0 ) fi->last_data_sect = fi->first_data_sect +
                                   (fi->fat_sect_read*128+l-1)*fi->clust_size-1;
   }

 fi->fat_sect_read++;

}/* read_fat_table */



void save_fat_boot_sect(DiskInfo *di, Part *p, FatInfo *fi)
{
 struct boot_fat16 *f16;
 struct boot_fat32 *f32;

 f16 = (struct boot_fat16 *)(p->part_boot_sect);
 f32 = (struct boot_fat32 *)(p->part_boot_sect);

 if( fi->sys == 32 )
   {
    f32->rel_sect = fi->rel_sect;
    f32->num_sect = fi->num_sect;
    f32->drive_num = fi->drive_num;
   }
 else
   {
    if( fi->boot_fix==1 )
      {
       memmove(f16,FAT16_BOOT,3);
       memmove(f16->code,FAT16_BOOT+0x3E,450);
      }
    f16->rel_sect = fi->rel_sect;
    f16->snum_sect = 0;
    f16->num_sect = fi->num_sect;
    f16->drive_num = fi->drive_num;
   }

 write_boot_sect(di,p,0,1);
}/* save_fat_boot_sect */




#define BBT_SIZE 12000

#define F_NORM  0
#define F_QUICK 1
#define F_DESTR 2

#define ROOT_ENTR    (512)
#define ROOT_SIZE    (ROOT_ENTR/16)
#define MAX_CLUST12  (4084)    /* Maximum number of clusters in FAT12 system */
#define MAX_CLUST16  (65524)   /* Maximum number of clusters in FAT16 system */

/*   0x01, "DOS FAT-12"			*/
/*   0x04, "DOS FAT-16 (<=32Mb)"	*/
/*   0x06, "BIGDOS FAT-16 (>=32Mb)"	*/

void fat16_format(DiskInfo *di, Part *p, Sector *bbt, int bbt_size);
void fat32_format(DiskInfo *di, Part *p, Sector *bbt, int bbt_size);


void fat_format(DiskInfo *di, Part *p, FatInfo *fi)
{
 int i, x=0;
 Sector *bbt=0;
 
 i=dialog_box("Warning!!! Formatting will desroy all data on the partition!!!",
            " Format ", " Quick format without surface test ", " Cancel ", 0 );
 if( i==0 || i==3 ) return;

 if( i==1 )
   {
    bbt=malloc(BBT_SIZE*sizeof(Sector));
    if( bbt==0 )
      {
       show_error(ERROR_MALLOC);
       return;
      }
    x=verify_part(di,p,bbt,BBT_SIZE);
    if( x==BBT_SIZE )
      {
       show_error("Too many bad sectors. Locate partition somewhere else.");
       show_bad_blocks(di,p,bbt,x);
       free(bbt);
       return;
      }
   }
 
 if( p->fs_id==0x0B00 || p->fs_id==0x0C00 ||
     p->fs_id==0x1B00 || p->fs_id==0x1C00 )  fat32_format(di,p,bbt,x);
                                        else fat16_format(di,p,bbt,x);

 if( bbt!=0 ) free(bbt);
}/* fat_format */


void fat16_format(DiskInfo *di, Part *p, Sector *bbt, int bbt_size)
{
 int i;
 struct boot_fat16 *b;
 unsigned short int *fat;
 Sector clust_size, num_clust, first_data_sect, data_sects;

 b = malloc(512);
 fat = malloc(512*256);
 
 if( b==0 || fat==0 )
   {
    if( b!=0 ) free(b);
    if( fat!=0 ) free(fat);
    show_error(ERROR_MALLOC);
    return;
   }

 memmove(b,FAT16_BOOT,SECT_SIZE);
 memmove(b->sys_id,"MSDOS5.0",8);
 b->sect_size=SECT_SIZE;
 b->res_sects=1;
 b->num_fats=2;
 b->root_entr=ROOT_ENTR;
 b->media_desc=0xF8;
 b->ext_signat=0x29;
 memmove(b->label,"NO NAME    ",11);
 b->magic_num=MAGIC_NUM;

#if 0
 u_num_sect=p->num_sect;
 x_num_sect=p->num_sect;

 while(*argv!=0)
    {
     if( strcmpi(*argv,"/destructive")==0 ) form_type=F_DESTR;
     else if(  strcmpi(*argv,"/quick")==0 ) form_type=F_QUICK;
     else if( strncmpi(*argv,"/c:", 3)==0 )
       {
        k=atoi((*argv)+3);
        for( i=k/2, j=0 ; i!=0 && j<7 ; j++, i/=2 );
        clust_size=1<<j;
        if( clust_size!=k )
          {
           progress("^Invalid cluster size.");
           goto failed;
          }
       }
     else if( strncmpi(*argv,"/x:", 3)==0 )
       {
        if( strcmpi(*argv,"/x:disk")==0 )
          l=dinfo.total_sects;
        else
          l=atol((*argv)+3);
        if( l>x_num_sect ) x_num_sect=l;
       }
     else if( strncmpi(*argv,"/l:", 3)==0 )
       {
        strncpy(tmp,(*argv)+3,11);
        tmp[11]=0;
        for( i=0 ; tmp[i]!=0 && i<11 ; i++ ) b->label[i]=tmp[i];
        for( ; i<11 ; i++ ) b->label[i]=' ';
       }
     else
       {
        progress("^Unknown option:");
        progress(*argv);
        goto failed;
       }
     argv++;
    }

 if( p->os_id==0x0400 || p->os_id==0x0600 ||			/* FAT16 */
     p->os_id==0x1400 || p->os_id==0x1600 )
   {
    l=1+512+ROOT_SIZE+64L*MAX_CLUST16;
    if( l<u_num_sect ) u_num_sect=l;
    if( l<x_num_sect ) x_num_sect=l;
    
    while( clust_size<64 )
       { 
        if(1+512+ROOT_SIZE+(Sector)clust_size*MAX_CLUST16 > x_num_sect)
          break;
        clust_size*=2;
       }
 
    fat_size =  (x_num_sect-ROOT_SIZE-1+2*clust_size)/(clust_size*256+2)+1;
    num_clust = (x_num_sect-ROOT_SIZE-1-2*fat_size)/(clust_size);

    memmove(b->fs_id,"FAT16   ",8);

    sys_type=16;
   }

 if( p->os_id==0x0100 || p->os_id==0x1100 || num_clust<MAX_CLUST12 )/* FAT12 */
   {
    l=1+512+ROOT_SIZE+64L*MAX_CLUST12;
    if( l<u_num_sect ) u_num_sect=l;
    if( l<x_num_sect ) x_num_sect=l;

    while( clust_size<64 )
       { 
        if( 1+24+ROOT_SIZE+(Sector)clust_size*MAX_CLUST12 > x_num_sect )
          break;
        clust_size*=2;
       }
 
    fat_size =  (x_num_sect-ROOT_SIZE-1+2*clust_size)/((long)clust_size*512*2/3+2)+1;
    num_clust = (x_num_sect-ROOT_SIZE-1-2*fat_size)/(clust_size);
    
    memmove(b->fs_id,"FAT12   ",8);

    sys_type=12;
   }

 if( fat_size<0 || 1+2*fat_size+ROOT_SIZE+clust_size > p->num_sect )
   {
    progress("^Partition is too small.");
    goto failed;
   }
 b->fat_size=fat_size;
 b->clust_size=clust_size;
#endif


 	memmove(b->fs_id,"FAT16   ",8);
	b->fat_size = 256;

        first_data_sect = 1+2*256+ROOT_SIZE;
        
        if( p->num_sect < first_data_sect+8 )
          {
           show_error("Partition is too small.");
           free(b);
           free(fat);
           return;
          }

        data_sects = p->num_sect - first_data_sect;
         
 	for( clust_size=2 ; clust_size<64 ; clust_size*=2 )
	  if( data_sects/clust_size < MAX_CLUST16 ) break;
	
	num_clust = min( data_sects/clust_size, MAX_CLUST16 );
	
	b->clust_size = clust_size;
 
 b->drive_num=di->hd_num;
 b->num_sects=di->sect_per_track;
 b->num_sides=di->num_heads;

 b->rel_sect = p->rel_sect;
 b->snum_sect = 0;
 b->num_sect = p->num_sect;
 
 b->serial_num=((p->rel_sect<<16)+(p->num_sect*((long)b%451)) )+
               ((di->total_sects%12345L)^(di->total_sects*67891L))+
               ((di->hd_num*123L)^(di->num_heads%7));
 
// flush_caches();

// disk_lock(dinfo.disk);
 
 progress("^Initializing file system ...");

 if( bbt_size!=0 && bbt[0] < first_data_sect )
   {
    progress("Beginning of the partition is unusable. Try to move it forward.");
    free(b);
    free(fat);
    return;
   }

 progress("Writing boot sector ...");
 
 if( write_part_rel(di,p,0,b,1)==-1 )	/*  Writing boot sector  */
   {
    progress("Error writing boot sector.");
    free(b);
    free(fat);
    return;
   }
 
 progress("Writing FAT tables ...");

 memset(fat,0,256*512);
 fat[0]=0xFFF8;
 fat[1]=0xFFFF;
 
 i=0;
 while( i<bbt_size )
    {
     fat[ (bbt[i]-first_data_sect)/clust_size+2 ] = 0xFFF7;
     i++;
    }

 if( write_part_rel(di,p,1,fat,256)==-1 )
   {
    progress("Error writing FAT 1.");
    free(b);
    free(fat);
    return;
   }

 if( write_part_rel(di,p,257,fat,256)==-1 )
   {
    progress("Error writing FAT 2.");
    free(b);
    free(fat);
    return;
   }

#if 0
    struct fat12
        {
         unsigned c0:12;
         unsigned c1:12;
        } *fat12 = (struct fat12*)fat;
    
    memset(fat,0,6144);

    fat12[0].c0=0xFF8;
    fat12[0].c1=0xFFF;

    next_bad = 0;
    base_sect = 1 + 2*fat_size + ROOT_SIZE;

    while( next_bad!=num_bad )
       {
        j=(bbt[next_bad++]-base_sect)/clust_size+2;
        
        if( j%2==0 ) fat12[j/2].c0=0xFF7;
                else fat12[j/2].c1=0xFF7;
       }

    for( k=0 ; k<2 ; k++ )
      for( i=0 ; i<fat_size ; i++ )
       if( disk_write_rel(p,wr_sect++,fat+i*256,1)==-1 )
         {
          progress("Error writing FAT.");
          goto failed;
         }
   }/* fat12 */
#endif
 memset(fat,0,ROOT_SIZE*512);
 progress("Writing root directory ...");

 if( write_part_rel(di,p,513,fat,ROOT_SIZE)==-1 )
    {
     progress("Error writing root directory.");
     free(b);
     free(fat);
     return;
    }


// disk_unlock(dinfo.disk);
 return;
}/* format_fat */


void fat32_format(DiskInfo *di, Part *p, Sector *bbt, int bbt_size)
{
 char *data_pool;
 struct boot_fat32 *b;
 unsigned long *fat;
 int i, j, k, wr_sect, ret_code, fat_size, next_bad;
 Sector l, num_clust, num_sect, base_sect, base_clust;

 unsigned int num_bad=0;
 unsigned int clust_size=8;

 if( (data_pool=malloc(SECT_SIZE*3))==0 )
   {
    show_error(ERROR_MALLOC);
    return;
   }

 b   = (struct boot_fat32*)(data_pool);
 fat = (unsigned long int*)(data_pool);

 memset(b,0,SECT_SIZE*3);

 memmove(b->jmp,"\xEB\x58\x90",3);
 memmove(b->sys_id,"MSWIN4.1",8);
 b->sect_size=SECT_SIZE;
 b->res_sects=33;
 b->fat_copies=2;
 b->fs_sect_num=1;
 b->bs_bak_sect=6;
 b->media_desc=0xF8;
 b->ext_signat=0x29;
 memmove(b->label,"NO NAME    ",11);
 memmove(b->fs_id,"FAT32   ",8);
 memmove(b->xcode, EMP_IPL, EMP_IPL_SIZE );
 strncpy(b->xcode + EMP_IPL_SIZE, MESG_NON_SYSTEM, sizeof(b->xcode)-EMP_IPL_SIZE);

 b->ext_sign2 = 0x41615252L;
 b->ext_sign3 = 0x61417272L;

 b->magic_num = 0xAA550000L;
 b->magic_num2= 0xAA550000L;
 b->magic_num3= 0xAA550000L;

 num_sect = max( p->num_sect, di->total_sects - p->rel_sect);

 while(1)
    {
     fat_size =  (num_sect)/(clust_size*128) + 1;
     num_clust = (num_sect-33-2*fat_size)/(clust_size);
     
     if( num_clust >= 65536L ) break;
     
     clust_size /= 2;
     
     if( clust_size==0 )
       {
        progress("^Oops! Cluster size is 0...");
        progress("You have to use FAT-16 file system for such a small partition.");
        goto failed;
       }
    }
     

 if( 33+2*fat_size+2*clust_size > p->num_sect )
   {
    progress("^Partition is too small.");
    goto failed;
   }

 
 b->fat_size=fat_size;
 b->clust_size=clust_size;

 b->root_clust=2;
 b->next_free=3;
 b->free_clust=num_clust-1;

 b->drive_num=di->hd_num;
 b->track_size=di->sect_per_track;
 b->num_sides=di->num_heads;

 b->rel_sect = p->rel_sect;
 b->num_sect = p->num_sect;
 
 b->serial_num=((p->rel_sect<<16)+(p->num_sect*((long)b%451)) )+
               ((di->total_sects%12345L)^(di->total_sects*67891L))+
               ((di->hd_num*123L)^(di->num_heads%7));
 
// flush_caches();


 num_bad=bbt_size;

// disk_lock(dinfo.disk);
 
 progress("^Initializing file system ...");

 if( num_bad!=0 && bbt[0] < 33+2*fat_size+2*clust_size )
   {
    progress("Beginning of the partition is unusable. Try to move it forward.");
    goto failed;
   }

 progress("Writing boot sector ...");
 
 if( write_part_rel(di,p,0,b,3)==-1 )	/*  Writing boot sector  */
   {
    progress("Error writing boot sector.");
    goto failed;
   }

 if( write_part_rel(di,p,6,b,3)==-1 )	/*  Writing boot sector (backup) */
   {
    progress("Error writing boot sector.");
    goto failed;
   }
 
 progress("Writing FAT tables ...");

 wr_sect = 33;

 for( k=0 ; k<2 ; k++ )		 /* Writing two copies of FAT16 */
    {
     next_bad = 0;
     base_sect = 33 + 2*fat_size + clust_size /*root*/;

     for( i=0 ; i<fat_size ; i++ )
        {
         memset(fat,0,512);
         if( i==0 )
           {
            fat[0]=0x0FFFFFF8;
            fat[1]=0x0FFFFFFF;
            fat[2]=0x0FFFFFFF; /* root */
            while(next_bad!=num_bad && bbt[next_bad]<base_sect+clust_size*125)
              fat[ (bbt[next_bad++]-base_sect)/clust_size+3 ]=0x0FFFFFF7;
            base_sect+=clust_size*125;
           }
         else
           {
            while(next_bad!=num_bad && bbt[next_bad]<base_sect+clust_size*128)
              fat[ (bbt[next_bad++]-base_sect)/clust_size ]=0x0FFFFFF7;
            base_sect+=clust_size*128;
           }

         if( write_part_rel(di,p,wr_sect++,fat,1)==-1 )
           {
            progress("Error writing FAT.");
            goto failed;
           }
        }
    }
 
 memset(fat,0,512);
 
 progress("Writing root directory ...");

 for( i=0 ; i<clust_size ; i++ )
  if( write_part_rel(di,p,wr_sect++,fat,1)==-1 )
    {
     progress("Error writing root directory.");
     goto failed;
    }

// disk_unlock(dinfo.disk);
 free(data_pool);

failed:

// disk_unlock(dinfo.disk);
 free(data_pool);
 return;
}/* format_fat32 */

