/*
 Ranish Partition Manager   Copyright (C) 1998 by Mikhail Ranish
 This code is distributed under GNU General Public License (GPL)
 The full text of the license can be found at http://www.gnu.org
*/

#define PART_WIZ_C
#include "part.h"


void part_new_wiz( DiskInfo *di, Part *part, int *row, int *n )
{
 show_error("Sorry. Wizard is not implemented yet.");
}/* part_new_wiz */



/* This function is called when user changes FS type of unused record */

void part_ins_wiz( DiskInfo *di, Part *part, int *row, int *n )
{
 int i;
 Part *p=&part[*row];
 
 if( p->rel_sect  < di->sect_per_track &&
     p->last_sect > di->sect_per_track )
   {
    p->start_head = 1;
    p->start_sect = 1;
    recalculate_partition(di,p,MODE_CHS);
   }

 if( p->start_cyl < di->num_cyls && 
     p->end_cyl  == di->num_cyls )
   {
    p->end_cyl  = di->num_cyls-1;
    p->end_head = di->num_heads-1;
    p->end_sect = di->sect_per_track;
    recalculate_partition(di,p,MODE_CHS);
   }

 if( LOGICAL(p) && !EXTENDED(p) )
   {
    if( !EXTENDED(p-1) && (*n)<N_ROWS )
      {
       for( i=(*n) ; i>(*row) ; i-- ) /* inserting ext partition */
         part[i]=part[i-1];
       p->fs_id=FS_DOSEXT;
       find_fs_num(p);
       (*n)++;
       (*row)++;
       p++;
       p->rel_sect += di->sect_per_track;
       p->num_sect -= di->sect_per_track;
       recalculate_partition(di,p,MODE_LBA);
      }
    else if( EXTENDED(p-1) )
      {
       p->num_sect = (p-1)->num_sect - di->sect_per_track;
       recalculate_partition(di,p,MODE_LBA);
      }
   }
}/* part_ins_wiz */
