/*  Express HTML Help

    Copyright (c) Express Software 1998.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

#define HTML_HELP

// I N C L U D E S //////////////////////////////////////////////////////////

#include "help.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define CLICK(y,x1,x2) ((mx)>=(x1)&&(mx)<=(x2)&&(my)==(y))
#define NUM_ARGS  10

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.

        } // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

void main(int argc, char *argv[])
{
    char *fileargs[64], *optargs[64], *ext=".htm", *showcommand;
    int n_options, n_files, index, help_flag=0, i;

    n_options = classify_args(argc, argv, fileargs, optargs);
    n_files = argc - n_options;
    hd=0x80;
    get_base_dir(argv[0]);
    for (index=0;index<n_options;index++)
        {
        if (optargs[index][0] == '?') help_flag=1;
        else
	    {
	    printf("Invalid parameter - /%s\n", strupr(optargs[index]));
	    exit(1);
            } // end else.

        } // end for.

    if (help_flag)
        {
	printf("Starts HTML Help, an HTML version of the online help system.\n\n"
               "Syntax: HELP [command] [/?]\n"
               "  command  Help for the command you want help on\n"
	       "  /?       Displays this help message\n");
	exit(1);
	} // end if.

    if (n_files > 1)                    // If the user specified a command.
        {
        strcpy(showcommand, "files/");
        strcat(showcommand, fileargs[1]);
        strcat(showcommand, ext);
        conio_init();
        interactive=1;
        show_mouse();
        move_mouse(80,25);
        html_view(showcommand);
        clear_window(White+BakBlack, 1, 1, 80, 25);
        move_cursor(1,1);
        hide_mouse();
        conio_exit();
        exit(0);
        } // end if.
    else
        {
        conio_init();
        interactive=1;
        show_mouse();
        move_mouse(80,25);
        html_view("HELP.HTM");
        clear_window(White+BakBlack, 1, 1, 80, 25);
        move_cursor(1,1);
        hide_mouse();
        conio_exit();
        exit(0);
        } // end else.

} // end main.
