
; flat assembler  version 1.02
; Copyright (c) 1999-2000, Tomasz Grysztar
; All rights reserved.

get_operator:
        push    esi ebp
        mov     ebp,1
        cmp     byte [esi],1Ah
        jne     operator_start
        inc     esi
        lods    byte [esi]
        movzx   ebp,al
      operator_start:
        mov     edx,esi
      check_operator:
        mov     esi,edx
        movzx   ecx,byte [edi]
        jecxz   no_operator
        inc     edi
        mov     ebx,edi
        add     ebx,ecx
        cmp     ecx,ebp
        jne     next_operator
        repe    cmps byte [esi],[edi]
        je      operator_found
      next_operator:
        mov     edi,ebx
        inc     edi
        jmp     check_operator
      no_operator:
        xor     al,al
        pop     ebp esi
        ret
      operator_found:
        pop     ebp eax
        mov     al,[edi]
        ret

get_symbol:
        mov     edx,esi
        mov     ebp,ecx
      check_symbol:
        mov     esi,edx
        movzx   eax,byte [edi]
        or      al,al
        jz      no_symbol
        mov     ecx,ebp
        inc     edi
        mov     ebx,edi
        add     ebx,eax
        mov     ah,[esi]
        cmp     ah,[edi]
        jb      no_symbol
        ja      next_symbol
        cmp     cl,al
        jne     next_symbol
        repe    cmps byte [esi],[edi]
        jb      no_symbol
        je      symbol_ok
      next_symbol:
        mov     edi,ebx
        add     edi,2
        jmp     check_symbol
      no_symbol:
        mov     esi,edx
        mov     ecx,ebp
        stc
        ret
      symbol_ok:
        mov     ax,[ebx]
        clc
        ret

get_instruction:
        mov     edx,esi
        mov     ebp,ecx
        cmp     ecx,10
        ja      no_instruction
        sub     cl,2
        jc      no_instruction
        movzx   edi,word [instructions+ecx*2]
        add     edi,instructions
      check_instruction:
        mov     esi,edx
        mov     al,[edi]
        or      al,al
        jz      no_instruction
        mov     ecx,ebp
        mov     ebx,edi
        add     ebx,ecx
        repe    cmps byte [esi],[edi]
        jb      no_instruction
        je      instruction_ok
      next_instruction:
        mov     edi,ebx
        add     edi,4
        jmp     check_instruction
      no_instruction:
        mov     esi,edx
        mov     ecx,ebp
        stc
        ret
      instruction_ok:
        mov     ax,[ebx+2]
        mov     bx,[ebx]
        clc
        ret

get_label_id:
        cmp     ecx,100h
        jae     name_too_long
        mov     al,[esi]
        cmp     al,27h
        je      invalid_name
        cmp     al,'.'
        jne     standard_label
        cmp     [current_locals_prefix],0
        je      standard_label
        cmp     byte [esi+1],'.'
        je      standard_label
        push    ecx esi
        mov     ebx,edi
        mov     esi,[current_locals_prefix]
        lods    byte [esi]
        movzx   ecx,al
        rep     movs byte [edi],[esi]
        pop     esi ecx
        add     al,cl
        jc      name_too_long
        rep     movs byte [edi],[esi]
        movzx   ecx,al
        push    esi
        mov     edi,ebx
        mov     esi,ebx
        call    get_label_id
        pop     esi
        ret
      standard_label:
        cmp     ecx,1
        jne     find_label
        lods    byte [esi]
        cmp     al,'$'
        je      get_current_offset_id
        cmp     al,'%'
        je      get_counter_id
        dec     esi
        jmp     find_label
      get_current_offset_id:
        xor     eax,eax
        ret
      get_counter_id:
        mov     eax,1
        ret
      find_label:
        xor     ebx,ebx
        xor     al,al
      hash_label:
        add     al,[esi+ebx]
        inc     bl
        cmp     bl,cl
        jb      hash_label
        mov     [label_hash],al
        push    edi
        push    esi
        mov     edi,[labels_list]
        mov     edx,esi
        mov     ebp,ecx
      check_label:
        mov     esi,edx
        movzx   eax,byte [edi]
        mov     ecx,ebp
        or      al,al
        jz      add_label
        mov     [label_name],edi
        inc     edi
        mov     ebx,edi
        add     ebx,eax
        mov     ah,[ebx+4]
        cmp     ah,[label_hash]
        jne     next_label
        cmp     cl,al
        jne     next_label
        repe    cmps byte [esi],[edi]
        je      label_found
      next_label:
        mov     edi,ebx
        add     edi,8
        jmp     check_label
      label_found:
        mov     eax,[edi]
        add     sp,4
        pop     edi
        ret
      add_label:
        pop     esi
        mov     edi,[labels_list]
        sub     edi,ecx
        sub     edi,8
        lea     ebx,[edi-1]
        mov     [label_name],ebx
        mov     [ebx],cl
        rep     movs byte [edi],[esi]
        mov     eax,[last_label_id]
        sub     eax,16
        stos    dword [edi]
        mov     dl,[label_hash]
        mov     [edi],dl
        mov     [last_label_id],eax
        mov     [labels_list],ebx
        pop     edi
        cmp     ebx,edi
        jbe     out_of_memory
        ret

labels_list dd ?
last_label_id dd ?
label_name dd ?
label_hash db ?

special_characters db 22
 db 0,9,' +-/*:=|&~()[]<>{},;'

operators:
 db 1,'+',80h
 db 1,'-',81h
 db 1,'*',90h
 db 1,'/',91h
 db 3,'mod',A0h
 db 3,'and',B0h
 db 2,'or',B1h
 db 3,'xor',B2h
 db 3,'shl',C0h
 db 3,'shr',C1h
 db 0

single_operand_operators:
 db 3,'not',D0h
 db 0

index_registers:
 db 2,'bp',0,25h
 db 2,'bx',0,23h
 db 2,'di',0,27h
 db 3,'eax',0,40h
 db 3,'ebp',0,45h
 db 3,'ebx',0,43h
 db 3,'ecx',0,41h
 db 3,'edi',0,47h
 db 3,'edx',0,42h
 db 3,'esi',0,46h
 db 3,'esp',0,44h
 db 2,'si',0,26h
 db 0

symbols:
 db 2,'MZ',15h,2
 db 2,'ah',10h,14h
 db 2,'al',10h,10h
 db 2,'at',13h,0
 db 2,'ax',10h,20h
 db 1,'b',11h,1
 db 2,'bh',10h,17h
 db 6,'binary',15h,1
 db 2,'bl',10h,13h
 db 2,'bp',10h,25h
 db 2,'bx',10h,23h
 db 4,'byte',11h,1
 db 2,'ch',10h,15h
 db 2,'cl',10h,11h
 db 3,'cr0',10h,70h
 db 3,'cr2',10h,72h
 db 3,'cr3',10h,73h
 db 3,'cr4',10h,74h
 db 2,'cs',10h,62h
 db 2,'cx',10h,21h
 db 1,'d',11h,4
 db 2,'dh',10h,16h
 db 2,'di',10h,27h
 db 2,'dl',10h,12h
 db 3,'dr0',10h,80h
 db 3,'dr1',10h,81h
 db 3,'dr2',10h,82h
 db 3,'dr3',10h,83h
 db 3,'dr5',10h,85h
 db 3,'dr6',10h,86h
 db 3,'dr7',10h,87h
 db 2,'ds',10h,64h
 db 5,'dword',11h,4
 db 2,'dx',10h,22h
 db 3,'eax',10h,40h
 db 3,'ebp',10h,45h
 db 3,'ebx',10h,43h
 db 3,'ecx',10h,41h
 db 3,'edi',10h,47h
 db 3,'edx',10h,42h
 db 3,'equ',17h,0
 db 2,'es',10h,61h
 db 3,'esi',10h,46h
 db 3,'esp',10h,44h
 db 3,'far',12h,2
 db 2,'fs',10h,65h
 db 2,'gs',10h,66h
 db 3,'mm0',16h,0
 db 3,'mm1',16h,1
 db 3,'mm2',16h,2
 db 3,'mm3',16h,3
 db 3,'mm4',16h,4
 db 3,'mm5',16h,5
 db 3,'mm6',16h,6
 db 3,'mm7',16h,7
 db 4,'near',12h,1
 db 1,'p',11h,6
 db 5,'pword',11h,6
 db 1,'q',11h,8
 db 5,'qword',11h,8
 db 2,'si',10h,26h
 db 2,'sp',10h,24h
 db 2,'ss',10h,63h
 db 2,'st',14h,0
 db 3,'st0',14h,0
 db 3,'st1',14h,1
 db 3,'st2',14h,2
 db 3,'st3',14h,3
 db 3,'st4',14h,4
 db 3,'st5',14h,5
 db 3,'st6',14h,6
 db 3,'st7',14h,7
 db 1,'t',11h,10
 db 5,'tbyte',11h,10
 db 3,'tr3',10h,93h
 db 3,'tr4',10h,94h
 db 3,'tr5',10h,95h
 db 3,'tr6',10h,96h
 db 3,'tr7',10h,97h
 db 5,'use16',18h,16
 db 5,'use32',18h,32
 db 1,'w',11h,2
 db 4,'word',11h,2
 db 0

preprocessor_directives:
 db 7,'include'
 dw include_file-preprocessor
 db 5,'macro'
 dw define_macro-preprocessor
 db 5,'purge'
 dw purge_macro-preprocessor
 db 0

macro_directives:
 db 5,'local'
 dw local_symbols-preprocessor
 db 0

instructions:
 dw instructions_2-instructions
 dw instructions_3-instructions
 dw instructions_4-instructions
 dw instructions_5-instructions
 dw instructions_6-instructions
 dw instructions_7-instructions
 dw instructions_8-instructions
 dw instructions_9-instructions
 dw instructions_10-instructions

instructions_2:
 db 'bt'
 dw bt_instruction-assembler,4
 db 'db'
 dw data_bytes-assembler,101h
 db 'dd'
 dw data_dwords-assembler,104h
 db 'dp'
 dw data_pwords-assembler,106h
 db 'dq'
 dw data_qwords-assembler,108h
 db 'dw'
 dw data_words-assembler,102h
 db 'if'
 dw if_directive-assembler,0
 db 'in'
 dw in_instruction-assembler,0
 db 'ja'
 dw conditional_jump-assembler,77h
 db 'jb'
 dw conditional_jump-assembler,72h
 db 'jc'
 dw conditional_jump-assembler,72h
 db 'je'
 dw conditional_jump-assembler,74h
 db 'jg'
 dw conditional_jump-assembler,7Fh
 db 'jl'
 dw conditional_jump-assembler,7Ch
 db 'jo'
 dw conditional_jump-assembler,70h
 db 'jp'
 dw conditional_jump-assembler,7Ah
 db 'js'
 dw conditional_jump-assembler,78h
 db 'jz'
 dw conditional_jump-assembler,74h
 db 'or'
 dw basic_instruction-assembler,08h
 db 'rb'
 dw reserve_bytes-assembler,201h
 db 'rd'
 dw reserve_dwords-assembler,204h
 db 'rp'
 dw reserve_pwords-assembler,206h
 db 'rq'
 dw reserve_qwords-assembler,208h
 db 'rw'
 dw reserve_words-assembler,202h
 db 0
instructions_3:
 db 'aaa'
 dw simple_instruction-assembler,37h
 db 'aad'
 dw aa_instruction-assembler,D5h
 db 'aam'
 dw aa_instruction-assembler,D4h
 db 'aas'
 dw simple_instruction-assembler,3Fh
 db 'adc'
 dw basic_instruction-assembler,10h
 db 'add'
 dw basic_instruction-assembler,00h
 db 'and'
 dw basic_instruction-assembler,20h
 db 'bsf'
 dw bs_instruction-assembler,BCh
 db 'bsr'
 dw bs_instruction-assembler,BDh
 db 'btc'
 dw bt_instruction-assembler,7
 db 'btr'
 dw bt_instruction-assembler,6
 db 'bts'
 dw bt_instruction-assembler,5
 db 'cbw'
 dw simple_instruction_16bit-assembler,98h
 db 'cdq'
 dw simple_instruction_32bit-assembler,99h
 db 'clc'
 dw simple_instruction-assembler,F8h
 db 'cld'
 dw simple_instruction-assembler,FCh
 db 'cli'
 dw simple_instruction-assembler,FAh
 db 'cmc'
 dw simple_instruction-assembler,F5h
 db 'cmp'
 dw basic_instruction-assembler,38h
 db 'cwd'
 dw simple_instruction_16bit-assembler,99h
 db 'daa'
 dw simple_instruction-assembler,27h
 db 'das'
 dw simple_instruction-assembler,2Fh
 db 'dec'
 dw inc_instruction-assembler,1
 db 'div'
 dw single_operand_instruction-assembler,6
 db 'end'
 dw end_directive-assembler,0
 db 'fld'
 dw fld_instruction-assembler,0
 db 'fst'
 dw fld_instruction-assembler,2
 db 'hlt'
 dw simple_instruction-assembler,F4h
 db 'inc'
 dw inc_instruction-assembler,0
 db 'ins'
 dw ins_instruction-assembler,0
 db 'int'
 dw int_instruction-assembler,CDh
 db 'jae'
 dw conditional_jump-assembler,73h
 db 'jbe'
 dw conditional_jump-assembler,76h
 db 'jge'
 dw conditional_jump-assembler,7Dh
 db 'jle'
 dw conditional_jump-assembler,7Eh
 db 'jmp'
 dw jmp_instruction-assembler,0
 db 'jna'
 dw conditional_jump-assembler,76h
 db 'jnb'
 dw conditional_jump-assembler,73h
 db 'jnc'
 dw conditional_jump-assembler,73h
 db 'jne'
 dw conditional_jump-assembler,75h
 db 'jng'
 dw conditional_jump-assembler,7Eh
 db 'jnl'
 dw conditional_jump-assembler,7Dh
 db 'jno'
 dw conditional_jump-assembler,71h
 db 'jnp'
 dw conditional_jump-assembler,7Bh
 db 'jns'
 dw conditional_jump-assembler,79h
 db 'jnz'
 dw conditional_jump-assembler,75h
 db 'jpe'
 dw conditional_jump-assembler,7Ah
 db 'jpo'
 dw conditional_jump-assembler,7Bh
 db 'lar'
 dw lar_instruction-assembler,2
 db 'lds'
 dw ls_instruction-assembler,3
 db 'lea'
 dw lea_instruction-assembler,0
 db 'les'
 dw ls_instruction-assembler,0
 db 'lfs'
 dw ls_instruction-assembler,4
 db 'lgs'
 dw ls_instruction-assembler,5
 db 'lsl'
 dw lar_instruction-assembler,3
 db 'lss'
 dw ls_instruction-assembler,2
 db 'ltr'
 dw pm_word_instruction-assembler,3
 db 'mov'
 dw mov_instruction-assembler,0
 db 'mul'
 dw single_operand_instruction-assembler,4
 db 'neg'
 dw single_operand_instruction-assembler,3
 db 'nop'
 dw simple_instruction-assembler,90h
 db 'not'
 dw single_operand_instruction-assembler,2
 db 'org'
 dw org_directive-assembler,0
 db 'out'
 dw out_instruction-assembler,0
 db 'pop'
 dw pop_instruction-assembler,0
 db 'por'
 dw mmx_instruction-assembler,EBh
 db 'rcl'
 dw sh_instruction-assembler,2
 db 'rcr'
 dw sh_instruction-assembler,3
 db 'rep'
 dw prefix_instruction-assembler,F3h
 db 'ret'
 dw ret_instruction-assembler,C2h
 db 'rol'
 dw sh_instruction-assembler,0
 db 'ror'
 dw sh_instruction-assembler,1
 db 'rsm'
 dw simple_extended_instruction-assembler,AAh
 db 'sal'
 dw sh_instruction-assembler,6
 db 'sar'
 dw sh_instruction-assembler,7
 db 'sbb'
 dw basic_instruction-assembler,18h
 db 'shl'
 dw sh_instruction-assembler,4
 db 'shr'
 dw sh_instruction-assembler,5
 db 'stc'
 dw simple_instruction-assembler,F9h
 db 'std'
 dw simple_instruction-assembler,FDh
 db 'sti'
 dw simple_instruction-assembler,FBh
 db 'str'
 dw pm_word_instruction-assembler,1
 db 'sub'
 dw basic_instruction-assembler,28h
 db 'ud2'
 dw simple_extended_instruction-assembler,0Bh
 db 'xor'
 dw basic_instruction-assembler,30h
 db 0
instructions_4:
 db 'arpl'
 dw arpl_instruction-assembler,0
 db 'call'
 dw call_instruction-assembler,0
 db 'clts'
 dw simple_extended_instruction-assembler,6
 db 'cmps'
 dw cmps_instruction-assembler,0
 db 'cwde'
 dw simple_instruction_32bit-assembler,98h
 db 'else'
 dw else_directive-assembler,0
 db 'emms'
 dw simple_extended_instruction-assembler,77h
 db 'fabs'
 dw simple_fpu_instruction-assembler,100001b
 db 'fadd'
 dw basic_fpu_instruction-assembler,0
 db 'fbld'
 dw fbld_instruction-assembler,4
 db 'fchs'
 dw simple_fpu_instruction-assembler,100000b
 db 'fcom'
 dw basic_fpu_instruction-assembler,2
 db 'fcos'
 dw simple_fpu_instruction-assembler,111111b
 db 'fdiv'
 dw basic_fpu_instruction-assembler,6
 db 'fild'
 dw fild_instruction-assembler,0
 db 'file'
 dw data_file-assembler,101h
 db 'fist'
 dw fild_instruction-assembler,2
 db 'fld1'
 dw simple_fpu_instruction-assembler,101000b
 db 'fldz'
 dw simple_fpu_instruction-assembler,101110b
 db 'fmul'
 dw basic_fpu_instruction-assembler,1
 db 'fnop'
 dw simple_fpu_instruction-assembler,010000b
 db 'fsin'
 dw simple_fpu_instruction-assembler,111110b
 db 'fstp'
 dw fld_instruction-assembler,3
 db 'fsub'
 dw basic_fpu_instruction-assembler,4
 db 'ftst'
 dw simple_fpu_instruction-assembler,100100b
 db 'fxam'
 dw simple_fpu_instruction-assembler,100101b
 db 'fxch'
 dw fxch_instruction-assembler,1
 db 'heap'
 dw heap_directive-assembler,0
 db 'idiv'
 dw single_operand_instruction-assembler,7
 db 'imul'
 dw imul_instruction-assembler,0
 db 'insb'
 dw simple_instruction-assembler,6Ch
 db 'insd'
 dw simple_instruction_32bit-assembler,6Dh
 db 'insw'
 dw simple_instruction_16bit-assembler,6Dh
 db 'int3'
 dw simple_instruction-assembler,CCh
 db 'into'
 dw simple_instruction-assembler,CEh
 db 'invd'
 dw simple_extended_instruction-assembler,8
 db 'iret'
 dw simple_instruction-assembler,CFh
 db 'jcxz'
 dw loop_instruction_16bit-assembler,E3h
 db 'jnae'
 dw conditional_jump-assembler,72h
 db 'jnbe'
 dw conditional_jump-assembler,77h
 db 'jnge'
 dw conditional_jump-assembler,7Ch
 db 'jnle'
 dw conditional_jump-assembler,7Fh
 db 'lahf'
 dw simple_instruction-assembler,9Fh
 db 'lgdt'
 dw pm_pword_instruction-assembler,2
 db 'lidt'
 dw pm_pword_instruction-assembler,3
 db 'lldt'
 dw pm_word_instruction-assembler,2
 db 'lmsw'
 dw pm_word_instruction-assembler,16h
 db 'lock'
 dw prefix_instruction-assembler,F0h
 db 'lods'
 dw lods_instruction-assembler,0
 db 'loop'
 dw loop_instruction-assembler,E2h
 db 'movd'
 dw movd_instruction-assembler,0
 db 'movq'
 dw movq_instruction-assembler,0
 db 'movs'
 dw movs_instruction-assembler,0
 db 'outs'
 dw outs_instruction-assembler,0
 db 'pand'
 dw mmx_instruction-assembler,DBh
 db 'popa'
 dw simple_instruction-assembler,61h
 db 'popf'
 dw simple_instruction-assembler,9Dh
 db 'push'
 dw push_instruction-assembler,0
 db 'pxor'
 dw mmx_instruction-assembler,EFh
 db 'repe'
 dw prefix_instruction-assembler,F3h
 db 'repz'
 dw prefix_instruction-assembler,F3h
 db 'retd'
 dw ret_instruction_32bit-assembler,C2h
 db 'retf'
 dw ret_instruction-assembler,CAh
 db 'retw'
 dw ret_instruction_16bit-assembler,C2h
 db 'sahf'
 dw simple_instruction-assembler,9Eh
 db 'scas'
 dw stos_instruction-assembler,AEh
 db 'seta'
 dw set_instruction-assembler,97h
 db 'setb'
 dw set_instruction-assembler,92h
 db 'setc'
 dw set_instruction-assembler,92h
 db 'sete'
 dw set_instruction-assembler,94h
 db 'setg'
 dw set_instruction-assembler,9Fh
 db 'setl'
 dw set_instruction-assembler,9Ch
 db 'seto'
 dw set_instruction-assembler,90h
 db 'setp'
 dw set_instruction-assembler,9Ah
 db 'sets'
 dw set_instruction-assembler,98h
 db 'setz'
 dw set_instruction-assembler,94h
 db 'sgdt'
 dw pm_pword_instruction-assembler,0
 db 'shld'
 dw shd_instruction-assembler,A4h
 db 'shrd'
 dw shd_instruction-assembler,ACh
 db 'sidt'
 dw pm_pword_instruction-assembler,1
 db 'sldt'
 dw pm_word_instruction-assembler,0
 db 'smsw'
 dw pm_word_instruction-assembler,14h
 db 'stos'
 dw stos_instruction-assembler,AAh
 db 'test'
 dw test_instruction-assembler,0
 db 'verr'
 dw pm_word_instruction-assembler,4
 db 'verw'
 dw pm_word_instruction-assembler,5
 db 'wait'
 dw simple_instruction-assembler,9Bh
 db 'xadd'
 dw basic_486_instruction-assembler,C0h
 db 'xchg'
 dw xchg_instruction-assembler,0
 db 'xlat'
 dw xlat_instruction-assembler,D7h
 db 0
instructions_5:
 db 'bound'
 dw bound_instruction-assembler,0
 db 'bswap'
 dw bswap_instruction-assembler,0
 db 'cmova'
 dw cmov_instruction-assembler,47h
 db 'cmovb'
 dw cmov_instruction-assembler,42h
 db 'cmovc'
 dw cmov_instruction-assembler,42h
 db 'cmove'
 dw cmov_instruction-assembler,44h
 db 'cmovg'
 dw cmov_instruction-assembler,4Fh
 db 'cmovl'
 dw cmov_instruction-assembler,4Ch
 db 'cmovo'
 dw cmov_instruction-assembler,40h
 db 'cmovp'
 dw cmov_instruction-assembler,4Ah
 db 'cmovs'
 dw cmov_instruction-assembler,48h
 db 'cmovz'
 dw cmov_instruction-assembler,44h
 db 'cmpsb'
 dw simple_instruction-assembler,A6h
 db 'cmpsd'
 dw simple_instruction_32bit-assembler,A7h
 db 'cmpsw'
 dw simple_instruction_16bit-assembler,A7h
 db 'cpuid'
 dw simple_extended_instruction-assembler,A2h
 db 'enter'
 dw enter_instruction-assembler,0
 db 'entry'
 dw entry_directive-assembler,0
 db 'f2xm1'
 dw simple_fpu_instruction-assembler,110000b
 db 'faddp'
 dw faddp_instruction-assembler,0
 db 'fbstp'
 dw fbld_instruction-assembler,6
 db 'fclex'
 dw finit_instruction-assembler,E2h
 db 'fcomp'
 dw basic_fpu_instruction-assembler,3
 db 'fdivp'
 dw faddp_instruction-assembler,6
 db 'fdivr'
 dw basic_fpu_instruction-assembler,7
 db 'ffree'
 dw ffree_instruction-assembler,0
 db 'fiadd'
 dw fi_instruction-assembler,0
 db 'ficom'
 dw fi_instruction-assembler,2
 db 'fidiv'
 dw fi_instruction-assembler,6
 db 'fimul'
 dw fi_instruction-assembler,1
 db 'finit'
 dw finit_instruction-assembler,E3h
 db 'fistp'
 dw fild_instruction-assembler,3
 db 'fisub'
 dw fi_instruction-assembler,4
 db 'fldcw'
 dw fldcw_instruction-assembler,5
 db 'fldpi'
 dw simple_fpu_instruction-assembler,101011b
 db 'fmulp'
 dw faddp_instruction-assembler,1
 db 'fprem'
 dw simple_fpu_instruction-assembler,111000b
 db 'fptan'
 dw simple_fpu_instruction-assembler,110010b
 db 'fsave'
 dw fsave_instruction-assembler,6
 db 'fsqrt'
 dw simple_fpu_instruction-assembler,111010b
 db 'fstcw'
 dw fldcw_instruction-assembler,7
 db 'fstsw'
 dw fstsw_instruction-assembler,0
 db 'fsubp'
 dw faddp_instruction-assembler,4
 db 'fsubr'
 dw basic_fpu_instruction-assembler,5
 db 'fucom'
 dw ffree_instruction-assembler,4
 db 'fwait'
 dw simple_instruction-assembler,9Bh
 db 'fyl2x'
 dw simple_fpu_instruction-assembler,110001b
 db 'iretd'
 dw simple_instruction_32bit-assembler,CFh
 db 'iretw'
 dw simple_instruction_16bit-assembler,CFh
 db 'jecxz'
 dw loop_instruction_32bit-assembler,E3h
 db 'label'
 dw label_directive-assembler,0
 db 'leave'
 dw simple_instruction-assembler,C9h
 db 'lodsb'
 dw simple_instruction-assembler,ACh
 db 'lodsd'
 dw simple_instruction_32bit-assembler,ADh
 db 'lodsw'
 dw simple_instruction_16bit-assembler,ADh
 db 'loopd'
 dw loop_instruction_32bit-assembler,E2h
 db 'loope'
 dw loop_instruction-assembler,E1h
 db 'loopw'
 dw loop_instruction_16bit-assembler,E2h
 db 'loopz'
 dw loop_instruction-assembler,E1h
 db 'movsb'
 dw simple_instruction-assembler,A4h
 db 'movsd'
 dw simple_instruction_32bit-assembler,A5h
 db 'movsw'
 dw simple_instruction_16bit-assembler,A5h
 db 'movsx'
 dw movx_instruction-assembler,BEh
 db 'movzx'
 dw movx_instruction-assembler,B6h
 db 'outsb'
 dw simple_instruction-assembler,6Eh
 db 'outsd'
 dw simple_instruction_32bit-assembler,6Fh
 db 'outsw'
 dw simple_instruction_16bit-assembler,6Fh
 db 'paddb'
 dw mmx_instruction-assembler,FCh
 db 'paddd'
 dw mmx_instruction-assembler,FEh
 db 'paddw'
 dw mmx_instruction-assembler,FDh
 db 'pandn'
 dw mmx_instruction-assembler,DFh
 db 'popad'
 dw simple_instruction_32bit-assembler,61h
 db 'popaw'
 dw simple_instruction_16bit-assembler,61h
 db 'popfd'
 dw simple_instruction_32bit-assembler,9Dh
 db 'popfw'
 dw simple_instruction_16bit-assembler,9Dh
 db 'pslld'
 dw mmx_ps_instruction-assembler,F2h
 db 'psllq'
 dw mmx_ps_instruction-assembler,F3h
 db 'psllw'
 dw mmx_ps_instruction-assembler,F1h
 db 'psrad'
 dw mmx_ps_instruction-assembler,E2h
 db 'psraw'
 dw mmx_ps_instruction-assembler,E1h
 db 'psrld'
 dw mmx_ps_instruction-assembler,D2h
 db 'psrlq'
 dw mmx_ps_instruction-assembler,D3h
 db 'psrlw'
 dw mmx_ps_instruction-assembler,D1h
 db 'psubb'
 dw mmx_instruction-assembler,F8h
 db 'psubd'
 dw mmx_instruction-assembler,FAh
 db 'psubw'
 dw mmx_instruction-assembler,F9h
 db 'pusha'
 dw simple_instruction-assembler,60h
 db 'pushf'
 dw simple_instruction-assembler,9Ch
 db 'rdmsr'
 dw simple_extended_instruction-assembler,32h
 db 'rdpmc'
 dw simple_extended_instruction-assembler,33h
 db 'rdtsc'
 dw simple_extended_instruction-assembler,31h
 db 'repne'
 dw prefix_instruction-assembler,F2h
 db 'repnz'
 dw prefix_instruction-assembler,F2h
 db 'retfd'
 dw ret_instruction_32bit-assembler,CAh
 db 'retfw'
 dw ret_instruction_16bit-assembler,CAh
 db 'scasb'
 dw simple_instruction-assembler,AEh
 db 'scasd'
 dw simple_instruction_32bit-assembler,AFh
 db 'scasw'
 dw simple_instruction_16bit-assembler,AFh
 db 'setae'
 dw set_instruction-assembler,93h
 db 'setbe'
 dw set_instruction-assembler,96h
 db 'setge'
 dw set_instruction-assembler,9Dh
 db 'setle'
 dw set_instruction-assembler,9Eh
 db 'setna'
 dw set_instruction-assembler,96h
 db 'setnb'
 dw set_instruction-assembler,93h
 db 'setnc'
 dw set_instruction-assembler,93h
 db 'setne'
 dw set_instruction-assembler,95h
 db 'setng'
 dw set_instruction-assembler,9Eh
 db 'setnl'
 dw set_instruction-assembler,9Dh
 db 'setno'
 dw set_instruction-assembler,91h
 db 'setnp'
 dw set_instruction-assembler,9Bh
 db 'setns'
 dw set_instruction-assembler,99h
 db 'setnz'
 dw set_instruction-assembler,95h
 db 'setpe'
 dw set_instruction-assembler,9Ah
 db 'setpo'
 dw set_instruction-assembler,9Bh
 db 'stack'
 dw stack_directive-assembler,0
 db 'stosb'
 dw simple_instruction-assembler,AAh
 db 'stosd'
 dw simple_instruction_32bit-assembler,ABh
 db 'stosw'
 dw simple_instruction_16bit-assembler,ABh
 db 'times'
 dw times_directive-assembler,0
 db 'wrmsr'
 dw simple_extended_instruction-assembler,30h
 db 'xlatb'
 dw simple_instruction-assembler,D7h
 db 0
instructions_6:
 db 'cmovae'
 dw cmov_instruction-assembler,43h
 db 'cmovbe'
 dw cmov_instruction-assembler,46h
 db 'cmovge'
 dw cmov_instruction-assembler,4Dh
 db 'cmovle'
 dw cmov_instruction-assembler,4Eh
 db 'cmovna'
 dw cmov_instruction-assembler,46h
 db 'cmovnb'
 dw cmov_instruction-assembler,43h
 db 'cmovnc'
 dw cmov_instruction-assembler,43h
 db 'cmovne'
 dw cmov_instruction-assembler,45h
 db 'cmovng'
 dw cmov_instruction-assembler,4Eh
 db 'cmovnl'
 dw cmov_instruction-assembler,4Dh
 db 'cmovno'
 dw cmov_instruction-assembler,41h
 db 'cmovnp'
 dw cmov_instruction-assembler,4Bh
 db 'cmovns'
 dw cmov_instruction-assembler,49h
 db 'cmovnz'
 dw cmov_instruction-assembler,45h
 db 'cmovpe'
 dw cmov_instruction-assembler,4Ah
 db 'cmovpo'
 dw cmov_instruction-assembler,4Bh
 db 'fcompp'
 dw fcompp_instruction-assembler,0
 db 'fdivrp'
 dw faddp_instruction-assembler,7
 db 'ficomp'
 dw fi_instruction-assembler,3
 db 'fidivr'
 dw fi_instruction-assembler,7
 db 'fisubr'
 dw fi_instruction-assembler,5
 db 'fldenv'
 dw fldenv_instruction-assembler,4
 db 'fldl2e'
 dw simple_fpu_instruction-assembler,101010b
 db 'fldl2t'
 dw simple_fpu_instruction-assembler,101001b
 db 'fldlg2'
 dw simple_fpu_instruction-assembler,101100b
 db 'fldln2'
 dw simple_fpu_instruction-assembler,101101b
 db 'format'
 dw format_directive-assembler,0
 db 'fpatan'
 dw simple_fpu_instruction-assembler,110011b
 db 'fprem1'
 dw simple_fpu_instruction-assembler,110101b
 db 'frstor'
 dw fsave_instruction-assembler,4
 db 'fscale'
 dw simple_fpu_instruction-assembler,111101b
 db 'fstenv'
 dw fldenv_instruction-assembler,6
 db 'fsubrp'
 dw faddp_instruction-assembler,5
 db 'fucomp'
 dw ffree_instruction-assembler,5
 db 'invlpg'
 dw invlpg_instruction-assembler,0
 db 'looped'
 dw loop_instruction_32bit-assembler,E1h
 db 'loopew'
 dw loop_instruction_16bit-assembler,E1h
 db 'loopne'
 dw loop_instruction-assembler,E0h
 db 'loopnz'
 dw loop_instruction-assembler,E0h
 db 'loopzd'
 dw loop_instruction_32bit-assembler,E1h
 db 'loopzw'
 dw loop_instruction_16bit-assembler,E1h
 db 'paddsb'
 dw mmx_instruction-assembler,ECh
 db 'paddsw'
 dw mmx_instruction-assembler,EDh
 db 'pmulhw'
 dw mmx_instruction-assembler,E5h
 db 'pmullw'
 dw mmx_instruction-assembler,D5h
 db 'psubsb'
 dw mmx_instruction-assembler,E8h
 db 'psubsw'
 dw mmx_instruction-assembler,E9h
 db 'pushad'
 dw simple_instruction_32bit-assembler,60h
 db 'pushaw'
 dw simple_instruction_16bit-assembler,60h
 db 'pushfd'
 dw simple_instruction_32bit-assembler,9Ch
 db 'pushfw'
 dw simple_instruction_16bit-assembler,9Ch
 db 'repeat'
 dw repeat_directive-assembler,0
 db 'setalc'
 dw simple_instruction-assembler,D6h
 db 'setnae'
 dw set_instruction-assembler,92h
 db 'setnbe'
 dw set_instruction-assembler,97h
 db 'setnge'
 dw set_instruction-assembler,9Ch
 db 'setnle'
 dw set_instruction-assembler,9Fh
 db 'wbinvd'
 dw simple_extended_instruction-assembler,9
 db 0
instructions_7:
 db 'cmovnae'
 dw cmov_instruction-assembler,42h
 db 'cmovnbe'
 dw cmov_instruction-assembler,47h
 db 'cmovnge'
 dw cmov_instruction-assembler,4Ch
 db 'cmovnle'
 dw cmov_instruction-assembler,4Fh
 db 'cmpxchg'
 dw basic_486_instruction-assembler,B0h
 db 'fdecstp'
 dw simple_fpu_instruction-assembler,110110b
 db 'fincstp'
 dw simple_fpu_instruction-assembler,110111b
 db 'frndint'
 dw simple_fpu_instruction-assembler,111100b
 db 'fsincos'
 dw simple_fpu_instruction-assembler,111011b
 db 'fxtract'
 dw simple_fpu_instruction-assembler,110100b
 db 'fyl2xp1'
 dw simple_fpu_instruction-assembler,111001b
 db 'loopned'
 dw loop_instruction_32bit-assembler,E0h
 db 'loopnew'
 dw loop_instruction_16bit-assembler,E0h
 db 'loopnzd'
 dw loop_instruction_32bit-assembler,E0h
 db 'loopnzw'
 dw loop_instruction_16bit-assembler,E0h
 db 'paddusb'
 dw mmx_instruction-assembler,DCh
 db 'paddusw'
 dw mmx_instruction-assembler,DDh
 db 'pcmpeqb'
 dw mmx_instruction-assembler,74h
 db 'pcmpeqd'
 dw mmx_instruction-assembler,76h
 db 'pcmpeqw'
 dw mmx_instruction-assembler,75h
 db 'pcmpgtb'
 dw mmx_instruction-assembler,64h
 db 'pcmpgtd'
 dw mmx_instruction-assembler,66h
 db 'pcmpgtw'
 dw mmx_instruction-assembler,65h
 db 'pmaddwd'
 dw mmx_instruction-assembler,F5h
 db 'psubusb'
 dw mmx_instruction-assembler,D8h
 db 'psubusw'
 dw mmx_instruction-assembler,D9h
 db 'segment'
 dw segment_directive-assembler,0
 db 'sysexit'
 dw simple_extended_instruction-assembler,35h
 db 'virtual'
 dw virtual_directive-assembler,0
 db 0
instructions_8:
 db 'packssdw'
 dw mmx_instruction-assembler,6Bh
 db 'packsswb'
 dw mmx_instruction-assembler,63h
 db 'packuswb'
 dw mmx_instruction-assembler,67h
 db 'sysenter'
 dw simple_extended_instruction-assembler,34h
 db 0
instructions_9:
 db 'cmpxchg8b'
 dw cmpxchg8b_instruction-assembler,0
 db 'punpckhbw'
 dw mmx_instruction-assembler,68h
 db 'punpckhdq'
 dw mmx_instruction-assembler,6Ah
 db 'punpckhwd'
 dw mmx_instruction-assembler,69h
 db 'punpcklbw'
 dw mmx_32bit_instruction-assembler,60h
 db 'punpckldq'
 dw mmx_32bit_instruction-assembler,62h
 db 'punpcklwd'
 dw mmx_32bit_instruction-assembler,61h
 db 0
instructions_10:
 db 'loadall286'
 dw simple_extended_instruction-assembler,5
 db 'loadall386'
 dw simple_extended_instruction-assembler,7
 db 0
