#-------------------------------------------------------------------
#        D - F L A T   M A K E F I L E  -  Turbo C++ 3.0
#-------------------------------------------------------------------

all : edit.exe edit.hlp

#------------------------------------------------
# NOTE: Set DRIVE to match where you installed your compiler
#------------------------------------------------
DRIVE = c:\
#-------------------------------------------------------------------
#  Delete the TESTING macro to eliminate the Reload
#  Help file selection on the Help menu.
#-------------------------------------------------------------------
TESTING = TESTING_DFLAT
#-------------------------------------------------------------------
#  This macro builds the full D-Flat system with all options enabled.
#  Comment it out for a minimum system or selectively
#  comment out the #defines at the top of dflat.h.
#-------------------------------------------------------------------
FULL = BUILD_FULL_DFLAT
#-------------------------------------------------------------------

MODEL = l
#------------------------------------------------
# NOTE: Delete the DEBUG and LINKDEBUG macros to 
# build without debugging information in the .EXE
#------------------------------------------------
DEBUG = -v
LINKDEBUG = /v
#------------------------------------------------
# NOTE: Temporary file space. Change to match
#       your computer. A RAM disk works best.
#------------------------------------------------
HEADERS=c:\temp
#------------------------------------------------
COMPILE = tcc $(DEBUG) -D$(TESTING) -D$(FULL) -DBCPP -c -d -m$(MODEL) 
LINK= tlink $(LINKDEBUG) $(DRIVE)\tc3\lib\c0$(MODEL) 
LIBS= $(DRIVE)\tc3\lib\c$(MODEL)
#------------------------------------------------

.c.obj:
	$(COMPILE) $*.c

edit.exe : edit.obj dialogs.obj menus.obj dflat.lib
	$(LINK) edit dialogs menus,edit.exe,edit,dflat $(LIBS)

dflat.lib :   window.obj video.obj message.obj                         \
			  mouse.obj console.obj textbox.obj listbox.obj            \
			  normal.obj config.obj menu.obj menubar.obj popdown.obj   \
			  rect.obj applicat.obj keys.obj sysmenu.obj editbox.obj   \
			  dialbox.obj button.obj fileopen.obj msgbox.obj           \
			  helpbox.obj log.obj lists.obj statbar.obj decomp.obj     \
			  combobox.obj pictbox.obj calendar.obj barchart.obj       \
			  clipbord.obj search.obj dfalloc.obj checkbox.obj         \
			  text.obj radio.obj box.obj spinbutt.obj  watch.obj       \
			  slidebox.obj direct.obj
	del dflat.lib
	tlib dflat @dflat.bld

huffc.exe : huffc.obj htree.obj
	$(LINK) huffc htree,$*.exe,$*,$(LIBS)

edit.hlp : edit.txt huffc.exe
		huffc edit.txt edit.hlp

