/*
Copyright (C) 1997-2000 Erwin Waterlander

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef _DISPLAY_H
#define _DISPLAY_H


#ifdef WCD_USECONIO
#  include <conio.h>
#endif

#ifdef WCD_USECURSES
#  include <curses.h>
#endif

int display_list(nameset list,int perfect);
int maxLength(nameset list);

#define OFFSET 39
#ifdef WCD_USECURSES
int wcd_prefresh(WINDOW *pad, int pminrow, int pmincol,
             int sminrow, int smincol, int smaxrow, int smaxcol, int pmaxcol, int shift);
#  define PAGEOFFSET 38
#  define BLANKING 16      /* extra blank space for scrolling to right */
#  define INPUT_WIN_LEN 70
#else
#  define PAGEOFFSET 46
#endif
#define SCROLL_WIN_HEIGHT 22
#define INPUT_WIN_HEIGHT 3
#endif
