/*
Copyright (C) 1997-2000 Erwin Waterlander

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _WCD_H
#define _WCD_H

#include "tailor.h"

#ifdef VMS
#  define EXIT_OK 1
#  define ALT_SW || *argv[i]=='/'
#  define CHDIR(s) vms_chdir(s)
#else
#  define EXIT_OK 0
#  define CHDIR(s) chdir(s)
#  ifdef MSDOS
#    define ALT_SW || *argv[i]=='/'
#    define TREEFILE "/treedata.wcd"
#    define RELTREEFILE "/rtdata.wcd"   /* relative treedata */
#    define EXTRA_TREEFILE "/extra.wcd"
#    define BANFILE "/ban.wcd"
#    define ALIASFILE "/alias.wcd"
#	 define STACK_GO_DRIVE "c:"
#    define STACKFILE "/stack.wcd"
#    if (defined(WIN32) && !defined(ZSH))
#      define GO_FILE "/wcdgo.bat"
#    else
#      define GO_FILE "/wcd.go"
#    endif
#    define ROOTDIR "/"
#    define DIR_SEPARATOR '/'
#  else /* ?UNIX */
#    define ALT_SW
#    define TREEFILE "/.treedata.wcd"
#    define RELTREEFILE "/.rtdata.wcd"   /* relative treedata */
#    define EXTRA_TREEFILE "/.extra.wcd"
#    define BANFILE "/.ban.wcd"
#    define ALIASFILE "/.alias.wcd"
#    define STACKFILE "/.stack.wcd"
#    define ROOTDIR "/"
#    define HOMESTRING "/home/"
#    define TMP_MNT_STR "/tmp_mnt/" /* temp mount dir for automounter, including ending / */
#    define GO_FILE "/bin/wcd.go"
#    define DIR_SEPARATOR '/'
#  endif /* ?MSDOS */
#endif /* ?VMS */

#if defined(MSDOS) || defined(VMS)
#  define OP_DIR ""
#else /* ?unix */
#  define OP_DIR "."
#endif /* ?MSDOS|VMS */

#define VERSION      "2.3.2"
#define VERSION_DATE "Jun 10 2000"


/* Function prototypes */

#if defined(UNIX) || defined(BASH)
void quoteString(char *string);
#endif


void finddirs(char *dir, int *offset, FILE *outfile, int *use_HOME);
void read_treefile(char* filename, nameset bd);
void rmDirFromList(char *string, nameset n);
void writeList(char * filename, nameset n);
void cleanTreeFile(char *filename, char *dir);

char *removeBackSlash(char *string);
void addCurPathToFile(char *filename, int *use_HOME, int parents);
int  checkban(char *dir, nameset bd);
int check_double_match(char *dir, int perfect, nameset pm, nameset wm);
void scanfile(char *org_dir, char *filename, int ignore_case, nameset pm, nameset wm, nameset bd, int relative, int quiet, int wildOnly);
void scanaliasfile(char *org_dir, char *filename, nameset pm, nameset wm, int quiet, int wildOnly);
int  strcompare(const char*, const char*, int);
void printhelp(void);
int  wcd_get_int(void);
int getline(char s[], int lim, FILE* infile);
int wcd_exit(nameset pm, nameset wm, nameset ef, nameset bd, nameset nfs, WcdStack ws);

#ifdef BASH
	void empty_wcdgo(char *go_file, int changedrive, char *drive);
#else
	void empty_wcdgo(char *go_file);
#endif
int SpecialDir(const char *path);

#endif
