/*  HTML Stuf

    Copyright (c) Express Software 1998.
    All Rights Reserved.

    Created by: Joseph Cosentino.

    21st May 2000 - Forward only keyboard selection of links - BS
*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include "help.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define X 1
#define Y 1
#define W 80
#define H 25
#define N 21
#define TX (X+10)
#define TY (Y+H-2)
#define TW (W-12)
#define LEN (W-6)
#define BARX (X+W-3)
#define BARY (Y+2)
#define BARLEN (N-2)

#define MAX_BACKS 8
#undef BORDER_COLOR

#define TEXT_COLOR   (Black+BakWhite)
#define LINK_COLOR   (BrBlue+BakWhite)
#define TYPE_COLOR   (White+BakBlack)
#define FOUND_COLOR  (BrRed+BakWhite)
#define BORDER_COLOR (Yellow+BakWhite)
#define BOLD_COLOR   (BrWhite+BakWhite)
#define ITALIC_COLOR (Magenta+BakWhite) // BS

// F U N C T I O N S ////////////////////////////////////////////////////////

void html_view(char *target_name)
{
    long i, j, k, n, ch, line, len, maxtop, nchars, first_time, enable_timer, force_redraw, link_started, seek_cnt, check_mouse, mline, mpos, left_was_pressed, num_backs, barpos, old_barpos, forced_barpos, bar_hooked, l, bold_started, it_started;
    char *p, *q, *s, *top, *old_top, *bottom, *seek_base, *bs, *bq, *tmp, *col, *str, *link_reference, *link_under_mouse, *link_back[MAX_BACKS], *mesg, *buf, *text, *text_buf=0, *bold_text, *li_pointer, *it_text;
    struct event ev;
    static char err_msg[80];
    FILE *f;
    char *clink; // BS

    /* Next 2 lines added by Brian E. Reifsnyder */
    char *br_pointer;
    char *p_pointer;

    p=base_dir+strlen(base_dir);
    if (target_name==0 || *target_name==0 || *target_name=='#')
	strcat(p, "help.htm");
    else
	{
	for (q=target_name,s=p;*q!=0&&*q!='#';q++,s++)
	    *s=*q;

	*s=0;
	target_name = (*q!=0) ? q : 0;
	} // end else.

    sprintf(err_msg, "Error reading %s", base_dir);
    f=fopen(base_dir,"r");
    *p=0;

    if (f == 0)
	{
        show_error(err_msg);
        return;
        } // end if.

    l=filelength(fileno(f));
    l=min(l,65530L);
    if ((text_buf=malloc(l+1)) == 0)
        {
        show_error("Cannot allocate more memory.");
        return;
        } // end if.

    if (fread(text_buf,1,l,f) == 0)
        {
        show_error(err_msg);
        free(text_buf);
        return;
        } // end if.

    fclose(f);
    text=text_buf;
    text[l]=0;
    if ((buf= (char *)malloc(8000+3*LEN+3+16)) == 0)
        {
        show_error("Cannot allocate more memory.");
        if (text_buf != 0)
            free(text_buf);

        return;
        } // end if.

    /* Added by Brian E. Reifsnyder */

    /* Replaces all <br> statements with 3 spaces and a carriage return. */

    do
        {
        br_pointer=NULL;
        br_pointer=strstr(text,"<br>");
        if (br_pointer!=NULL)
            {
            strncpy(br_pointer,"   \n",3);
            } // end if.

        } // end do.
    while (br_pointer!=NULL);

    /* Replaces all <p> statements with 1 space and 2 carriage returns. */
    do
        {
        p_pointer=NULL;
        p_pointer=strstr(text,"<p>");
        if (p_pointer!=NULL)
            {
            strncpy(p_pointer," \n\n",3);
            } // end if.

        } // end do.
    while (p_pointer!=NULL);

    /* End Section Added by Brian E. Reifsnyder */

    // The little bullet doo-dad.
    do
        {
        li_pointer=NULL;
        li_pointer=strstr(text,"<li>");
        if (li_pointer!=NULL)
            {
            strncpy(li_pointer,"  \007 ",4);
            } // end if.

        } // end do.
    while (li_pointer!=NULL);

    tmp=buf+4000;
    col=tmp+LEN+1;
    str=col+LEN+1;
    save_window(X, Y, W, H, buf);
    border_window(BORDER_COLOR, X, Y, W, H, Border22f);
    border_window(BORDER_COLOR, X, Y+H-3, W, 3, Border21if);
    write_char(BORDER_COLOR, BARX, BARY-1, '');
    write_char(BORDER_COLOR, BARX, BARY+BARLEN, '');
    if ((bs=strstr(text,"<body>"))==0 || (bq=strstr(bs+=6,"</body>")) == 0)
	{
	bs=text;
	bq=bs+strlen(text);
	} // end if.

    while (*bs=='\r' || *bs=='\n')
	bs++;

    while (*bq=='\r' || *bq=='\n')
	q--;

    if (bs>=bq)
	{
	bs="\nDocument is empty.\n";
	bq=bs+strlen(bs);
	} // end if.

    i=N;
    p=bq-1;
    if (*p=='\n')
	p--;

    for (;p!=bs;p--)
        if (*p=='\n')
            {
            i--;
            if (i == 0)
                {
                p++;
                break;
                } // end if.

            } // end if.

	maxtop=p-bs;
	nchars++;                       // No warnings.
        mesg=0;
        top=bs;
        nchars=0;
        seek_cnt=0;
        num_backs=0;
        bar_hooked=0;
        check_mouse=0;
        force_redraw=1;
        first_time=1;
        enable_timer=0;
        move_cursor(1,26);
        bold_text=bold_text;
        it_text=it_text;
        clink=top;                      // No link selected! make =0 for autoselect 1st.

        while (1)
            {
            if (target_name != 0)
                {
                p=target_name;
                q=strchr(p,'\"');
                if (q != 0)
                    k=q-p;
                else
                    k=strlen(p);

                if (k<0 || k>LEN-12)
		    k=LEN-12;

                if (*p=='#')
                    {
                    sprintf(tmp,"<a name=\"%.*s\"",(int)(k-1),p+1);
                    p=strstr(bs,tmp);
                    if (p!=0 && p<bq)
                        {
                        while (p!=bs && *p!='\n')
			    p--;

                        if (*p=='\n')
                            p++;

                        if (num_backs<MAX_BACKS && !first_time)
                            link_back[num_backs++]=top;

                        top=p;
                        } // end if.
                    else
                        {
                        sprintf(err_msg, "Reference %s not found\n" ,tmp+8);
                        mesg=err_msg;
                        } // end else.

                    } // end if. 
		else
                    {
                    sprintf(tmp,"%.*s",(unsigned int)k,p);
                    if (strncmpi(tmp,"http://",7)!=0 && strncmpi(tmp,"ftp://",6)!=0 && strncmpi(tmp,"mailto:",7)!=0)
                        {
                        html_view(tmp);
                        } // end if.

                    } // end else.

                target_name=0;
                } // end if.

	first_time=0;
        if (seek_cnt != 0)
            {
            if (seek_cnt < 0)
                {
		i =- seek_cnt;
                p=seek_base-1;
                if (*p=='\n')
                    p--;

                for (;p!=bs;p--)
                    if (*p=='\n')
                        {
			i--;
                        if (i == 0)
                            {
                            p++;
                            break;
                            } // end if.

                        } // end if.

                top=p;
                clink=top;
                } // end if.
            else if (seek_cnt > 0)
                {
		i=seek_cnt;
                p=seek_base;
                for (;p!=bq;p++)
                    if (*p == '\n')
                        {
                        i--;
                        if (i == 0)
                            {
                            p++;
                            break;
                            } // end if.

                        } // end if.

		if (p == bq)
                    {
                    seek_base=bq-1;
                    seek_cnt=-1;
                    continue;
                    } // end if.

                top=p;
                clink=top;
                } // end else.
        
            seek_cnt=0;
            } // end if.

        if (maxtop != 0)
            barpos=((top-bs)*(BARLEN))/maxtop;
        else
            barpos=BARLEN-1;

        if (barpos >= BARLEN)
            barpos=BARLEN-1;
     
        if (bar_hooked)
            {
            seek_base=top;
            if (forced_barpos == 0)
		{
                top=bs;
                barpos=0;
                } // end if.
            else if (forced_barpos == BARLEN-1 && barpos != forced_barpos)
                {
                old_barpos=barpos;
                seek_base=bq;
                seek_cnt=-N;
                continue;
		} // end else.
            else if (forced_barpos < barpos && forced_barpos < old_barpos)
                {
		old_barpos=barpos;
                seek_cnt=-1;
                continue;
                } // end else.
            else if (forced_barpos > barpos && forced_barpos > old_barpos)
                {
                old_barpos=barpos;
                seek_cnt=+1;
                continue;
                } // end else.

            } // end if.
     
	old_barpos=barpos;
        if (top != old_top)
            force_redraw=1;

        if (force_redraw == 1 || check_mouse == 1)
            {
            p=top;
            k=0;
            len=0;
            line=0;
            link_started=0;
            link_under_mouse=0;
            bold_started=0;
            it_started=0;
	    while (1)
                {
                if (*p=='\n' || len==LEN || p==bq)
                    {
                    if (*p != '\n' && p != bq)
                        while (*p!='\n' && p!=bq)
			    p++;

                    if (*p == '\n' && p != bq)
                        p++;
               
                    while (len != LEN)
                        {
			tmp[len]=' ';
                        col[len] = TEXT_COLOR;
                        len++;
                        } // end while.

                    if (force_redraw == 1)
                        {
                        for (i=0,j=0;i<LEN;i++)
                            {
                            str[j++]=tmp[i];
                            str[j++]=col[i];
                            } // end for.

			load_window(X+2, Y+1+line, LEN, 1, str);
                        } // end if.

                    line++;
                    len=0;
                    if (p == bq || line == N)
                        {
                        if (line != N)
                            clear_window(TEXT_COLOR, X+2, Y+1+line, LEN, N-line);

                        break;
                        } // end if.

		    continue;
                    } // end if.

                if (*p == '\r')
                    {
                    p++;
                    continue;
                    } // end if.

                if (*p=='<' && (p[1]>='A' && p[1]<='Z' || p[1]=='/' || p[1]>='a' && p[1]<='z' || p[1]=='!'))
                    {
                    if (link_started==0 && strncmpi(p,"<a href=",8) == 0)
                        {
			link_reference=p+8;
                        if (*link_reference=='\"')
                            link_reference++;

                        if (!clink)
                            clink=link_reference;

                        link_started=1;
                        } // end if.
                    else if (link_started==1 && strncmpi(p,"</a>",4) == 0)
                        {
                        link_started=0;
                        } // end else.
                    else if (bold_started==0 && strncmpi(p,"<b>",3) == 0)
                        {
                        bold_started=1;
                        bold_text=p+3;
                        } // end else.
		    else if (bold_started==1 && strncmpi(p,"</b>",4) == 0)
			{
			bold_started=0;
			} // end else.
                    else if (it_started==0 && strncmpi(p,"<i>",3) == 0)
                        {
                        it_started=1;
                        it_text=p+3;
                        } // end else.
                    else if (it_started==1 && strncmpi(p,"</i>",4) == 0)
                        {
                        it_started=0;
                        } // end else.
		    else if (strncmpi(p,"<hr",3) == 0)
			{
			while (len != LEN)
			    {
			    tmp[len]='';
			    col[len]=TEXT_COLOR;
			    len++;
			    } // end while.

			} // end else.

		    while (*p != '>' && p != bq)
			p++;

		    if (*p== '>')
			p++;

		    continue;
		    } // end if.

		ch=*p;
		if (*p == '&')
		    {
		    if (strncmp(p,"&gt;",4)==0 && bq-p>4)
			{
			ch='>';
			p+=3;
			} // end if.
		    else if (strncmp(p,"&lt;",4)==0 && bq-p>4)
			{
			ch='<';
			p+=3;
			} // end else.
		    else if (strncmp(p,"&quot;",6)==0 && bq-p>6)
			{
			ch='\"';
			p+=5;
			} // end else.
		    else if (strncmp(p,"&nbsp;",6)==0 && bq-p>6)
			{
			ch=' ';
			p+=5;
                        } // end else.

		    } // end if.

		tmp[len] = (ch!='\t' ) ? ch : ' ';
                col[len] = link_started ? LINK_COLOR : TEXT_COLOR && bold_started ? BOLD_COLOR : TEXT_COLOR && it_started ? ITALIC_COLOR : TEXT_COLOR;
                if (link_started && link_reference==clink)
                    col[len] = Yellow+BakWhite;

                if (check_mouse && line==mline && len==mpos && link_started)
		    link_under_mouse=link_reference;

		len++;
		if (ch != '\t' || len % 8 == 0)
		    p++;

		} // end while.

	    if (force_redraw == 1)
		{
		bottom=p;
		write_string(BORDER_COLOR, X+2+LEN-6, Y+1, "\x1B Back");
		for (i=0;i<BARLEN;i++)
		    {
		    write_char(BORDER_COLOR, BARX, BARY+i, (i!=barpos)?'':'');
		    } // end for.

		old_top=top;
		force_redraw=0;
		} // end if.

	    } // end if.

	if (link_under_mouse != 0)
	    {
            p=link_under_mouse;
	    k=strchr(p,'\"')-p;
	    if (k < 0 || k > LEN-12)
		k=LEN-12;

	    sprintf(tmp,"%.*s",(int)k,p);
	    if (mesg == 0)
		mesg=tmp;

	    } // end if.

	clear_window(TEXT_COLOR,X+2,TY,LEN,1);
	if (mesg != 0)
	    {
	    write_string(TEXT_COLOR,X+2,TY,mesg);
	    mesg=0;
	    } // end if.

	if (enable_timer)
	    {
	    ev.timer=1;
	    get_event(&ev, EV_KEY | EV_MOUSE | EV_TIMER);
	    enable_timer=0;
	    } // end if.
	else
	    {
	    get_event(&ev, EV_KEY | EV_MOUSE);
	    } // end else.

        if (ev.ev_type == EV_KEY && ev.key == 9)
            {
            clink = strstr(clink,"<a href=");
            if (!clink)
                {
                clink=top;
                clink = strstr(clink,"<a href=");
                } // end if.

            if (!clink)
                clink=top;
            else
                clink += 8;

            if (*clink == '\"')
                clink++;

            if (clink-top > bottom-top)
                {
		seek_base=top;
		seek_cnt=N-1;
                } // end if.

            force_redraw=1;
            } // end if.

        if (ev.ev_type == EV_KEY && ev.key == 13 && clink != top)
            {
            target_name = clink;
            force_redraw=1;
            } // end if.

	if (ev.ev_type == EV_KEY && ev.key == 27)
	    break;

	if (ev.ev_type & (EV_MOUSE | EV_TIMER))
	    {
	    if (((ev.ev_type & EV_TIMER) || left_was_pressed == 0) && ev.left == 1)
		{
		if (ev.x > X+2+LEN-7 && ev.x < X+2+LEN && ev.y == Y+1)
		    {
		    if (num_backs == 0)
			break;

		    top=link_back[--num_backs];
		    force_redraw=1;
		    } // end if.
		else if (link_under_mouse != 0)
		    {
		    p=link_under_mouse;
		    if (*p=='\"')
			p++;

		    target_name=p;
		    } // end else.
		else if (ev.x == BARX && ev.y >= BARY-1 && ev.y <= BARY+BARLEN)
		    {
		    if (ev.y == BARY-1) // Up.
			{
			if (top != bs)
			    {
			    seek_base=top;
			    seek_cnt=-1;
			    } // end if.

			enable_timer=1;
			} // end if.
		    else if (ev.y == BARY+BARLEN) // Down.
			{
			if (bottom != bq)
			    {
			    seek_base=top;
			    seek_cnt=+1;
			    } // end if.

			enable_timer=1;
			} // end else.
		    else
			{
			if (ev.y == BARY+barpos)
			    bar_hooked=1;

			} // end else.

		    } // end else.

		} // end if.

	    if (ev.x > X+1 && ev.x < X+LEN+2 && ev.y > Y && ev.y < Y+N+1)
		{
		check_mouse=1;
		mline=ev.y-Y-1;
		mpos=ev.x-X-2;
		} // end if.
	    else
		{
		check_mouse=0;
		link_under_mouse=0;
		} // end else.

	    left_was_pressed=ev.left;
	    if (ev.left == 0)
		bar_hooked=0;

	    if (bar_hooked)
		{
		if (ev.y <= BARY)
		    forced_barpos=0;
		else if (ev.y < BARY+BARLEN)
		    forced_barpos=ev.y-BARY;
		else
		    forced_barpos=BARLEN-1;

		} // end if.

	    } // end else.
        else if (num_backs == 0 && (ev.key==8 || ev.scan==0x9B00)) // Back.
	    {
            break;
	    } // end else.
	else if (ev.scan==0x47E0 || ev.scan==0x4700) // Home.
	    {
	    top=bs;
	    } // end else.
	else if (ev.scan==0x48E0 || ev.scan==0x4800) // Up.
	    {
	    if (top != bs)
		{
		seek_base=top;
		seek_cnt=-1;
		} // end if.

	    } // end else.
	else if (ev.scan==0x49E0 || ev.scan==0x4900) // PgUp.
	    {
	    if (top != bs)
		{
		seek_base=top;
		seek_cnt=1-N;
		} // end if.

	    } // end else.
	else if (ev.scan==0x4FE0 || ev.scan==0x4F00) // End.
	    {
	    if (bottom != bq)
		{
		seek_base=bq;
		seek_cnt=-N;
		} // end if.

	    } // end else.
	else if (ev.scan==0x50E0 || ev.scan==0x5000) // Down.
	    {
	    if (bottom != bq)
		{
		seek_base=top;
		seek_cnt=+1;
		} // end if.

	    } // end else.
	else if (ev.scan==0x51E0 || ev.scan==0x5100) // PgDn.
	    {
	    if (bottom != bq)
		{
		seek_base=top;
		seek_cnt=N-1;
		} // end if.

	    } // end else.

	} // end while.

    load_window(X,Y,W,H,buf);
    free(text_buf);
    free(buf);

} // end html_view.
