/****************************************************************/
/*                                                              */
/*                         cdplayer.c                           */
/*                                                              */
/*                Seal - free desktop environment               */
/*                                                              */
/*                    Copyright (c) 1999,2000                   */
/*                         Michal Stencl                        */
/*                     All Rights Reserved                      */
/*                                                              */
/* mail : stenclpmd@ba.telecom.sk                               */
/* web  : http://www.home.sk/public/seal/                       */
/*                                                              */
/* This file is part of Seal.                                   */
/*                                                              */
/* Seal is free software; you can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation; either version */
/* 2, or (at your option) any later version.                    */
/*                                                              */
/* Seal is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of   */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See    */
/* the GNU General Public License for more details.             */
/*                                                              */
/* You should have received a copy of the GNU General Public    */
/* License along with Seal; see the file COPYING.  If not,      */
/* write to the Free Software Foundation, 675 Mass Ave,         */
/* Cambridge, MA 02139, USA.                                    */
/*                                                              */
/****************************************************************/


#include"allegro.h"
#include"seal.h"
#include"menus.h"
#include"app.h"
#include"button.h"
#include"dialogs.h"
#include"load_htm.h"
#include"iodlg.h"
#include"bcd.h"

/* text infos */

#define TXT_ERRORINLOADINGAUDIO INI_TEXT("Error in loading audio")

/* messages */

#define MSG_PLAY              10001
#define MSG_PAUSE             10002
#define MSG_STOP              10003
#define MSG_RR                10004
#define MSG_FF                10005
#define MSG_OUT               10006
#define MSG_PREV              10007
#define MSG_NEXT              10008
#define MSG_RBACK             10009
#define MSG_PLAYATBACKGROUND  10010

l_int  cd_track = 1;
l_int  cd_track_max = 1;
l_int  cd_track_pause = 0;
l_int  cd_track_in_background = 0;
l_long cd_track_start = 0;


void  trackinfo_draw ( p_view o )
{

  t_rect  r = o->get_local_extent(o);
  t_point p;

  BITMAP *out = o->begin_paint(o, &p, r);

  if ( out ) {

    l_text about;

    about = set_format_text(NULL, "[song %i]", cd_track);

    o->background(o, out, rect_move(r, p.x, p.y));

    button(out, r.a.x+p.x, r.a.y+p.y, r.b.x+p.x, r.b.y+p.y,
                COLOR(CO_BLACK), COLOR(CO_WHITE));

    textout_draw_rect(out, o->font, about, -1, r.a.x+p.x+2, r.a.y+p.y+2,
                           r.b.x+p.x-2, r.b.y+p.y-2, TX_ALIGN_CENTER, COLOR(CO_WHITE), TX_NOCOLOR, 0);

    _free(about);

  };

  o->end_of_paint(o, r);

};


void  trackinfo_func_callback ( p_object s ) /* it's call each second */
{

    l_int p = bcd_now_playing();

    VIEW(s)->draw_view(VIEW(s));

    if ( p ) cd_track = p;

};


p_view  trackinfo_init ( p_view o, t_rect r )
{

   if ( !o ) return NULL;

   view_init(o, r);

   OBJECT(o)->process_tick = 1000; /* each second rewrite it */

   OBJECT(o)->func_callback = &trackinfo_func_callback;

   o->draw = &trackinfo_draw;
   o->font = get_font_in_size("ActiveCE", 16, 16);

   OBJECT(o)->set_options(OBJECT(o), OB_OF_SELECTABLE+OB_OF_ENABLE, false);
   OBJECT(o)->set_options(OBJECT(o), OB_OF_STILLPROCESS, true);

   VIEW(o)->brush.color = COLOR(CO_BLACK);

   return o;
};


static void bcd_play_to_end ( l_int track )
{
   l_int start;
   l_int len;
   l_int t = cd_track_max = bcd_get_audio_info();

   bcd_get_track_address(track, &start, &len);

   while ( t > track ) {

      l_int l;
      l_int s;

      bcd_get_track_address(t, &s, &l);

      len += l;

      t--;

   };

   bcd_play(start, len);
};


/* cd - player translate event function */

void  trans_ev ( p_object o, p_event event )
{

   if ( event->type == EV_MESSAGE ) {

       switch ( event->message ) {

           case MSG_PLAYATBACKGROUND : {

               clear_event(event);

               set_event(event, EV_MESSAGE, MSG_CLOSE, o);

               cd_track_in_background = 1;

               o->put_event(o, event);

               clear_event(event);

           }; break;

           case MSG_PLAY : {

               clear_event(event);

               if ( !cd_track_pause )

                     bcd_play_to_end(cd_track);

               else bcd_resume();

               cd_track_pause = 0;

           }; break;

           case MSG_PAUSE : {

               clear_event(event);

               bcd_pause();

               cd_track_pause = 1;

           }; break;

           case MSG_STOP : {

               clear_event(event);

               bcd_stop();

               cd_track_pause = 0;

           }; break;

           case MSG_RR : {

                 clear_event(event);

           }; break;

           case MSG_FF : {

                 clear_event(event);

           }; break;

           case MSG_OUT : {

               clear_event(event);

               if ( bcd_device_status() & BCD_DOOR_OPEN ) {

                     bcd_close_door();

                     cd_track_max = bcd_get_audio_info();

               } else

                     bcd_open_door();

               cd_track_pause = 0;
               cd_track = 1;


           }; break;

           case MSG_PREV : {

               clear_event(event);

               cd_track = min(cd_track_max, max(1, cd_track-1));

               bcd_play_to_end(cd_track);

               cd_track_pause = 0;

           }; break;

           case MSG_NEXT : {

               clear_event(event);

               cd_track = min(cd_track_max, max(1, cd_track+1));

               bcd_play_to_end(cd_track);

               cd_track_pause = 0;

           }; break;

           case MSG_RBACK : {

               clear_event(event);

               cd_track_in_background = 1;

           }; break;

       };

   };

};



p_object  get_button ( t_rect r, l_text str, l_dword msg, l_int flags ) {

   p_button  o = button_init(_malloc(sizeof(t_button)),
                             r,
                             str,
                             msg,
                             flags);

  if ( o )

       VIEW(o)->font = get_font_in_size("Symbols", 16, 16);


  return OBJECT(o);

};


void  init_cdplayer ( void )
{

   t_rect r = rect_assign(0, 0, 340, 100);
   t_rect t = r;

   p_appwin o = appwin_init(_malloc(sizeof(t_appwin)), /* make window */
                            r,
                            "CompactDisc - Player",
                            0x02,
                            ap_id, /* application id */
                            &trans_ev);

   VIEW(o)->align |= TX_ALIGN_CENTER; /* set alignment */


   OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(o)); /* insert it on the desktop */

   r = VIEW(o)->size_limits(VIEW(o));

   r = rect_assign(r.a.x+10, r.a.y+10, r.a.x+150, r.a.y+65);

   OBJECT(o)->insert(OBJECT(o), OBJECT(trackinfo_init(_malloc(sizeof(t_view)), r)));

   r = rect_assign(r.b.x+10, r.a.y, r.b.x+2, r.b.y);

   t = r;

   r = rect_assign(r.a.x, r.a.y, r.a.x+64, r.a.y+25); /* play button */

   OBJECT(o)->insert(OBJECT(o), get_button(r, "b", MSG_PLAY, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

   r = rect_assign(r.b.x+4, r.a.y, r.b.x+34, r.a.y+25); /* play at background button */

   OBJECT(o)->insert(OBJECT(o), get_button(r, "M", MSG_PLAYATBACKGROUND, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

   r = rect_assign(r.b.x+4, r.a.y, r.b.x+34, r.b.y); /* pause button */
   OBJECT(o)->insert(OBJECT(o), get_button(r, "a", MSG_PAUSE, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

   r = rect_assign(r.b.x+4, r.a.y, r.b.x+34, r.b.y); /* stop button */
   OBJECT(o)->insert(OBJECT(o), get_button(r, "W", MSG_STOP, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

   r = rect_assign(t.a.x, r.b.y+5, t.a.x+30, r.b.y+30); /* |<< button */
   OBJECT(o)->insert(OBJECT(o), get_button(r, "Z", MSG_PREV, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

   r = rect_assign(r.b.x+4, r.a.y, r.b.x+34, r.b.y); /* << button */
   OBJECT(o)->insert(OBJECT(o), get_button(r, "X", MSG_RR, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

   r = rect_assign(r.b.x+4, r.a.y, r.b.x+34, r.b.y); /* >> button */
   OBJECT(o)->insert(OBJECT(o), get_button(r, "Y", MSG_FF, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

   r = rect_assign(r.b.x+4, r.a.y, r.b.x+34, r.b.y); /* >>| button */
   OBJECT(o)->insert(OBJECT(o), get_button(r, "c", MSG_NEXT, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

   r = rect_assign(r.b.x+4, r.a.y, r.b.x+34, r.b.y); /* /\ button */
   OBJECT(o)->insert(OBJECT(o), get_button(r, "d", MSG_OUT, BF_NORMAL)); /* insert button to window ...see get_button function under this function */

};


static l_int get_track ( l_text args )
{
  if ( args ) {

     l_text x = args;
     l_text s;
     l_int  i = 0;

     while ( *x && *x < '0' || *x > '9' ) x++;
     args = x;
     while ( *x && *x >= '0' && *x <= '9' ) x++;

     s = stridup(args, strsize(args, x));

     if ( s ) i = atol(s);

     _free(s);

     return i;

  };

  return 0;
};


app_begin ( void ) {


  if ( ap_process == AP_INIT ) {

    l_int err = 0;
    l_int i   = 0;

    AP_SETNUMOFCALLS(1); /* set max num of calls */

    bcd_open();

    err = bcd_audio_busy();

    if ( !err ) { /* audio is not play, ok ! */

       bcd_reset();

    } else if ( err == -1 ) /* audio error */

         seal_error(ERR_INFO, "%s !", TXT_ERRORINLOADINGAUDIO);

    else /* audio is play now */

      cd_track = bcd_now_playing();

    cd_track_max = bcd_get_audio_info();

    init_cdplayer();

    i = get_track(ap_args);

    if ( i > 0 ) {

         cd_track = min(cd_track_max, max(1, i));

         bcd_play_to_end(cd_track);

    };

  };

  if ( ap_process == AP_FREE ) {

     if ( !cd_track_in_background ) {

         bcd_stop();

         bcd_close();

     };

  };

} app_end;

