# MSDOS DMAKE startup file.  Customize to suit your needs.
# Assumes MKS toolkit for the tool commands, and Turbo-C.  Change as req'd.
# See the documentation for a description of internally defined macros.
#
# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT !:= $(.SILENT)
.SILENT   !:= yes

# Configuration parameters for DMAKE startup.mk file
# Set these to NON-NULL if you wish to turn the parameter on.
_HAVE_RCS	:= yes		# yes => RCS  is installed.
_HAVE_SCCS	:= 		# yes => SCCS is installed.

# Applicable suffix definitions
A := .lib	# Libraries
E := .exe	# Executables
C := .com	# Plain executables 
F := .for	# Fortran
O := .obj	# Objects
P := .pas	# Pascal
S := .asm	# Assembler sources
V := 		# RCS suffix

# See if these are defined
#
# TMPDIR, TEMP,& TMP to determine the temporary directory
# SHELL,& COMSPEC to determine the current shell
# USEMC to differ Micro-C from standard-C usage
# NDEBUG to disable debugging
# MODEL as the default model (if Micro-C is used, defaults to y)
#
.IMPORT .IGNORE : TMPDIR SHELL COMSPEC TEMP TMP NDEBUG MODEL COMPILER

# default compiler is Micro-C
_COMPILER = $(null,$(COMPILER) MC $(COMPILER:u))
# Compiler type (Compiler without numbers and dots)
_COMPTYPE = $(_COMPILER:s/0//:s/1//:s/2//:s/3//:s/4//:s/5//:s/6//:s/7//:s/8//:s/9//:s/.//:)

.IF $(_COMPTYPE) == MC					# Micro-C has only Small/Tiny
_MODEL := $(eq,$(MODEL),t t s)
.ELSE
_MODEL := $(null,$(MODEL) s $(MODEL:l))		# default model is small
.ENDIF

# source in different types of "temporary directory" variables
# the result is $(TMPDIR)
.IF $(TMPDIR) != $(NULL)
.ELIF $(TEMP) != $(NULL)
TMPDIR := $(TEMP)
.ELIF $(TMP) != $(NULL)
TMPDIR := $(TMP)
.ELSE
TMPDIR := $(ROOTDIR)/tmp
.ENDIF

# Recipe execution configurations
# First set SHELL, If it is not defined, use COMSPEC, otherwise
# it is assumed to be MKS Korn SHELL.
.IF $(SHELL) == $(NULL)
.IF $(COMSPEC) == $(NULL)
   SHELL := $(ROOTDIR)/bin/sh$E
.ELSE
   SHELL := $(COMSPEC)
.END
.END
GROUPSHELL := $(SHELL)

# Now set remaining arguments depending on which SHELL we
# are going to use.  COMSPEC (assumed to be command.com) or
# MKS Korn Shell.
.IF $(SHELL)==$(COMSPEC)
   SHELLFLAGS  := $(SWITCHAR)c
   GROUPFLAGS  := $(SHELLFLAGS)
   SHELLMETAS  := *"?<>
   GROUPSUFFIX := .bat
   DIRSEPSTR   := \\\
   DIVFILE      = $(TMPFILE:s,/,\)
   GROUPPROLOG := @ECHO OFF
   GROUPEPILOG := :ende
.ELSE
   SHELLFLAGS  := -c
   GROUPFLAGS  := 
   SHELLMETAS  := *"?<>|()&][$$\#`'
   GROUPSUFFIX := .ksh
   .MKSARGS    := yes
   DIVFILE      = $(TMPFILE:s,/,${DIVSEP_shell_${USESHELL}})
   DIVSEP_shell_yes := \\\
   DIVSEP_shell_no  := \\
.END

#
# Standard C-language command names and flags
#

# Propagate the common macros to compiler specific macros
#	Each macro (*) is defined that it can be qualified by three strings
#	depending on $(_COMPILER).
#	1) If $(*_$(_COMPILER)) is not $(NULL), this definition is used.
#	2) Otherwise, if $(*_$(_COMPTYPE)) is not $(NULL), this definition is used.
#	3) Otherwise, a default definition will be used.
#	The idea behind this way it that some macros will never vary through
#	different compilers, e.g. the librarian, [that's class 3)], that some
#	macros will not	vary through different version of the same compiler,
#	e.g. the name of the configuration file, [that's class 2)], and that
#	other macros are unique to one particular compiler [class 1)].
#
#	All common macros are defined in the form:
#		* = $(*_$(_COMPILER):?$(CC_(_COMPTYPE)):?...)
#	This asures that, if the class 1) definition exists, it is used;
#	if not, class 2) definition is used; and if the one does also not
#	exist, the class 3) definition "..." is used.
#	For each compiler can be defined the special macros overwrite the
#	all purpose class 3) definition.

#		The C compiler itself
	CC		= $(CC_$(_COMPILER):?$(CC_$(_COMPTYPE)):?$(FDBIN)\NoComp)
	# Include directories
	INCDIR		= $(INCDIR_$(_COMPILER):?$(INCDIR_$(_COMPTYPE)):?$(FDINC))
	# Library search directories
	LIBDIR		= $(LIBDIR_$(_COMPILER):?$(LIBDIR_$(_COMPTYPE)):?$(FDLIB))
	# Compiling .C files _DBG with debug information; _NDBG without
	CFLAGS		= $(CFLAGS_$(null,$(NDEBUG) DBG NDBG)) $(MYCFLAGS)
	CFLAGS_DBG		= $(CFLAGS_DBG_$(_COMPILER):?$(CFLAGS_DBG_$(_COMPTYPE)))
	CFLAGS_NDBG		= $(CFLAGS_NDBG_$(_COMPILER):?$(CFLAGS_NDBG_$(_COMPTYPE)))
	# C Compiler configuration file
	CFG		= $(CFG_$(_COMPILER):?$(CFG_$(_COMPTYPE)))
	# C Compiler debug flags
	DBG		= $(DBG_$(_COMPILER):?$(DBG_$(_COMPTYPE)))

	# Assembler and flags
	AS		= $(AS_$(_COMPILER):?$(AS_$(_COMPTYPE)):?$(AS_TASM))
	ASFLAGS		= $(ASFLAGS_$(_COMPILER):?$(ASFLAGS_$(_COMPTYPE)):?$(ASFLAGS_TASM))

	# Loader and flags
	LD		= $(LD_$(_COMPILER):?$(LD_$(_COMPTYPE)):?$(LD_TLINK))
	LDFLAGS		= $(LDFLAGS_$(_COMPILER):?$(LDFLAGS_$(_COMPTYPE)):?$(LDFLAGS_TLINK))
	# Loader flags when invoked via $(CC)
	CCLDFLAGS		= $(CCLDFLAGS_$(_COMPILER):?$(CCLDFLAGS_$(_COMPTYPE)))
	# additional Loader libraries
	# If MYLDLIBS is not defined, use compiler depend libraries.
	LDLIBS		= $(MYLDLIBS:?$(LDLIBS_$(_COMPILER)):?$(LDLIBS_$(_COMPTYPE)):?$(FDLIB)\$(_MODEL:u)_$(LNG).lib $(FDLIB)\Suppl_$(_MODEL).lib)
	# Loader flag to generate .COM files
	LDCOMFLAG		= $(LDCOMFLAG_$(_COMPILER):?$(LDCOMFLAG_$(_COMPTYPE)):?$(LDCOMFLAG_TLINK))
	# Standard OBJ files (the first ones)
	STD_OBJ		= $(STD_OBJ_$(_COMPILER):?$(STD_OBJ_$(_COMPTYPE)))
	# Standard LIB files (the last ones)
	STD_LIB		= $(STD_LIB_$(_COMPILER):?$(STD_LIB_$(_COMPTYPE)))


    # Librarian
	AR		= $(AR_$(_COMPILER):?$(AR_$(_COMPTYPE)):?LIB$E)
    # Librarian flags (case-sensitive)
	ARFLAGS		= $(ARFLAGS_$(_COMPILER):?$(ARFLAGS_$(_COMPTYPE)):?/SCW)

# Common macros for general utilities
	AS_TASM		= tasm
	ASFLAGS_TASM	= /ml $(!null,$(NDEBUG) /DNDEBUG)

	LD_TLINK	= tlink
	LDFLAGS_TLINK	= /c $(null,$(NDEBUG) /v)
	LDCOMFLAG_TLINK	= /Tdc

	LD_VAL		= $(MCDIR)\VAL$E
    LDFLAGS_VAL	= /NCI
	LDCOMFLAG_VAL	= /COM

# Class 2) macros for Borland C/C++
	BASEDIR_BC	= $(BASEDIR_$(_COMPILER))
	INCDIR_BC	= $(BASEDIR_BC)\INCLUDE;L:\$(_COMPILER)\INCLUDE
	LIBDIR_BC	= $(BASEDIR_BC)\LIB;L:\$(_COMPILER)\LIB
	CC_BC		= $(BASEDIR_BC)\BIN\BCC$E +$(CFG)
	CFG_BC		:= BccDos.Cfg
	CFLAGS_NDBG_BC		:= -DNDEBUG=1 -O2 -O -Ol -Z -Obeimpv
	CFLAGS_NBG_BC		:= -v -y -vi
	AS_BC		= $(AS_TASM)			# Assembler and flags
	ASFLAGS_BC	= $(ASFLAGS_TASM)
	LD_BC		= $(LD_TLINK)		# Loader and flags
	LDFLAGS_BC	= $(LDFLAGS_TLINK)		# case-sensitve
	CCLDFLAGS_BC	= $(CCLDFLAGS_BC_TLINK) $(CFLAGS)
	LDCOMFLAG_BC	= $(LDCOMFLAG_TLINK)
	STD_OBJ_BC	= C0$(_MODEL)$O
	STD_LIB_BC	= C$(_MODEL)$A

# Class 1) macros for Borland C/C++ v5.0
	BASEDIR_BC5	:= c:\BC5
	CFLAGS_NDBG_BC5	:= -DNDEBUG=1 -O2 -O -Ol -Z -Obeimpv -RT-
	CFLAGS_DBG_BC5		:= -v -y -vi -RT-
	STD_LIB_BC5	= NOEH$(_MODEL)$A C$(_MODEL)$A

# Class 1) macros for Borland C/C++ v4.52
	BASEDIR_BC45	:= c:\BC45
	BASEDIR_BC452	:= c:\BC45
	CFLAGS_NDBG_BC45	:= -DNDEBUG=1 -O2 -O -Ol -Z -Obeimpv -RT-
    CFLAGS_NDBG_BC452	= $(CFLAGS_NDBG_BC45)
	CFLAGS_DBG_BC45		:= -v -y -vi -RT-
    CFLAGS_DBG_BC452	= $(CFLAGS_DBG_BC45)
	STD_LIB_BC45	= NOEH$(_MODEL)$A C$(_MODEL)$A
    STD_LIB_BC452	= $(STD_LIB_BC45)

# Class 1) macros for Borland C/C++ v4.0
	BASEDIR_BC40	:= c:\BC40
	CFLAGS_NDBG_BC40	:= -DNDEBUG=1 -O2 -O -Ol -Z -Obeimpv -RT-
	CFLAGS_NBG_BC40	:= -v -y -vi -RT-
	STD_LIB_BC40	= NOEH$(_MODEL)$A C$(_MODEL)$A

# Class 1) macros for Borland C/C++ v3.1
	BASEDIR_BC31	:= c:\BC31

# Class 1) macros for Borland C/C++ v2.0
	BASEDIR_BC2	:= c:\BC2
	CFLAGS_NDBG_BC2		:= -DNDEBUG=1 -O2 -O -Z


# Class 2) Macros for Micro-C

# Source in the Micro-C directory
.IF $(MCDIR) == $(NULL)
.IMPORT .IGNORE : MCDIR
.IF $(MCDIR) == $(NULL)
MCDIR = c:\mc
.ENDIF
.ENDIF

	CC_MC		= $(MCDIR)\CC$(null,$(NDEBUG) 1)$C
	# _MICROC_= to define it regardless, if <stdio.h> was included
	# h= to ensure the correct path
	# t= to allow VI to determine the temporary files
	# e= to redirect the errors to
	CFLAGS_NDBG_MC	= -flpo NDEBUG=1 _MICROC_=1 h=$(MCDIR) t=q e=errlist
	CFLAGS_DBG_MC	= -flpck _MICROC_=1 h=$(MCDIR) t=q e=errlist

	CFG_MC		:=		# no configuration file

	AS_MC		= $(MCDIR)\ASM$E
	ASFLAGS_MC	= $(ASFLAGS_TASM)

# For debugging: Use Turbo Debugger --> Need TLink, too
	LD_MC		= $(LD_$(null,$(NDEBUG) TLINK VAL))
    LDFLAGS_MC	= $(LDFLAGS_$(null,$(NDEBUG) TLINK VAL))
	LDCOMFLAG_MC	= $(LDCOMFLAG_$(null,$(NDEBUG) TLINK VAL))
	STD_LIB_MC		= $(MCDIR)\Mclib.lib
	STD_OBJ_MC	= $(MCDIR)\Pc86rl_$(_MODEL).OBJ


#
# Definition of $(MAKE) macro for recursive makes.
#
   MAKE = $(MAKECMD) -S $(MFLAGS)

# Language and Parser generation Tools and their flags
   YACC	  := byacc		# standard yacc
   YFLAGS +=
   YTAB	  := ytab		# yacc output files name stem.

   LEX	  := flex		# standard lex
   LFLAGS +=
   LEXYY  := lex_yy		# lex output file

# Other Compilers, Tools and their flags
   PC	:= tpc			# pascal compiler
   RC	:= anyf77		# ratfor compiler
   FC	:= anyf77		# fortran compiler

   CO	   := co		# check out for RCS
   COFLAGS += -q

   RM	   := rm		# remove a file command
   RMFLAGS += -sf		# a dash instead of a slash, for compatibly purpose 

# Implicit generation rules for making inferences.
# We don't provide .yr or .ye rules here.  They're obsolete.
# Rules for making *$O
.IF $(_COMPILER) != MC
   %$O .SWAP .DELAYED: %.c ; $(CC) $(CFLAGS) -c @$(mktmp $(<:t"\n")\n) >>errlist
.ELSE
   %$O : %.c ; $(CC) $< $(CFLAGS)
.ENDIF
   %$O .SWAP: %$S ; $(AS) $(ASFLAGS) $(<:s,/,\);
   %$O .SWAP: %$P ; $(PC) $(PFLAGS) -c $<
   %$O : %.cl ; class -c $<
   %$O .SWAP:| %.e %.r %.F %$F ; $(FC) $(RFLAGS) $(EFLAGS) $(FFLAGS) -c $<

# Executables
.IF $(_COMPILER) == BC40
# The quirk of Borland v4.0 needs to be faked by explizitly ct.lib
   %$C .SWAP: %$O ; $(CC) $(CCLDFLAGS) -lTdc -e$@ @$(mktmp $< $(LDLIBS) noeht.lib ct.lib\n)
   %$E .SWAP: %$O ; $(CC) $(CCLDFLAGS) -e$@ @$(mktmp $< $(LDLIBS)\n)
.ELSE
   %$E .SWAP: %$O ; $(LD) $(LDFLAGS) $(STD_OBJ) @$(mktmp $(strip $<)\n),$@,NUL,@$(mktmp $(strip $(LDLIBS) $(STD_LIB))\n);
   %$C .SWAP: %$O ; $(LD) $(LDFLAGS) $(LDCOMFLAG) $(STD_OBJ) @$(mktmp $(strip $<)\n),$@,NUL,@$(mktmp $(strip $(LDLIBS) $(STD_LIB))\n);
.ENDIF

# lex and yacc rules
   %.c .SWAP: %.y ; $(YACC)  $(YFLAGS) $<; mv $(YTAB).c $@
   %.c .SWAP: %.l ; $(LEX)   $(LFLAGS) $<; mv $(LEXYY).c $@

# RCS support
.IF $(_HAVE_RCS)
   % : $$(@:d)RCS/$$(@:f)$V;- $(CO) $(COFLAGS) $@
   .NOINFER : $$(@:d)RCS/$$(@:f)$V
.END

# SCCS support
.IF $(_HAVE_SCCS)
   % : s.% ; get $<
   .NOINFER : s.%
.END

# Recipe to make archive files.
%$A .SWAP .GROUP :
#	$(AR) $(ARFLAGS) $@ $?
	$(AR) $@ $(ARFLAGS) @$(mktmp +- $(?:t" \\\n+- ")\n), $*.lst
	$(RM) $(RMFLAGS) /l=1 1$(mktmp $?\n)

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) $(SWITCHAR)fr $<

# AUGMAKE extensions for SYSV compatibility
"@B" = $(@:b)
"@D" = $(@:d)
"@F" = $(@:f)
"*B" = $(*:b)
"*D" = $(*:d)
"*F" = $(*:f)
"<B" = $(<:b)
"<D" = $(<:d)
"<F" = $(<:f)
"?B" = $(?:b)
"?F" = $(?:f)
"?D" = $(?:d)

# Turn warnings back to previous setting.
.SILENT !:= $(__.SILENT)

# Local init file if any, gets parsed before user makefile
.INCLUDE .IGNORE: "_startup.mk"
