/*
 *  VOL.C - vol internal command
 *
 *  Comments:
 *
 * 09/13/1998 (John P. Price)
 * - started.  Based on code from FreeDOS command.com.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>

int currentdrive;

int dir_print_header(int drive)
{
  struct media_id
  {
    int info_level;
    int serial1;
    int serial2;
    char vol_id[11];
    char file_sys[8];
  }
  media;
  struct ffblk f;
  struct SREGS s;
  union REGS r;

  /* change to the drive */
  setdisk(drive);
  if (getdisk() != drive)
  {
    fprintf(stderr,"Invalid drive specification.\n");
    return 1;
  }

  /* get the media ID of the drive */
  media.info_level = 0;
  r.x.bx = drive + 'A' - '@';
  r.x.cx = 0x866;
  s.ds = FP_SEG(&media);
  r.x.dx = FP_OFF(&media);
  r.x.ax = 0x440d;
  int86x(0x21, &r, &r, &s);
  media.vol_id[10] = NULL;

  /* print drive info */
  printf("\n Volume in drive %c", drive + 'A');

  if (findfirst("\\*.*", &f, FA_LABEL) == 0)
  {
    printf(" is %s\n", f.ff_name);
  }
  else
  {
    printf(" has no label\n");
  }

  /* print the volume serial number if the return was successful */
  if (!r.x.cflag)
  {
    printf(" Volume Serial Number is %04X-%04X\n", media.serial2, media.serial1);
  }
  return 0;
}



void main(int argc, char **argv)
{
  char d;

  currentdrive = getdisk();

  if (argc == 2)
  {
    if ((strlen(argv[1]) == 2) && (argv[1][1] == ':'))
    {
      d = toupper(argv[1][0]) - 'A';
      dir_print_header(d);
      setdisk(currentdrive);
    }
    else if (strcmp(argv[1],"/?") == 0)
    {
      puts("Displays the disk volume label and serial number, if they exist.\n"
           "\n"
           "VOL [drive:]\n");
    }
    else
    {
      fprintf(stderr,"Invalid parameter - %s\n",argv[1]);
    }
  }
  else if (argc > 2)
    fprintf(stderr,"Too many parameters.\n");
  else
    dir_print_header(currentdrive);
}

