/*  Scandisk

    Copyright (c) Joe Cosentino 2000.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

#define SCANDISK

// I N C L U D E S //////////////////////////////////////////////////////////

#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "keyboard\keyboard.h"
#include "mouse\mouse.h"
#include "event\event.h"
#include "screen\screen.h"
#include "dialog\dialog.h"
#include "dialog\exit.h"
#include "dialog\hlpdialg.h"
#include "winman\winman.h"
#include "winman\window.h"
#include "winman\control.h"
#include "winman\vscrctrl.h"
#include "helpsys\hlpfncs.h"
#include "scandisk.h"
#include "keepdos.h"

// G L O B A L S ////////////////////////////////////////////////////////////

char logs[10000], filename[256], path[256];
unsigned char sector_buffer[512];
int paused=0, custom_flag=0, do_logfile=0, repair=1;

typedef struct
{
    int monochrome;                     // Environment settings.
    int mouse;
    int screen_color;
    int no_screen;
    int timeout;
    int labelcheck;
    int spacecheck;

    int drivesum;                       // Custom settings.
    int allsum;
    int surface;
    int append;
    int overwrite;

} Flags;

Flags flags;

// P R O T O T Y P E S //////////////////////////////////////////////////////

void logit(char *);
int classify_args(int, char *[], char *[], char *[]);
int GetCurrentTime(void);
static void OnExit();
static int OnCBreak();
void get_descriptor(int, int);
void main_routine(void);
void pause(void);
void read_ini(void);
int label(int, char []);

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
	{
	argptr = rawargs[index];
	if (*argptr == '/')
	    {
	    argptr++;
	    optargs[kndex++] = argptr;
	    } // end if.
	else
	    {
	    fileargs[jndex++] = argptr;
	    } // end else.

	} // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

int GetCurrentTime(void)
{
    time_t t;

    t = time(NULL);
    return t;

} // end GetCurrentTime.

/////////////////////////////////////////////////////////////////////////////

void logit(char *text)
{
    static FILE *log=NULL;
    struct dostime_t time;
    struct dosdate_t date;
    char ampm;
    int oldtime;

    if (flags.overwrite==TRUE)
        {
        // If there is already a LOG file, delete it.
        if (remove("SCANDISK.LOG"))
            printf("\r");
        else
            printf("\r");

        } // end if.

    // Open log-file.
    if (!log)
	{
        log=fopen("SCANDISK.LOG","a+t");
	_dos_gettime(&time);
	_dos_getdate(&date);
	if (time.hour > 12)
	    {
	    ampm = 'pm';
	    time.hour -= 12;
	    } // end if.
	else
	    {
	    ampm = 'am';
	    if (time.hour == 0)
		time.hour += 12;

	    } // end else.

	if (log)
	    {
	    fprintf(log,"*******************\n\nFree ScanDisk\n\nLog file generated at %2d:%02d%c on %d/%d/%d.\n\n", time.hour, time.minute, ampm, date.month, date.day, date.year);
	    oldtime=GetCurrentTime();
	    } // end if.

	} // end if.

    if (log)
	{
	_dos_gettime(&time);
	_dos_getdate(&date);
	if (time.hour > 12)
	    {
	    ampm = 'pm';
	    time.hour -= 12;
	    } // end if.
	else
	    {
	    ampm = 'am';
	    if (time.hour == 0)
		time.hour += 12;

	    } // end else.

        if (GetCurrentTime()-oldtime>10000)
            {
            fprintf(log,"-------------------\n\nFree ScanDisk\n\nLog file generated at %2d:%02d%c on %d/%d/%d.\n\n", time.hour, time.minute, ampm, date.month, date.day, date.year);
	    oldtime=GetCurrentTime();
            } // end if.

	if (text)
	    {
	    if (strncmp(text,"**",2))
		fprintf(log,"");

	    while (*text!='\0')
		{
		fputc(*text,log);
		if (*text=='\n' && *(text+1)!='\0')
		    fprintf(log,"  ");

		text++;
		} // end while.

	    } // end if.
	else
	    {
	    fprintf(log,"Closing installation log.");
	    fflush(log);
	    fclose(log);
	    } // end else.

	} // end if.

    if (log)
	fflush(log);

} // end logit.

/////////////////////////////////////////////////////////////////////////////

void pause(void)
{
    _asm{
        mov ah,7
        int 0x21
        } // end asm.

} // end pause.

/////////////////////////////////////////////////////////////////////////////

void read_ini(void)
{
    char command_buffer[20], home_path[255], line_buffer[256], setting_buffer[20];
    int index=0, command_ok=FALSE, done_looking=FALSE, end_of_file_marker_encountered=FALSE, object_found=FALSE, sub_buffer_index=0;
    long line_counter=1;
    FILE *file;

    strcpy(home_path,path);
    strcat(home_path,"SCANDISK.INI");

    // Search the directory ScanDisk resides in before searching the PATH
    // in the environment for the SCANDISK.INI file.
    file=fopen(home_path,"rt");
    if (!file)
	file=fopen(searchpath("SCANDISK.INI"),"rt");

    if (file)
	{
	while (fgets(line_buffer,255,file) !=NULL)
	    {
	    if ( (0!=strncmp(line_buffer,"[",1)) && (0!=strncmp(line_buffer,";",1)) && (0!=strncmp(line_buffer,"end.",3)) && (end_of_file_marker_encountered==FALSE))
		{
		// Clear the command_buffer and setting_buffer.
		index=0;
		do
		    {
		    command_buffer[index]=0x00;
		    setting_buffer[index]=0x00;
		    index++;
		    } // end do.
		while (index<20);
		// Extract the command and setting from the line_buffer.

		// Find the command.
		index=0;
		sub_buffer_index=0;
		done_looking=FALSE;
		object_found=FALSE;
		do
		    {
		    if ((line_buffer[index]!='=') && ((line_buffer[index]>=0x30) && (line_buffer[index]<=0x7a)))
			{
			object_found=TRUE;
			command_buffer[sub_buffer_index]=line_buffer[index];
			sub_buffer_index++;
			} // end if.

		    if ((object_found==TRUE) && ((line_buffer[index]=='=') || (line_buffer[index]==' ')))
			{
//   command_buffer[sub_buffer_index]=0x0a;
			done_looking=TRUE;
			} // end if.

		    if ((index==254) || (line_buffer[index]==0x0a))
			{
			printf("Error encountered on line %d of the \"SCANDISK.INI\" file...Program Terminated.\n",line_counter);
			exit(3);
			} // end if.

		    index++;
		    } // end do.
		
		while (done_looking==FALSE);

		// Find the setting.
		sub_buffer_index=0;
		object_found=FALSE;
		done_looking=FALSE;
		do
		    {
		    if ((line_buffer[index]!='=') && (((line_buffer[index]>=0x30) && (line_buffer[index]<=0x7a)) || (line_buffer[index]=='-')))
			{
			object_found=TRUE;
			setting_buffer[sub_buffer_index]=line_buffer[index];
			sub_buffer_index++;
			} // end if.

		    if ((object_found==TRUE) && ((line_buffer[index]==0x0a) || (line_buffer[index]==' ')))
			{
			done_looking=TRUE;
			//   setting_buffer[sub_buffer_index]=0x0a;
			} // end if.

		    if (index==254)
			{
			printf("Error encountered on line %d of the \"SCANDISK.INI\" file...Program Terminated.\n",line_counter);
			exit(3);
			} // end if.

		    index++;
		    } // end do.
		while (done_looking==FALSE);

		// Adjust for the possibility of TRUE or FALSE in the SCANDISK.INI file.
		if (0==stricmp(setting_buffer,"TRUE")) strcpy(setting_buffer,"ON");
		if (0==stricmp(setting_buffer,"FALSE")) strcpy(setting_buffer,"OFF");

		// Process the command found in the line buffer.
		command_ok=FALSE;

		// Check for the DISPLAY statement.
		if (0==stricmp(command_buffer,"DISPLAY"))
		    {
                    if (stricmp(setting_buffer,"MONO")==0) flags.monochrome=TRUE;
                    if (stricmp(setting_buffer,"COLOR")==0) flags.screen_color=TRUE;
                    if (stricmp(setting_buffer,"OFF")==0) flags.no_screen=TRUE;
		    command_ok=TRUE;
		    } // end if.

		// Check for the MOUSE statement.
		if (0==stricmp(command_buffer,"MOUSE"))
		    {
                    if (stricmp(setting_buffer,"ON")==0) flags.mouse=TRUE;
                    if (stricmp(setting_buffer,"OFF")==0) flags.mouse=FALSE;
		    command_ok=TRUE;
		    } // end if.

		// Check for the SCANTIMEOUT statement.
		if (0==stricmp(command_buffer,"SCANTIMEOUT"))
		    {
		    command_ok=TRUE;
		    } // end if.

		// Check for the LABELCHECK statement.
		if (0==stricmp(command_buffer,"LABELCHECK"))
		    {
                    if (stricmp(setting_buffer,"ON")==0) flags.labelcheck=TRUE;
                    if (stricmp(setting_buffer,"OFF")==0) flags.labelcheck=FALSE;
		    command_ok=TRUE;
		    } // end if.

		// Check for the SPACECHECK statement.
		if (0==stricmp(command_buffer,"SPACECHECK"))
		    {
		    command_ok=TRUE;
		    } // end if.

		// Check for the DRIVESUMMARY statement.
		if (0==stricmp(command_buffer,"DRIVESUMMARY"))
		    {
		    command_ok=TRUE;
		    } // end if.

		// Check for the ALLSUMMARY statement.
		if (0==stricmp(command_buffer,"ALLSUMMARY"))
		    {
		    command_ok=TRUE;
		    } // end if.

		// Check for the SURFACE statement.
		if (0==stricmp(command_buffer,"SURFACE"))
		    {
		    command_ok=TRUE;
		    } // end if.

		// Check for the SAVELOG statement.
                if (stricmp(command_buffer,"SAVELOG")==0)
		    {
                    if (stricmp(setting_buffer,"APPEND")==0)
                        {
                        flags.append=TRUE;
                        do_logfile=1;
                        } // end if.

                    if (stricmp(setting_buffer,"OVERWRITE")==0)
                        {
                        flags.overwrite=TRUE;
                        do_logfile=1;
                        } // end if.

                    if (stricmp(setting_buffer,"OFF")==0) do_logfile=0;
		    command_ok=TRUE;
		    } // end if.

		if (command_ok==FALSE)
		    {
		    printf("Error encountered on line %d of the \"SCANDISK.INI\" file...Program Terminated.\n",line_counter);
		    exit(3);
		    } // end if.

		} // end if.

	    if (0==strncmp(line_buffer,"end.",3))
		end_of_file_marker_encountered=TRUE;

	    line_counter++;
	    } // end while.

	fclose(file);
	} // end if.

} // end read_ini.

/////////////////////////////////////////////////////////////////////////////

static void OnExit()
{
    CloseMouse();                       // Reinitialize mouse driver.
    if (flags.no_screen==FALSE)
        DOSWipeScreen();

    RestoreDOSState();
//    SetTimerOff();

} // end OnExit.

/////////////////////////////////////////////////////////////////////////////

static int OnCBreak()
{
    return 1;

} // end OnCBreak.

/////////////////////////////////////////////////////////////////////////////

int drvNum(int drive)
{
    if (drive == 0)
        return getdisk();

    if (drive <= 32)
        return drive - 1;

    return toupper(drive) - 'A';

} // end drvNum.

/////////////////////////////////////////////////////////////////////////////

int changeDrive(int drive)
{
    drive = drvNum(drive);
    setdisk(drive);
    if (getdisk() == drive) 
    	return 0;

    printf("%d: is an invalid drive\n", drive+'A');
    return 1;

} // end changeDrive.

/////////////////////////////////////////////////////////////////////////////

void get_descriptor(int drive, int interactive)
{
#pragma -a-
    struct media_id {
	int info_level;
	int serial1;
	int serial2;
	char vol_id[11];
	char file_sys[8];
	} media;

#pragma -a.
    struct ffblk f;
    struct SREGS s;
    union REGS r;
    int currDisk;
    char *invalid = "*?/\|.,;:+=[]()&^<>\"", *ptr;

    if (interactive)
        {
        if (flags.monochrome==TRUE)
            DrawText(13, 8, "", WHITE, BLACK); // Checking.
        else
            DrawText(13, 8, "", WHITE, BLUE);  // Checking.

        } // end if.
    else
        {
        printf("Checking media descriptor.......");
        } // end else.

    // Change to the drive.
    currDisk = getdisk();
    if (changeDrive(drive+1) != 0)
        {
        setdisk(currDisk);
        } // end if.

    // Get the media ID of the drive.
    r.x.ax = 0x6900;
    r.x.bx = drive + 1;
    s.ds = FP_SEG(&media);
    r.x.dx = FP_OFF(&media);
    int86x(0x21, &r, &r, &s);
    if (flags.labelcheck == TRUE)       // If they want a label check.
        {
        if (findfirst("\\*.*", &f, FA_LABEL) == 0)
            {
            // Added to remove "." from labels which are longer than 8 characters (as DOS does).
            char *dotptr = strchr(f.ff_name, '.');
            if (dotptr != NULL)
                if (strlen(dotptr + 1))
                    memmove(dotptr, dotptr + 1, strlen(dotptr));
            else
                *dotptr = '\0';

            } // end if.

        ptr = strpbrk(f.ff_name, invalid);
        if (ptr)                        // Invalid character.
            {
            if (do_logfile)
                {
                sprintf(logs,"Media descriptor\n   The volume label contained invalid characters.\n");
                logit(logs);
                } // end if.

            if (repair)
                {
                if (label(drive, "SCANDISK") == 0)
                    {
                    if (do_logfile)
                        {
                        sprintf(logs,"     ScanDisk successfully fixed the volume label.\n\n");
                        logit(logs);
                        goto endl;
                        } // end if.

                    } // end if.
                else
                    {
                    if (do_logfile)
                        {
                        sprintf(logs,"     ScanDisk did not repair the error.\n\n");
                        logit(logs);
                        goto endl;
                        } // end if.

                    } // end else.

                } // end if.
            else
                {
                if (do_logfile)
                    {
                    sprintf(logs,"     ScanDisk did not repair the error.\n\n");
                    logit(logs);
                    goto endl;
                    } // end if.

                } // end else.

            } // end if.

        } // end if.

    if (do_logfile)
        {
        sprintf(logs,"Media descriptor\n   ScanDisk did not find any problems.\n\n");
        logit(logs);
        } // end if.
endl:
    setdisk(currDisk);
    if (interactive)
        {
        if (flags.monochrome==TRUE)
            DrawText(13, 8, "", LIGHTGRAY, BLACK); // Done.
        else
            DrawText(13, 8, "", WHITE, BLUE);  // Done.

        } // end if.
    else
        {
        printf("Done.\n");
        } // end else.

} // end get_descriptor.

/////////////////////////////////////////////////////////////////////////////

void main_routine(void)
{
    int leave=0, event;

    while (!leave)
	{
	while ((event = GetEvent()) == 0);
	switch (event)
	    {
	    case ESCAPEKEY:
            case 'X':
            case 'x':
                if (show_exit() == TRUE)
                    leave=1;
                else
                    leave=0;
//                show_exit();
//                leave=1;
		break;

            case 'M':
            case 'm':
                ShowHelpSystem();
                break;

            case 'P':
            case 'p':
                paused=1;
                DrawText(5, 24, "You paused ScanDisk. To continue checking this drive, choose Continue.", WHITE, BLUE);
                DrawButton(5, 21, 11, WHITE+BLINK, DARKGRAY, "Continue", 1, 1);
                pause();
                break;

            case MSLEFT:
		if (PressedInRange(5, 21, 15, 21))       // Pause.
		    {
		    paused=1;
                    if (flags.monochrome==TRUE)
                        {
                        DrawText(5, 24, "You paused ScanDisk. To continue checking this drive, choose Continue.", LIGHTGRAY, BLACK);
                        DrawButton(5, 21, 11, BLACK+BLINK, LIGHTGRAY, "Continue", 1, 1);
                        } // end if.
                    else
                        {
                        DrawText(5, 24, "You paused ScanDisk. To continue checking this drive, choose Continue.", WHITE, BLUE);
                        DrawButton(5, 21, 11, WHITE+BLINK, DARKGRAY, "Continue", 1, 1);
                        } // end else.

                    pause();
		    } // end if.
		if (PressedInRange(20, 21, 32, 21))      // More info.
                    ShowHelpSystem();
		if (PressedInRange(37, 21, 46, 21))      // Exit.
		    {
                    if (show_exit()==TRUE)
                        {
                        if (flags.monochrome==TRUE)
                            {
                            ColorScreen(BLACK);
                            DrawText(10, 12, "ScanDisk did not finish examining this drive", LIGHTGRAY, BLACK);
                            DrawText(10, 15, "Press any key to exit", LIGHTGRAY, BLACK);
                            } // end if.
                        else
                            {
                            ColorScreen(LIGHTBLUE);
                            DrawText(10, 12, "ScanDisk did not finish examining this drive", WHITE, BLUE);
                            DrawText(10, 15, "Press any key to exit", LIGHTGRAY, BLUE);
                            } // end else.

                        getch();
                        leave = 1;
                        } // end if.

		    } // end if.
		break;

	    default:
		break;

	    } // end switch.

	} // end while.

} // end main_routine.

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    char *fileargs[64], *optargs[64], buffer[80];
    int n_options, index, help_flag=0, zindex=0, drive, max_length=0;

    n_options = classify_args(argc, argv, fileargs, optargs);zindex=zindex;
    for (index=0;index<n_options;index++)
	{
	if (optargs[index][0] == '?') help_flag=1;
        else if (optargs[index][0] == 'C' || optargs[index][0] == 'c')
            {
            if (stricmp(optargs[index],"CUSTOM")==0) custom_flag=1;
            else if (stricmp(optargs[index],"CHECKONLY")==0) repair=0;
            else
                goto err;

            } // end else.
	else if (optargs[index][0] == 'H' || optargs[index][0] == 'h')
	    {
            if (stricmp(optargs[index],"HELP")==0) help_flag=1;
            else
                goto err;

	    } // end else.
        else if (optargs[index][0] == 'M' || optargs[index][0] == 'm')
	    {
            if (stricmp(optargs[index],"MONO")==0) flags.monochrome=TRUE;
            else
                goto err;

	    } // end else.
        else if (optargs[index][0] == 'N' || optargs[index][0] == 'n')
	    {
            if (stricmp(optargs[index],"NOUI")==0) flags.no_screen=1;
            else
                goto err;

	    } // end else.
        else if (optargs[index][0] == 'T' || optargs[index][0] == 't') // Undocumented.
	    {
            if (stricmp(optargs[index],"TEXT")==0) flags.no_screen=1;
            else
                goto err;

	    } // end else.
	else
	    {
err:
	    printf("Invalid parameter - /%s\n", strupr(optargs[index]));
	    exit(1);
	    } // end else.

	} // end for.

    if (help_flag)
	{
	printf("Runs the ScanDisk disk-repair program.\n\n"
	       "To check and repair a drive, use the following syntax:\n"
	       "   SCANDISK [drive: | /ALL] [/CHECKONLY | /AUTOFIX [/NOSAVE]] [/SURFACE]\n"
	       "To examine a file for fragmentation, use the following syntax:\n"
	       "   SCANDISK /FRAGMENT [drive:][path]filename\n\n"
	       "/ALL         Checks and repairs all local drives\n"
	       "/AUTOFIX     Fixes damage without prompting\n"
	       "/CHECKONLY   Checks a drive, but does not repair any damage\n"
	       "/CUSTOM      Configures and runs ScanDisk according to SCANDISK.INI settings\n"
	       "/NOSAVE      With /AUTOFIX, deletes lost clusters rather than saving as files\n"
	       "/NOSUMMARY   With /CHECKONLY or /AUTOFIX, prevents ScanDisk from stopping at\n"
	       "             summary screens\n"
               "/NOUI        Uses normal DOS interface instead of graphical interface\n"
	       "/SURFACE     Performs a surface scan after other checks\n"
	       "/MONO        Configures ScanDisk for use with a monochrome display\n");
	exit(1);
	} // end if.

    if (argc == 1)                      // No drive specified.
	drive=getdisk();
    else if (argc == 2)                 // User may have specified a drive.
	{
	if (argv[1][1]==':' && strlen(argv[1])==2 && isalpha(argv[1][0]))
	    drive=toupper(argv[1][0])-'A';
	else if (argv[1][1]==':' && strlen(argv[1])>2 && isalpha(argv[1][0]))
	    {
	    drive=toupper(argv[1][0])-'A';
            zindex=0;
	    max_length=strlen(argv[1])-2;
	    if (max_length>11)
		max_length=11;

	    } // end else.
        else if (argc==2)
	    {
            drive=getdisk();
	    } // end else.

	} // end else.
    else if (argc >= 3)
	{
	if (argv[1][1]==':' && strlen(argv[1])==2 && isalpha(argv[1][0]))
	    drive=toupper(argv[1][0])-'A';

        } // end else.

    // Start loading.
    SaveDOSState();
    atexit(OnExit);
    ctrlbrk(OnCBreak);
    read_ini();
    SetScreenLines(25);
    if (flags.no_screen==TRUE)          // Don't use the interface.
        {
        printf("Free Scandisk\n"
               "-------------\n\n"
               "ScanDisk is now checking drive %c: for errors\n\n", drive+'A');
        get_descriptor(drive, 0);
        return 0;
        } // end if.

    if (flags.mouse == TRUE)
        {
        MousePresent();
        ShowMouse();
        MouseGotoXY(80,25);
        } // end if.
    else
        {
        HideMouse();
        } // end else.

    HideCursor();
    SetHighIntensity(1);
//    CriticalHandlerOn();
    if (flags.monochrome == TRUE)
        DrawScreenMono();
    else
        DrawScreen();

    sprintf(buffer, "%c:", drive+'A');
    if (flags.monochrome==TRUE)
        {
        DrawText(61, 6, buffer, LIGHTGRAY, BLACK);
        } // end if.
    else
        {
        DrawText(61, 6, buffer, LIGHTGRAY, BLUE);
        } // end else.

    if (do_logfile)
        {
        sprintf(logs, "ScanDisk checked drive %c for problems, with the following results:\n\n", drive+'A');
        logit(logs);
        } // end if.

    get_descriptor(drive, 1);
    main_routine();
    return 0;

} // end main.
