#include "control.h"
#include "controls.h"
#include "vscrctrl.h"
#include "loview.h"
#include "..\event\event.h"
#include "..\mouse\mouse.h"
#include "..\helpsys\hlpfncs.h"
#include "..\scandisk.h"

static void FillControl(struct Control* control, int top);

static int PastTop(struct Control* control, int top)
{
    struct VerticalScrollControl* VBox =
                         (struct VerticalScrollControl*)control->ControlData;

    return PastEndOfHelp(top, VBox->ylen-2);
}

static int OnClick(struct Control* control)
{
    int index;
    struct VerticalScrollControl* VBox =
                         (struct VerticalScrollControl*)control->ControlData;

    struct LowView* LView = (struct LowView*) VBox->ControlData;

    if ((index = CheckHelpClick(control->posx, control->posy,
                                VBox->xlen, VBox->ylen,
                                GetPressedX(), GetPressedY())) != -1)
    {
       SelectHelpPage(index);
       FillControl(control, 0);
       LView->top = 0;
       return EVENT_ANSWERED;
    }
    else
       return NOT_ANSWERED;
}

static int HandleEvent(struct Control* control, int event)
{
    int index;
    struct VerticalScrollControl* VBox =
                         (struct VerticalScrollControl*)control->ControlData;

    struct LowView* LView = (struct LowView*) VBox->ControlData;

    if (control->active)
       switch (event)
       {
              case PAGEDOWN:
                   if (PastEndOfHelp(LView->top + VBox->ylen - 2,
                                     VBox->ylen-2))
                      LView->top = GetLastHelpTop(VBox->ylen-2);
                   else
                      LView->top += VBox->ylen - 2;
                   FillControl(control, LView->top);
                   break;

              case PAGEUP:
                   if (LView->top > VBox->ylen - 2)
                      LView->top -= (VBox->ylen - 2);
                   else
                      LView->top = 0;
                   FillControl(control, LView->top);
                   break;

              case HOME:
                   LView->top = 0;
                   FillControl(control, LView->top);
                   break;

              case END:
                   LView->top = GetLastHelpTop(VBox->ylen-2);
                   FillControl(control, LView->top);
                   break;

              case TABKEY:
                   CheckHelpTab();
                   break;

              case ENTERKEY:
                   if ((index = CheckHelpEnter()) != -1)
                   {
                      SelectHelpPage(index);
                      FillControl(control, 0);
                      LView->top = 0;
                   }
                   break;

              default:
                   return NOT_ANSWERED;
       }

/*    VBox->AdjustScrollBar(control, LView->top, GetLastHelpTop(VBox->ylen-2)+1);*/

    return EVENT_ANSWERED;
}

static void FillControl(struct Control* control, int top)
{
    int i;
    struct VerticalScrollControl* VBox =
                         (struct VerticalScrollControl*)control->ControlData;
    struct LowView* LView = (struct LowView*) VBox->ControlData;

    for (i = 0; i < VBox->ylen-2; i++)
        DrawHelpLine(top+i, control->posx+1, control->posy+1+i,
                     VBox->xlen-2);
    
    VBox->AdjustScrollBar(control, LView->top, GetLastHelpTop(VBox->ylen-2)+1);
}

struct Control CreateHelpView(struct LowView* LView, struct VerticalScrollControl* VBox, int posx, int posy, int forcolor, int backcolor)
{
     struct Control result;
     struct VerticalScrollControl* control;

     VBox->OnClick     = OnClick;
     VBox->HandleEvent = HandleEvent;
     result = CreateLowView(LView, VBox, posx, posy, forcolor, backcolor);
     LView->FillControl = FillControl;
     LView->PastTop     = PastTop;

     return result;
}
