/****************************************************************/
/*                                                              */
/*                            dc.c                              */
/*                                                              */
/*                    disk commander for Seal                   */
/*                                                              */
/*                Seal - free desktop environment               */
/*                                                              */
/*                    Copyright (c) 1999,2000                   */
/*                         Michal Stencl                        */
/*                     All Rights Reserved                      */
/*                                                              */
/* mail : stenclpmd@ba.telecom.sk                               */
/* web  : http://www.home.sk/public/seal/                       */
/*                                                              */
/* This file is part of Seal.                                   */
/*                                                              */
/* Seal is free software; you can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation; either version */
/* 2, or (at your option) any later version.                    */
/*                                                              */
/* Seal is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of   */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See    */
/* the GNU General Public License for more details.             */
/*                                                              */
/* You should have received a copy of the GNU General Public    */
/* License along with Seal; see the file COPYING.  If not,      */
/* write to the Free Software Foundation, 675 Mass Ave,         */
/* Cambridge, MA 02139, USA.                                    */
/*                                                              */
/****************************************************************/



#include"allegro.h"
#include"seal.h"
#include"menus.h"
#include"app.h"
#include"button.h"
#include"dialogs.h"
#include"iodlg.h"

l_text dc_standard_path1 = "c:/";
l_text dc_standard_path2 = "c:/";

#define DC_SIZEX   640
#define DC_SIZEY   480

#ifndef TXT_CANTRUNFILE
#define TXT_CANTRUNFILE        INI_TEXT("Can't run file")
#endif

void  dcfilelistbox_translate_event ( p_object o, p_event event )
{

   RETVIEW(o, event);

   /* call old function from iodlg.h */

   filelistbox_translate_event(o, event);


   if ( event->type & EV_MESSAGE ) { /* */

       switch ( event->message ) {

           case MSG_OK : { /* enter on file */

                 l_text file = FILELISTBOX_ITEM_FILENAME(LISTBOX(o)->list, LISTBOX(o)->current);
                 l_text path = FILELISTBOX_ITEM_PATH(LISTBOX(o)->list, LISTBOX(o)->current);

                 l_text runfile = io_realpath(path, file);
                 l_text lf = io_sealfile(runfile);

                 clear_event(event);

                 if ( !run_file (lf) )

                     seal_error(ERR_INFO, "%s\n\n%s", TXT_CANTRUNFILE, lf);

                 _free(runfile);
                 _free(lf);

           }; break;

       };

   };

};


static t_point  dc_size_minimum ( p_view o )
{
   return point_assign(DC_SIZEX/2+100, 200);
};


void  init_dc ( void )
{

   t_rect r = rect_assign(0, 0, DC_SIZEX, DC_SIZEY);
   t_rect t = r;

   p_filelistbox box1;
   p_filelistbox box2;
   p_dirhistory  dir1;
   p_dirhistory  dir2;

   p_appwin o = appwin_init(_malloc(sizeof(t_appwin)), /* make window */
                            r,
                            "Disk Commander 1.0",
                            WF_MAXIMIZE|WF_MINIMIZE,
                            ap_id, /* application id */
                            NULL);

   VIEW(o)->drag_mode |= DM_DRAGGROW; /* able to grow view */

   VIEW(o)->align |= TX_ALIGN_CENTER; /* set alignment */

   VIEW(o)->size_minimum = &dc_size_minimum;

   OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(o)); /* insert it on the desktop */

   r = VIEW(o)->size_limits(VIEW(o));

   r = rect_assign(r.a.x+10, r.a.y+10, t.b.x-10, r.b.y-70);

   r = rect_assign(r.a.x, r.a.y, r.a.x+(DC_SIZEX/2)-20, r.b.y);

   t = r;

   r.a.y += 30;

   box1 = filelistbox_init(_malloc(sizeof(t_filelistbox)), r, 2, LF_SELECTABLE|FL_OPEN, dc_standard_path1, "*.*", FA_ALL, NULL);

   if ( box1 ) {
        /* redeclare translate event function */
        OBJECT(box1)->translate_event = &dcfilelistbox_translate_event;
        /* redeclare alignment of filelistbox 1 */
        VIEW(box1)->align |= TX_ALIGN_BOTTOM;
   };

   r = rect_move(r, (DC_SIZEX/2)-10, 0);

   box2 = filelistbox_init(_malloc(sizeof(t_filelistbox)), r, 2, LF_SELECTABLE|FL_OPEN, dc_standard_path2, "*.*", FA_ALL, NULL);

   if ( box2 ) {
        /* redeclare translate event function */
        OBJECT(box2)->translate_event = &dcfilelistbox_translate_event;
        /* redeclare alignment of filelistbox 1 */
        VIEW(box2)->align |= TX_ALIGN_RIGHT+TX_ALIGN_BOTTOM;
   };

   r = rect_assign(t.a.x, t.a.y, t.a.x+200, t.a.y+20);

   /* make link for box1 */
   dir1 = dirhistory_init(_malloc(sizeof(t_dirhistory)), r, IO_TEXT_LIMIT, HF_REWRITEUNABLE, box1);

   r = rect_assign(t.a.x+(DC_SIZEX/2)-10, r.a.y, DC_SIZEX-30, r.b.y);

   /* make link for box2 */
   dir2 = dirhistory_init(_malloc(sizeof(t_dirhistory)), r, IO_TEXT_LIMIT, HF_REWRITEUNABLE, box2);

   if ( dir2 )
        /* redeclare alignment of filelistbox 1 */
        VIEW(dir2)->align |= TX_ALIGN_RIGHT;

   OBJECT(o)->insert(OBJECT(o), OBJECT(box1)); /* insert it on the desktop */

   OBJECT(o)->insert(OBJECT(o), OBJECT(dir1)); /* insert it on the desktop */

   OBJECT(o)->insert(OBJECT(o), OBJECT(box2)); /* insert it on the desktop */

   OBJECT(o)->insert(OBJECT(o), OBJECT(dir2)); /* insert it on the desktop */

};


app_begin ( void ) {


  if ( ap_process == AP_INIT ) {

      init_dc();

  };

  if ( ap_process == AP_FREE ) {

  };

} app_end;

