/*
// Program:  Free FDISK
// Written By:  Brian E. Reifsnyder
// Module:  HELPSCR.C
// Module Description:  User Interface Code Module
// Version:  1.0
// Copyright:  1998-2001 under the terms of the GNU GPL, Version 2
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  INCLUDES
/////////////////////////////////////////////////////////////////////////////
*/

#include <stdio.h>
#include <string.h>

#include "main.h"
#include "userint1.h"
#include "pdiskio.h"

/*
/////////////////////////////////////////////////////////////////////////////
//  FUNCTIONS
/////////////////////////////////////////////////////////////////////////////
*/

/* Display Help Screens */
void Display_Help_Screen()
{
  char version[40];
  char name[20];

  if(flags.use_freedos_label==TRUE)
    {
    strcpy(name,ALTNAME);
    strcat(name," FDISK");
    }
  else strcpy(name,PRINAME);

  strcpy(version,"Version ");
  strcat(version,VERSION);

  if(flags.do_not_pause_help_information==FALSE) Clear_Screen(NOEXTRAS);

  printf("\n\n%-20s                   %40s\n", name, version);
  printf("Written By:  Brian E. Reifsnyder\n\n");
  printf("Syntax:\n\n");
  printf("  %s                   Runs %s in interactive mode.\n",filename,name);
  printf("  %s /? [/NOPAUSE]     Displays this help information.\n\n",filename);

  printf("%s compatibility switches:\n\n",name);
  printf("  %s /ACTOK\n",filename);
  printf("  %s /CMBR <drive#>\n",filename);
  printf("  %s /EXT:<size> <drive#> [{/LOG:<size>} | {/LOGO:<size>}]\n",filename);
  printf("  %s /FPRMT\n",filename);
  printf("  %s /MBR\n",filename);
  printf("  %s /PRI:<size> <drive#>\n",filename);
  printf("  %s /PRIO:<size> <drive#>\n",filename);
  printf("  %s /Q\n",filename);
  printf("  %s /STATUS\n",filename);
  printf("  %s /X\n",filename);
  printf("\n\n");

  if(flags.do_not_pause_help_information==FALSE)
    {
    Pause();
    Clear_Screen(NOEXTRAS);
    }

  printf("%s extended switches:\n\n",name);
  printf("For partition table modification:\n");

  printf("  %s /AUTO [<drive#>]\n",filename);
  printf("  %s /ACTIVATE:<partition#> [<drive#>]\n",filename);
  printf("  %s /CLEAR [<drive#>]\n",filename);
  printf("  %s /CLEARALL [<drive#>]\n",filename);
  printf("  %s /DELETE {/PRI | /EXT | /LOG:<partition#>\n",filename);
  printf("           | /NUM:<partition#>} [<drive#>]\n");
  printf("  %s /DEACTIVATE [<drive#>]\n",filename);
  printf("  %s /EXT:<size>[,100] \n",filename);
  printf("           [ {/LOG:<size>[,100] [/SPEC:<type#>]} \n");
  printf("           | {/LOGO:<size>[,100] [/SPEC:<type#>]} ] [<drive#>]\n");
  printf("  %s /LOG:<size>[,100] [/SPEC:<type#>] [<drive#>]\n",filename);
  printf("  %s /LOGO:<size>[,100] [/SPEC:<type#>] [<drive#>] \n",filename);
  printf("  %s /MODIFY:<partition#>,<newtype#> [<drive#>]\n",filename);
  printf("  %s /MOVE:<source_partition#>,<dest_partition#> [<drive#>]\n",filename);
  printf("  %s /PRI:<size>[,100] [/SPEC:<type#>] [<drive#>] \n",filename);
  printf("  %s /PRIO:<size>[,100] [/SPEC:<type#>] [<drive#>] \n",filename);
  printf("  %s /SWAP:<first_partition#>,<second_partition#> [<drive#>]\n",filename);

  if(flags.do_not_pause_help_information==FALSE)
    {
    printf("\n\n");
    Pause();
    Clear_Screen(NOEXTRAS);
    printf("%s extended switches(cont.):\n",name);
    }

  printf("\nFor MBR modification:\n");
  printf("  %s /AMBR [<drive#>]\n",filename);
  printf("  %s /MBR [<drive#>]\n",filename);
  printf("  %s /RMBR [<drive#>]\n",filename);
  printf("  %s /SMBR [<drive#>]\n",filename);

  printf("\nFor handling flags on a hard disk:\n");
  printf("  %s /CLEARFLAG[{:<flag#>} | /ALL} ] [<drive#>]\n",filename);
  printf("  %s /SETFLAG:<flag#>[,<flag_value>] [<drive#>]\n",filename);
  printf("  %s /TESTFLAG:<flag#>[,<flag_value>] [<drive#>]\n",filename);

  printf("\nFor obtaining information about the hard disk(s):\n");
  printf("  %s /DUMP\n",filename);
  printf("  %s /INFO [/TECH] [<drive#>]\n",filename);

  printf("\nFor rebooting the computer:\n");
  printf("  %s /REBOOT\n",filename);
  printf("\n\n");

  if(flags.do_not_pause_help_information==FALSE)
    {
    printf("\n");
    Pause();
    Clear_Screen(NOEXTRAS);
    }

  printf("\n%s interactive user interface switches:\n\n",name);
  printf("  %s /MONO\n",filename);
  printf("  %s /XO\n",filename);

  if(flags.do_not_pause_help_information==FALSE)
    {
    printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
    Pause();
    Clear_Screen(NOEXTRAS);
    }

  printf("\nDescription of %s compatibility switches:\n\n",name);
  printf("  /ACTOK   Normally skips integrity checking...kept for compatibility.\n");
  printf("  /CMBR    Writes the MBR to <drive#>.\n");
  printf("  /EXT     Creates an Extended DOS Partition of <size>MB on <drive#>.  /LOG\n");
  printf("             creates a logical drive of <size>MB.  /LOGO will force the\n");
  printf("             creation of a FAT16 logical drive of <size>MB.\n");
  printf("  /FPRMT   Prompts for FAT32/FAT16 in interactive mode.\n");
  printf("  /MBR     Writes the MBR to the first hard disk.\n");
  printf("  /PRI     Creates a partition of <size>MB on <drive#>.\n");
  printf("  /PRIO    Creates a FAT16 partition of <size>MB on <drive#>.\n");
  printf("  /Q       Keeps the system from rebooting after you exit %s.\n",name);
  printf("             (Note:  %s will not reboot after you exit unless\n",name);
  printf("             rebooting is enabled in the \"fdisk.ini\" file.)\n");
  printf("  /STATUS  Displays the current partition layout.\n",filename);
  printf("  /X       Do not use LBA partitions.\n",filename);

  printf("\n\n");

  if(flags.do_not_pause_help_information==FALSE)
    {
    printf("\n\n\n\n");
    Pause();
    Clear_Screen(NOEXTRAS);
    }

  printf("\nDescription of %s extended switches:\n",name);
  printf("\nFor partition table modification:\n");

  printf("  /AUTO    Automatically partitions the hard disk with FAT16 partitions.\n");
  printf("  /ACTIVATE\n");
  printf("           Sets <partition#> active.\n");
  printf("  /CLEAR   Erases the partition tables.  USE WITH CAUTION!\n");
  printf("  /CLEARALL\n");
  printf("           Erases the partition tables and MBR.  USE WITH CAUTION!\n");
  printf("  /DELETE  Deletes a partition.\n");
  printf("  /DEACTIVATE\n");
  printf("           Removes the active status from a partition on <drive#>.\n");
  printf("  /EXT     Same as /EXT above, except \",100\" will indicate that <size>\n");
  printf("             is a percentage and \"/SPEC\" will specify the partition\n");
  printf("             <type#>.  /LOGO will force %s to not use FAT32\n",name);
  printf("             partitions.\n");
  printf("  /LOG     Same as /LOG above, except for the addition of extra\n");
  printf("             functionallity.  See /EXT, above, for more information.\n");
  printf("  /LOGO    Same as /LOGO above, except for the addition of extra\n");
  printf("             functionallity.\n");

  if(flags.do_not_pause_help_information==FALSE)
    {
    printf("\n\n");
    Pause();
    Clear_Screen(NOEXTRAS);

    printf("For partition table modification(cont.):\n");
    }

  printf("  /MODIFY  Changes the partition type of <partition#> to <newtype#>.\n");
  printf("             Note:  The starting <partition#> for logical partitions\n");
  printf("                    is \"5\".\n");
  printf("  /MOVE    Moves the entry, in the primary partition table, from\n");
  printf("             <source_partition#> to <dest_partition#>.\n");
  printf("  /PRI     Same as /PRI above, except for the addition of extra\n");
  printf("             functionallity.  See /EXT, above, for more information.\n");
  printf("  /PRIO    Same as /PRIO above, except for the addition of extra\n");
  printf("             functionallity.  See /EXT, above, for more information.\n");
  printf("  /SWAP    Swaps the 2 partition entries, <first_partition#> and\n");
  printf("             <second_partition#).\n");
  printf("\nFor MBR modification:\n");
  printf("  /AMBR    Writes the MBR stored in the \"boot.mbr\" file.\n");
  printf("  /MBR     Writes the MBR to <drive#>.\n");
  printf("  /RMBR    Removes the MBR from <drive#>.\n",filename);
  printf("  /SMBR    Saves the MBR, on <drive#>, into a \"boot.mbr\" file.\n",filename);

  if(flags.do_not_pause_help_information==FALSE)
    {
    printf("\n\n\n\n");
    Pause();
    Clear_Screen(NOEXTRAS);
    }

  printf("\nFor handling flags on a hard disk:\n");
  printf("  /CLEARFLAG\n");
  printf("           Resets the <flag#> or all the flags on <drive#> to 0.\n");
  printf("  /SETFLAG\n");
  printf("           Sets <flag#> to 1 or <flag_value>, if specified.\n");
  printf("  /TESTFLAG:\n");
  printf("           Tests <flag#> for 1 or <flag_value>, if specified.\n");
  printf("\nFor obtaining information about the hard disk(s):\n");
  printf("  /DUMP    Dumps all partition information from all hard disks.  This\n");
  printf("             function is mainly used for debugging by redirecting the\n");
  printf("             output to a file.\n");
  printf("  /INFO    Displays partition information from <drive#>\n");
  printf("\nFor rebooting the computer:\n");
  printf("  /REBOOT  Forces a reboot.\n");

  printf("\nInteractive user interface switches:\n",name);
  printf("  /MONO    Forces the user interface to run in monochrome mode.\n");
  printf("  /XO      Enables extended options.\n");

  if(flags.do_not_pause_help_information==FALSE)
    {
    printf("\n\n");
    Pause();
    Clear_Screen(NOEXTRAS);
    }
  else printf("\n\n");

  printf("\n\n");
  printf("This program is Copyright %s, by Brian E. Reifsnyder, under\n",COPYLEFT);
  printf("the terms of the GNU General Public License, version 2.\n");
  printf("\nThis program comes as-is and without warranty of any kind.  The author of\n");
  printf("this software assumes no responsibility pertaining to the use or mis-use of\n");
  printf("this software.  By using this software, the operator is understood to be\n");
  printf("agreeing to the terms of the above.\n");

  if(flags.do_not_pause_help_information==FALSE) printf("\n\n\n\n\n\n\n\n");
}
