/*
// Program:  Free FDISK
// Written By:  Brian E. Reifsnyder
// Module:  USERINT2.C
// Module Description:  Second User Interface Code Module
// Version:  1.0
// Copyright:  1998-2001 under the terms of the GNU GPL, Version 2
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  DEFINES
/////////////////////////////////////////////////////////////////////////////
*/

#define USERINT

/*
/////////////////////////////////////////////////////////////////////////////
//  INCLUDES
/////////////////////////////////////////////////////////////////////////////
*/

#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fdiskio.h"
#include "main.h"
#include "pcompute.h"
#include "pdiskio.h"
#include "userint2.h"
#include "userint1.h"

/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL VARIABLES
/////////////////////////////////////////////////////////////////////////////
*/

extern char **environ;

/*
/////////////////////////////////////////////////////////////////////////////
//  FUNCTIONS
/////////////////////////////////////////////////////////////////////////////
*/

/* Ask user if they want to use large disk support (FAT 32) */
void Ask_User_About_FAT32_Support()
{
  Clear_Screen(NULL);

  Print_Centered(5,"Free FDISK is capable of using large disk support to allow you to    ",0);
  Print_Centered(6,"create partitions that are greater than 2,048 MB by using FAT32      ",0);
  Print_Centered(7,"partitions.  If you enable large disk support, any partitions or     ",0);
  Print_Centered(8,"logical drives greater than 512 MB will be created using FAT32.      ",0);
  Print_Centered(10,"IMPORTANT:  If you enable large disk support many operating systems,",0);
  Print_Centered(11,"including FreeDOS, will be unable to access the partitions and      ",0);
  Print_Centered(12,"logical drives created that are over 512 MB in size.                ",0);

  Print_Centered(17,"Do you want to use large disk support (Y/N)....?    ",0);

  flags.fat32=Input(1,62,17,YN,0,0,NONE,1,0,NULL,NULL);
}

/* Change Current Fixed Disk Drive */
void Change_Current_Fixed_Disk_Drive()
{
  int new_drive_number;
  int old_drive_number=flags.drive_number;

  Clear_Screen(NULL);
  Print_Centered(0,"Change Current Fixed Disk Drive",BOLD);

  Display_All_Drives();

  Position_Cursor(4,21);
  printf("Enter Fixed Disk Drive Number (1-%d)......................."
   ,(flags.maximum_drive_number-127));

  new_drive_number=Input(1,62,21,NUM,1,(flags.maximum_drive_number-127)
   ,ESCR,(flags.drive_number-127),0,NULL,NULL);

  if( (new_drive_number<=0)
   || (new_drive_number>(flags.maximum_drive_number-127)) )
    {
    flags.drive_number=old_drive_number;
    }
  else
    {
    flags.drive_number=new_drive_number+127;
    }
}

/* Create DOS Partition Interface */
int Create_DOS_Partition_Interface(int type)
{
  int numeric_type;
  int partition_created=FALSE;
  int partition_slot_just_used;

  long maximum_partition_size_in_MB;
  long maximum_possible_percentage;
  long stored_maximum_partition_size_in_MB;

  unsigned long input=0;

  Determine_Free_Space();

  maximum_partition_size_in_MB
   =(((part_table[(flags.drive_number-128)]
   .pri_part_largest_free_space+1)
   *(part_table[(flags.drive_number-128)].total_head+1)
   *(part_table[(flags.drive_number-128)].total_sect))/2048);

  stored_maximum_partition_size_in_MB = maximum_partition_size_in_MB;

  /* Adjust maximum_partition_size_in_MB depending upon version */
  if( (type!=EXTENDED) && (flags.version==FOUR)
   && (maximum_partition_size_in_MB>2048) )
   maximum_partition_size_in_MB=2048;

  if( (type!=EXTENDED) && (flags.version==FIVE)
   && (maximum_partition_size_in_MB>2048) )
   maximum_partition_size_in_MB=2048;

  if( (type!=EXTENDED) && (flags.version==SIX)
   && (maximum_partition_size_in_MB>2048) )
   maximum_partition_size_in_MB=2048;

  if( (type!=EXTENDED) && (flags.version==W95)
   && (maximum_partition_size_in_MB>2048) )
   maximum_partition_size_in_MB=2048;

  if( (type!=EXTENDED) && ( (flags.version==W95B) || (flags.version==W98) )
   && (flags.fat32==FALSE) && (maximum_partition_size_in_MB>2048) )
   maximum_partition_size_in_MB=2048;

  if( (type!=EXTENDED) && (flags.fat32==FALSE)
   && (flags.allow_4gb_fat16==TRUE)
   && (stored_maximum_partition_size_in_MB > 2048) )
   maximum_partition_size_in_MB=stored_maximum_partition_size_in_MB;

  if( (type!=EXTENDED) && (flags.fat32==FALSE)
   && (flags.allow_4gb_fat16==TRUE)
   && (stored_maximum_partition_size_in_MB >= 4096) )
   maximum_partition_size_in_MB=4096;

  if(type==PRIMARY)
    {
    Clear_Screen(NULL);

    Print_Centered(4,"Create Primary DOS Partition",BOLD);

    Position_Cursor(4,6);
    printf("Current fixed disk drive: ");
    cprintf("%d",(flags.drive_number-127));

    Position_Cursor(4,8);
    printf("Do you wish to use the maximum available size for a Primary DOS Partition");

    if((flags.drive_number-128)==0)
      {
      Position_Cursor(4,9);
      printf("and make the partition active (Y/N).....................? ");
      }
    else
      {
      Position_Cursor(4,9);
      printf("(Y/N)...................................................? ");
      }

    flags.esc=FALSE;
    input=Input(1,62,9,YN,0,0,ESCR,1,0,NULL,NULL);
    if(flags.esc==TRUE) return(1);

    if(input==1)
      {
      input=maximum_partition_size_in_MB;
      numeric_type=6;  /* Set the numeric type to 6 so that it will be    */
		       /* decided by Partition_Type_To_Create().          */

      if( (flags.fprmt==TRUE) && (type==PRIMARY) && (input>=128) && (input<=2048) )
	{
	Position_Cursor(4,22);
	printf("This drive is a FAT32 by default, switch to FAT16 (Y/N)?    ");
	flags.fat32=!Input(1,61,22,YN,0,0,NONE,1,0,NULL,NULL);
	}

      /* Use the maximum available free space to create a DOS Partition */

      /* Adjust numeric type depending upon partition size and the FDISK */
      /* version emulated.                                               */
      numeric_type=Partition_Type_To_Create(input,numeric_type);

      partition_slot_just_used=Create_Primary_Partition(numeric_type,input);
      if((flags.drive_number-128)==0) Set_Active_Partition(partition_slot_just_used);
      partition_created=TRUE;
      }
    }

  if(partition_created==FALSE)
    {
    Clear_Screen(NULL);

    if(type==PRIMARY) Print_Centered(4,"Create Primary DOS Partition",BOLD);
    else Print_Centered(4,"Create Extended DOS Partition",BOLD);

    Position_Cursor(4,6);
    printf("Current fixed disk drive: ");
    cprintf("%d",(flags.drive_number-127));

    Display_Primary_Partition_Information_SS();

    Position_Cursor(4,15);
    printf("Maximum space available for partition is ");

    if( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) )
      Print_UL_B(maximum_partition_size_in_MB);
    else cprintf("%4d",maximum_partition_size_in_MB);

    printf(" Mbytes ");

    maximum_possible_percentage=(100*maximum_partition_size_in_MB)/part_table[(flags.drive_number-128)].total_hard_disk_size_in_MB;
    cprintf("(%3d%%)",maximum_possible_percentage);

    Position_Cursor(4,18);
    printf("Enter partition size in Mbytes or percent of disk space (%) to");
    Position_Cursor(4,19);

    if(type==PRIMARY) printf("create a Primary DOS Partition.................................: ");
    else printf("create an Extended DOS Partition...............................: ");

    flags.esc=FALSE;

    if( (flags.version==4) || (flags.version==5) || (flags.version==6) )
     input=Input(4,69,19,NUMP,1,maximum_partition_size_in_MB,ESCR
     ,maximum_partition_size_in_MB,maximum_possible_percentage,NULL,NULL);
    else input=Input(6,69,19,NUMP,1,maximum_partition_size_in_MB,ESCR
     ,maximum_partition_size_in_MB,maximum_possible_percentage,NULL,NULL);

    if(flags.esc==TRUE) return(1);

    if( (flags.fprmt==TRUE) && (type==PRIMARY) && (input>=128) && (input<=2048) )
      {
      Position_Cursor(4,22);
      printf("This drive is a FAT32 by default, switch to FAT16 (Y/N)?    ");
      flags.fat32=!Input(1,61,22,YN,0,0,NONE,1,0,NULL,NULL);
      }

    if(type==PRIMARY) numeric_type=Partition_Type_To_Create(input,0);
    else numeric_type=5;

    Create_Primary_Partition(numeric_type,input);
    }

  if(flags.fprmt==TRUE) flags.fat32=FALSE;

  Clear_Screen(NULL);

  if(type==PRIMARY) Print_Centered(4,"Create Primary DOS Partition",BOLD);
  else Print_Centered(4,"Create Extended DOS Partition",BOLD);

  Position_Cursor(4,6);
  printf("Current fixed disk drive: ");
  cprintf("%d",(flags.drive_number-127));

  Display_Primary_Partition_Information_SS();

  Position_Cursor(4,21);
  if(type==PRIMARY) cprintf("Primary DOS Partition created");
  else cprintf("Extended DOS Partition created");

  Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);

  if(type==EXTENDED) Create_Logical_Drive_Interface();

  return(0);
}

/* Create Logical Drive Interface */
/* Returns a 0 if successful and a 1 if unsuccessful */
int Create_Logical_Drive_Interface()
{
  long input=0;

  int drive_created=FALSE;
  int maximum_possible_percentage;
  int numeric_type;

  long maximum_partition_size_in_MB;
  long stored_maximum_partition_size_in_MB;

  Determine_Free_Space();

  maximum_partition_size_in_MB
   =(((part_table[(flags.drive_number-128)]
   .ext_part_largest_free_space+1)
   *(part_table[(flags.drive_number-128)].total_head+1)
   *(part_table[(flags.drive_number-128)].total_sect))/2048);

  stored_maximum_partition_size_in_MB = maximum_partition_size_in_MB;

  if(part_table[(flags.drive_number-128)]
   .ext_part_largest_free_space>=2)
    {
    do
      {
      if(flags.fprmt==TRUE) flags.fat32=TRUE;

      /* Adjust maximum_partition_size_in_MB depending upon version */
      if( (flags.version==FOUR) && (maximum_partition_size_in_MB>2048) )
       maximum_partition_size_in_MB=2048;
      if( (flags.version==FIVE) && (maximum_partition_size_in_MB>2048) )
       maximum_partition_size_in_MB=2048;
      if( (flags.version==SIX) && (maximum_partition_size_in_MB>2048) )
       maximum_partition_size_in_MB=2048;
      if( (flags.version==W95) && (maximum_partition_size_in_MB>2048) )
       maximum_partition_size_in_MB=2048;
      if( ( (flags.version==W95B) || (flags.version==W98) )
       && (flags.fat32==FALSE) && (maximum_partition_size_in_MB>2048) )
       maximum_partition_size_in_MB=2048;
      if( (flags.fat32==FALSE) && (flags.allow_4gb_fat16==TRUE)
       && (stored_maximum_partition_size_in_MB > 2048) )
       maximum_partition_size_in_MB=stored_maximum_partition_size_in_MB;
      if( (flags.fat32==FALSE) && (flags.allow_4gb_fat16==TRUE)
       && (stored_maximum_partition_size_in_MB >= 4096) )
       maximum_partition_size_in_MB=4096;

      Clear_Screen(NULL);

      if(drive_created==TRUE)
	{
	Position_Cursor(4,22);
	cprintf("Logical DOS Drive created, drive letters changed or added");
	}

      Print_Centered(1,"Create Logical DOS Drive in the Extended DOS Partition",BOLD);

      Display_Extended_Partition_Information_SS();

      if(1==Determine_Drive_Letters())
	{
	Position_Cursor(4,22);
	printf("                                                           ");
	Position_Cursor(4,22);
	cprintf("Maximum number of Logical DOS Drives installed.");
	Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
	if(flags.fprmt==TRUE) flags.fat32=FALSE;
	return(1);
	}

      Position_Cursor(4,17);
      printf("Total Extended DOS Partition size is ");

      if( (flags.version==4) || (flags.version==5) || (flags.version==6) )
	cprintf("%4d",part_table[(flags.drive_number-128)].ext_part_size_in_MB);
      else Print_UL_B(part_table[(flags.drive_number-128)].ext_part_size_in_MB);

      printf(" Mbytes (1 Mbyte = 1048576 bytes)");

      Position_Cursor(4,18);
      printf("Maximum space available for partition is ");

      if( (flags.version==4) || (flags.version==5) || (flags.version==6) )
	cprintf("%4d",maximum_partition_size_in_MB);
      else Print_UL_B(maximum_partition_size_in_MB);

      printf(" Mbytes ");
      maximum_possible_percentage=(100*maximum_partition_size_in_MB)/part_table[(flags.drive_number-128)].ext_part_size_in_MB;
      cprintf("(%3d%%)",maximum_possible_percentage);

      Position_Cursor(4,20);
      printf("Enter logical drive size in Mbytes or percent of disk space (%)...");

      flags.esc=FALSE;

      if( (flags.version==4) || (flags.version==5) || (flags.version==6) )
       input=Input(4,70,20,NUMP,1,maximum_partition_size_in_MB,ESCR
       ,maximum_partition_size_in_MB,maximum_possible_percentage,NULL,NULL);
      else input=Input(6,70,20,NUMP,1,maximum_partition_size_in_MB,ESCR
       ,maximum_partition_size_in_MB,maximum_possible_percentage,NULL,NULL);

      if(flags.esc==TRUE)
	{
	if(flags.fprmt==TRUE) flags.fat32=FALSE;
	return(1);
	}

      if( (flags.fprmt==TRUE) && (input>=128) && (input<=2048) )
	{
	Position_Cursor(4,21);
	printf("This drive is a FAT32 by default, switch to FAT16 (Y/N)?    ");
	flags.fat32=!Input(1,61,21,YN,0,0,NONE,1,0,NULL,NULL);
	}

      numeric_type=Partition_Type_To_Create(input,numeric_type);

      Create_Logical_Drive(numeric_type,input);
      drive_created=TRUE;

      Determine_Free_Space();
      maximum_partition_size_in_MB
       =(((part_table[(flags.drive_number-128)]
       .ext_part_largest_free_space+1)
       *(part_table[(flags.drive_number-128)].total_head+1)
       *(part_table[(flags.drive_number-128)].total_sect))/2048);

      stored_maximum_partition_size_in_MB = maximum_partition_size_in_MB;

      }while(part_table[(flags.drive_number-128)].ext_part_largest_free_space>=2);
    }

  Clear_Screen(NULL);
  Print_Centered(1,"Create Logical DOS Drive in the Extended DOS Partition",BOLD);
  Display_Extended_Partition_Information_SS();
  Position_Cursor(4,22);
  cprintf("All available space in the Extended DOS Partition");
  Position_Cursor(4,23);
  cprintf("is assigned to logical drives.");
  Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);

  if(flags.fprmt==TRUE) flags.fat32=FALSE;

  return(0);
}

/* Delete Extended DOS Partition Interface */
void Delete_Extended_DOS_Partition_Interface()
{
  int input=0;

  Clear_Screen(NULL);

  Print_Centered(4,"Delete Extended DOS Partition",BOLD);

  Display_Primary_Partition_Information_SS();

  Position_Cursor(4,18);
  if(flags.monochrome!=TRUE) textcolor(WHITE | BLINK);
  cprintf("WARNING!");
  if(flags.monochrome!=TRUE) textcolor(15);

  printf(" Data in the deleted Extended DOS Partition will be lost.");
  Position_Cursor(4,19);
  printf("Do you wish to continue (Y/N).................? ");

  flags.esc=FALSE;
  input=Input(1,52,19,YN,0,0,ESCR,0,0,NULL,NULL);

  if( (flags.esc==FALSE) && (input==TRUE) )
    {
    Delete_Primary_Partition(part_table[(flags.drive_number-128)].num_of_ext_part);
    Clear_Extended_Partition_Table(flags.drive_number-128);

    Clear_Screen(NULL);
    Print_Centered(4,"Delete Extended DOS Partition",BOLD);
    Display_Primary_Partition_Information_SS();

    Position_Cursor(4,21);
    cprintf("Extended DOS Partition deleted");

    Position_Cursor(4,24);
    printf("                                    ");

    Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
    }
}

/* Delete Logical Drive Interface */
int Delete_Logical_Drive_Interface()
{
  char char_number[2];

  int drive_to_delete=0;
  int index=0;
  int input=0;
  int input_ok;

  Clear_Screen(NULL);

  Print_Centered(1,"Delete Logical DOS Drive(s) in the Extended DOS Partition",BOLD);

  Display_Extended_Partition_Information_SS();

  Position_Cursor(4,19);
  if(flags.monochrome!=TRUE) textcolor(WHITE | BLINK);
  cprintf("WARNING!");
  if(flags.monochrome!=TRUE) textcolor(15);

  printf(" Data in a deleted Logical DOS Drive will be lost.");
  Position_Cursor(4,20);
  printf ("What drive do you want to delete...............................? ");

  Determine_Drive_Letters();

  //char drive_lettering_buffer[8] [27];   this line is for reference
  /* Place code to find the min and max drive letter here. */

  input_ok=FALSE;

  do
    {
    flags.esc=FALSE;

    if( (flags.del_non_dos_log_drives==TRUE)
     && (part_table[(flags.drive_number-128)].num_of_non_dos_log_drives>0) )
     {
     if(part_table[(flags.drive_number-128)].num_of_non_dos_log_drives>9)
      part_table[(flags.drive_number-128)].num_of_non_dos_log_drives=9;
     itoa(part_table[(flags.drive_number-128)].num_of_non_dos_log_drives,char_number,10);
     input=Input(1,69,20,CHAR,67,90,ESCR,0,0,"1",char_number);
     }
    else input=Input(1,69,20,CHAR,67,90,ESCR,0,0,NULL,NULL);
    /* Note:  min_range and max_range will need adjusted!!!!! */
    /* Changes will have to be made because the first logical drive letter */
    /* on the selected drive may not be D:, the drive letters on the       */
    /* drive may not be sequential.                                        */

    if(flags.esc==TRUE) return(1);

    if(flags.esc==FALSE)
      {
      /* Ensure that the entered character is legitimate. */
      index=4;
      do
	{
	if( (drive_lettering_buffer[(flags.drive_number-128)] [index]>0)
	 && (drive_lettering_buffer[(flags.drive_number-128)] [index]==input) )
	  {
	  input=index-4;
	  input_ok=TRUE;
	  index=30; /* break out of the loop */
	  }

	index++;
	}while(index<=26);
      }

    }while(input_ok==FALSE);

  drive_to_delete=input;

  Position_Cursor(4,22);
  printf("Are you sure (Y/N)..............................? ");
  flags.esc=FALSE;
  input=Input(1,54,22,YN,0,0,ESCR,0,0,NULL,NULL);

  if( (input==TRUE) && (flags.esc==FALSE) )
    {
    Delete_Logical_Drive(drive_to_delete);

    Clear_Screen(NULL);
    Print_Centered(1,"Delete Logical DOS Drive(s) in the Extended DOS Partition",BOLD);
    Display_Extended_Partition_Information_SS();
    input=Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
    }

  return(0);
}

/* Delete Non-DOS Partition User Interface */
void Delete_N_DOS_Partition_Interface()
{
  int input=0;

  Clear_Screen(NULL);
  Print_Centered(4,"Delete Non-DOS Partition",BOLD);

  Display_Primary_Partition_Information_SS();

  Position_Cursor(4,18);
  if(flags.monochrome!=TRUE) textcolor(WHITE | BLINK);
  cprintf("WARNING!");
  if(flags.monochrome!=TRUE) textcolor(15);

  printf(" Data in the deleted Non-DOS Partition will be lost.");
  Position_Cursor(4,19);
  printf("What Non-DOS Partition do you want to delete..? ");

  flags.esc=FALSE;
  input=Input(1,52,19,NUM,1,4,ESCR,-1,0,NULL,NULL); /* 4 needs changed to the max num of partitions */

  if(flags.esc==FALSE)
    {
    Delete_Primary_Partition(input-1);

    Clear_Screen(NULL);
    Print_Centered(4,"Delete Non-DOS Partition",BOLD);
    Display_Primary_Partition_Information_SS();
    Position_Cursor(4,21);
    cprintf("Non-DOS Partition deleted");
    Position_Cursor(4,24);
    printf("                                    ");

    Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
    }
}

/* Delete Primary DOS Partition Interface */
void Delete_Primary_DOS_Partition_Interface()
{
  int input=0;
  int partition_to_delete;

  Clear_Screen(NULL);

  Print_Centered(4,"Delete Primary DOS Partition",BOLD);
  Display_Primary_Partition_Information_SS();

  Position_Cursor(4,19);
  if(flags.monochrome!=TRUE) textcolor(WHITE | BLINK);
  cprintf("WARNING!");
  if(flags.monochrome!=TRUE) textcolor(15);

  printf(" Data in the deleted Primary DOS Partition will be lost.");
  Position_Cursor(4,20);
  printf("What primary partition do you want to delete..? ");

  flags.esc=FALSE;
  input=Input(1,52,20,NUM,1,4,ESCR,-1,0,NULL,NULL); /* 4 needs changed to the max num of partitions */

  if(flags.esc==FALSE)
    {
    partition_to_delete=input-1;

    Position_Cursor(4,22);
    printf("Are you sure (Y/N)..............................? ");
    flags.esc=FALSE;
    input=Input(1,54,22,YN,0,0,ESCR,0,0,NULL,NULL);

    if( (input==TRUE) && (flags.esc==FALSE) )
      {
      Delete_Primary_Partition(partition_to_delete);

      Clear_Screen(NULL);

      Print_Centered(4,"Delete Primary DOS Partition",BOLD);
      Display_Primary_Partition_Information_SS();
      Position_Cursor(4,21);
      cprintf("Primary DOS Partition deleted");

      Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
      }
    }
}

/* Display information for all hard drives */
void Display_All_Drives()
{
  int current_column_offset_of_general_drive_information;
  int current_column_offset=4;
  int current_line=3;
  int current_line_of_general_drive_information;
  int drive=1;
  int drive_letter_index=0;
  int index;

  long space_used_on_drive_in_MB;

  unsigned long usage;

  Determine_Drive_Letters();

  Position_Cursor(2,2);
  printf("Disk   Drv   Mbytes   Free   Usage");

  do
    {
    if(current_line>18)
      {
      current_line=3;
      current_column_offset=45;

      Position_Cursor(43,2);
      printf("Disk   Drv   Mbytes   Free   Usage");
      }

    /* Print physical drive information */
    current_column_offset_of_general_drive_information=current_column_offset;
    current_line_of_general_drive_information=current_line;
    space_used_on_drive_in_MB=0;

    /* Print drive number */
    Position_Cursor(current_column_offset_of_general_drive_information,current_line);
    cprintf("%d",drive);

    /* Print size of drive */
    Position_Cursor((current_column_offset_of_general_drive_information+10),current_line);
    Print_UL(part_table[(drive-1)].total_hard_disk_size_in_MB);

    /* Get space_used_on_drive_in_MB */
    index=0;
    do
      {
      if( (part_table[(drive-1)].pri_part_num_type[index]!=5)
       && (part_table[(drive-1)].pri_part_num_type[index]!=15)
       && (part_table[(drive-1)].pri_part_num_type[index]!=0) )
       space_used_on_drive_in_MB
       =space_used_on_drive_in_MB
       +part_table[(drive-1)].pri_part_size_in_MB[index];

      index++;
      }while(index<=3);

    index=0;
    do
      {
      if(part_table[(drive-1)].log_drive_num_type[index]>0)
       space_used_on_drive_in_MB
       =space_used_on_drive_in_MB
       +part_table[(drive-1)].log_drive_size_in_MB[index];

      index++;
      }while(index<=22);

    /* Print logical drives on disk, if applicable */

    drive_letter_index=0;
    do
      {
      if(drive_lettering_buffer[(drive-1)] [drive_letter_index]>0)
	{
	current_line++;

	if(current_line>18)
	  {
	  current_line=3;
	  current_column_offset=45;

	  Position_Cursor(43,2);
	  printf("Disk   Drv   Mbytes   Free   Usage");
	  }

	/* Print drive letter of logical drive */
	if( ( (drive_lettering_buffer[(drive-1)] [drive_letter_index]>='C')
	 && (drive_lettering_buffer[(drive-1)] [drive_letter_index]<='Z') )
	 || (flags.del_non_dos_log_drives==TRUE) )
	  {
	  Position_Cursor((current_column_offset+6),current_line);
	  printf("%c",drive_lettering_buffer[(drive-1)] [drive_letter_index]);
	  Position_Cursor((current_column_offset+7),current_line);
	  printf(":");
	  }
	else
	  {
	  Position_Cursor((current_column_offset+8),current_line);
	  }

	/* Print size of logical drive */
	Position_Cursor((current_column_offset+10),current_line);

	if(drive_letter_index<4)
	  {
	  printf("%6u",part_table[(drive-1)].pri_part_size_in_MB[drive_letter_index]);
	  }
	else
	  {
	  printf("%6d",part_table[(drive-1)].log_drive_size_in_MB[(drive_letter_index-4)]);
	  }
	}

      drive_letter_index++;
      }while(drive_letter_index<27);

    /* Print amount of free space on drive */
    if(part_table[(drive-1)].total_hard_disk_size_in_MB>space_used_on_drive_in_MB)
      {
      Position_Cursor((current_column_offset_of_general_drive_information+18),current_line_of_general_drive_information);
      Print_UL(part_table[(drive-1)].total_hard_disk_size_in_MB-space_used_on_drive_in_MB);
      }

    /* Print drive usage percentage */
    if(space_used_on_drive_in_MB==0) usage=0;
    else usage=1+((100*space_used_on_drive_in_MB)/(part_table[(drive-1)].total_hard_disk_size_in_MB));
    if(usage>100) usage=100;

    Position_Cursor((current_column_offset_of_general_drive_information+28),current_line_of_general_drive_information);
    printf("%3d%%",usage);

    current_line++;
    drive++;
    }while(drive<=(flags.maximum_drive_number-127));

  Position_Cursor(4,20);
  printf("(1 Mbyte = 1048576 bytes)");
}

void Display_CL_Partition_Table()
{
  int index=0;

  unsigned long usage=0;

  Determine_Drive_Letters();

  printf("\n\nCurrent fixed disk drive: %1d",(flags.drive_number-127));
  if(flags.extended_options_flag==TRUE)
    {
    printf("                  (TC: %4d",part_table[(flags.drive_number-128)].total_cyl);
    printf(" TH: %3d",part_table[(flags.drive_number-128)].total_head);
    printf(" TS: %3d)",part_table[(flags.drive_number-128)].total_sect);
    }

  printf("\n\nPartition   Status   Mbytes   Description     Usage  ");
  if(flags.extended_options_flag==TRUE) printf("Start Cyl  End Cyl");
  printf("\n");

  index=0;
  do
    {
    if(part_table[(flags.drive_number-128)].pri_part_num_type[index]>0)
      {
      /* Drive Letter of Partition */
      if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==1) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==4) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==6) || ( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0b) && ( (flags.version==W95B) || (flags.version==W98) ) ) )
	{
	printf(" %1c:",drive_lettering_buffer[(flags.drive_number-128)] [index]);
	}
      else printf("   ");

      /* Partition Number */
      printf(" %1d",(index+1));

      if(flags.extended_options_flag==TRUE)
	{
	/* Partition Type */
	printf(" %3d",(part_table[(flags.drive_number-128)].pri_part_num_type[index]));
	}
      else printf("    ");

      /* Status */
      if(part_table[(flags.drive_number-128)].active_status[index]>0)
	{
	printf("      A");
	}
      else printf("       ");

      /* Mbytes */
      printf("    ");
      Print_UL(part_table[(flags.drive_number-128)].pri_part_size_in_MB[index]);

      /* Description */
      printf("   %15s",partition_lookup_table_buffer_long[part_table[(flags.drive_number-128)].pri_part_num_type[(index)]]);

      /* Usage */
      usage=((part_table[(flags.drive_number-128)].pri_part_size_in_MB[index]*100)/part_table[(flags.drive_number-128)].total_hard_disk_size_in_MB);
      if(usage>100) usage=100;

      printf("   %3d%%",usage);

      if(flags.extended_options_flag==TRUE)
	{
	/* Starting Cylinder */
	printf("    %4d",part_table[(flags.drive_number-128)].pri_part_start_cyl[index]);

	/* Ending Cylinder */
	printf("      %4d",part_table[(flags.drive_number-128)].pri_part_end_cyl[index]);
	}
      printf("\n");
      }

    index++;
    }while(index<4);

  /* Check to see if there are any drives to display */
  if( (brief_partition_table[(flags.drive_number-128)] [4]>0)
   || (brief_partition_table[(flags.drive_number-128)] [5]>0) )
    {
    printf("\nContents of Extended DOS Partition:\n");
    printf("Drv Volume Label  Mbytes  System  Usage\n");

    /* Display information for each Logical DOS Drive */
    index=4;
    do
      {
      if( (brief_partition_table[(flags.drive_number-128)] [index]==1)
       || (brief_partition_table[flags.drive_number-128] [index]==4)
       || (brief_partition_table[flags.drive_number-128] [index]==6)

       || ( ( (flags.version==W95) || (flags.version==W95B)
	|| (flags.version==W98) )
	&& (brief_partition_table[(flags.drive_number-128)] [index]==0x0e) )


       || ( ( (flags.version==W95B) || (flags.version==W98) )
	&& ( (brief_partition_table[(flags.drive_number-128)] [index]==0x0b)
	|| (brief_partition_table[(flags.drive_number-128)] [index]==0x0c) ) )

	)
	{
	/* Display drive letter */
	printf(" %1c:",drive_lettering_buffer[(flags.drive_number-128)] [index]);

	/* Display volume label */
	printf(" %11s",part_table[(flags.drive_number-128)].log_drive_vol_label[index-4]);

	/* Display size in MB */
	printf("  ");
	Print_UL(part_table[(flags.drive_number-128)].log_drive_size_in_MB[(index-4)]);

	/* Display file system type */
	printf("  %-8s",partition_lookup_table_buffer_short[part_table[(flags.drive_number-128)].log_drive_num_type[(index-4)]]);

	/* Display usage in % */
	usage=((part_table[(flags.drive_number-128)].log_drive_num_sect[index-4]*100)/part_table[(flags.drive_number-128)].ext_part_num_sect);
	if(usage>100) usage=100;

	printf("  %3d%%",usage);

	printf("\n");
	}

      index++;
      }while(index<27);
    }
}

/* Display Extended Partition Information Sub Screen */
void Display_Extended_Partition_Information_SS()
{
  int column_index=0;
  int index;
  int print_index=4;

  unsigned long usage;

  Determine_Drive_Letters();

  /* Check to see if there are any drives to display */
  if( (brief_partition_table[(flags.drive_number-128)] [4]>0) || (brief_partition_table[(flags.drive_number-128)] [5]>0) )
    {
    Position_Cursor(0,3);
    printf("Drv Volume Label  Mbytes  System  Usage");

    /* Display information for each Logical DOS Drive */
    index=4;
    print_index=4;
    do
      {
      if( (brief_partition_table[(flags.drive_number-128)] [index]==1)
       || (brief_partition_table[(flags.drive_number-128)] [index]==4)
       || (brief_partition_table[(flags.drive_number-128)] [index]==6)

       || ( ( (brief_partition_table[(flags.drive_number-128)] [index]==0x0b)
       || (brief_partition_table[(flags.drive_number-128)] [index]==0x0c) )
       && ( (flags.version==W95B) || (flags.version==W98) ) )

       || ( (brief_partition_table[(flags.drive_number-128)] [index]==0x0e)
       && ( (flags.version==W95) || (flags.version==W95B)
       || (flags.version==W98) ) ) )
	{
	if(print_index>15)
	  {
	  column_index=41;
	  print_index=4;

	  Position_Cursor(41,3);
	  printf("Drv Volume Label  Mbytes  System  Usage");
	  }

	/* Display drive letter */
	Position_Cursor((column_index+0),print_index);
	cprintf("%c",drive_lettering_buffer[(flags.drive_number-128)] [index]);

	Position_Cursor((column_index+1),print_index);
	cprintf(":");

	/* Display volume label */
	Position_Cursor((column_index+4),print_index);
	printf("%11s",part_table[(flags.drive_number-128)].log_drive_vol_label[index-4]);

	/* Display size in MB */
	Position_Cursor((column_index+17),print_index);
	Print_UL(part_table[(flags.drive_number-128)].log_drive_size_in_MB[(index-4)]);

	/* Display file system type */
	Position_Cursor((column_index+25),print_index);
	printf("%s",partition_lookup_table_buffer_short[part_table[(flags.drive_number-128)].log_drive_num_type[(index-4)]]);

	/* Display usage in % */
	usage=((part_table[(flags.drive_number-128)].log_drive_num_sect[index-4]*100)/part_table[(flags.drive_number-128)].ext_part_num_sect);
	if(usage>100) usage=100;

	Position_Cursor((column_index+35),print_index);
	printf("%3d%%",usage);

	print_index++;
	}

      else if(brief_partition_table[(flags.drive_number-128)] [index]>0)
	     {
	     if(print_index>15)
	       {
	       column_index=41;
	       print_index=4;

	       Position_Cursor(41,3);
	       printf("Drv Volume Label  Mbytes  System  Usage");
	       }

	     if(flags.del_non_dos_log_drives==TRUE)
	       {
	       /* Display drive number */
	       Position_Cursor((column_index+0),print_index);
	       cprintf("%c",drive_lettering_buffer[(flags.drive_number-128)] [index]);
	       }

	     /* Display size in MB */
	     Position_Cursor((column_index+17),print_index);
	     Print_UL(part_table[(flags.drive_number-128)].log_drive_size_in_MB[(index-4)]);

	     /* Display file system type */
	     Position_Cursor((column_index+25),print_index);
	     printf("%s",partition_lookup_table_buffer_short[part_table[(flags.drive_number-128)].log_drive_num_type[(index-4)]]);

	     /* Display usage in % */
	     usage=((part_table[(flags.drive_number-128)].log_drive_num_sect[index-4]*100)/part_table[(flags.drive_number-128)].ext_part_num_sect);
	     if(usage>100) usage=100;

	     Position_Cursor((column_index+35),print_index);
	     printf("%3d%%",usage);

	     print_index++;
	     }
      index++;
      }while(index<27);
    }
  else
    {
    Position_Cursor(4,10);
    cprintf("No logical drives defined");
    }

  Position_Cursor(4,17);
  printf("Total Extended DOS Partition size is ");

  if( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) )
    Print_UL_B(part_table[flags.drive_number-128].ext_part_size_in_MB);
  else cprintf("%4d",(part_table[flags.drive_number-128].ext_part_size_in_MB) );
  printf(" Mbytes (1 Mbyte = 1048576 bytes)");
}

/* Display Or Modify Logical Drive Information in the extended partition */
void Display_Or_Modify_Logical_Drive_Information()
{
  char char_number[1];

  int continue_loop;
  int index;
  int input;
  int input_ok;

  Beginning:

  Clear_Screen(NOEXTRAS);

  if(flags.extended_options_flag==FALSE)
   Print_Centered(1,"Display Logical DOS Drive Information",BOLD);
  else Print_Centered(1,"Display/Modify Logical DOS Drive Information",BOLD);

  Display_Extended_Partition_Information_SS();

  if(flags.extended_options_flag==FALSE)
   Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
  else
    {
    Position_Cursor(4,18);
    printf("Enter the character of the logical drive you want to modify.....?");

    Determine_Drive_Letters();

    continue_loop=TRUE;
    do
      {
      flags.esc=FALSE;

      if( (flags.del_non_dos_log_drives==TRUE) && (part_table[(flags.drive_number-128)].num_of_non_dos_log_drives>0) )
	{
	if(part_table[(flags.drive_number-128)].num_of_non_dos_log_drives>9) part_table[(flags.drive_number-128)].num_of_non_dos_log_drives=9;
	itoa(part_table[(flags.drive_number-128)].num_of_non_dos_log_drives,char_number,10);
	input=Input(1,69,18,CHAR,68,90,ESCC,0,0,"1",char_number);
	}
      else input=Input(1,69,18,CHAR,68,90,ESCC,0,0,NULL,NULL);

      if(flags.esc==FALSE)
	{
	/* Ensure that the entered character is legitimate. */
	index=4;
	do
	  {
	  if( (drive_lettering_buffer[(flags.drive_number-128)] [index]>0) && (drive_lettering_buffer[(flags.drive_number-128)] [index]==input) )
	    {
	    input=index-4;
	    input_ok=TRUE;
	    index=30; /* break out of the loop */
	    }

	    index++;
	  }while(index<=26);
	}

      if(input_ok==TRUE) continue_loop=FALSE;
      if(flags.esc==TRUE) continue_loop=FALSE;

      }while(continue_loop==TRUE);

    if( (input_ok==TRUE) && (flags.esc==FALSE) )
      {
      Modify_Extended_Partition_Information(input);
      goto Beginning;
      }
    }
}

/* Display/Modify Partition Information */
void Display_Partition_Information()
{
  int input;

  Beginning:

  Clear_Screen(NULL);
  if(flags.extended_options_flag==FALSE)
   Print_Centered(4,"Display Partition Information",BOLD);
  else Print_Centered(4,"Display/Modify Partition Information",BOLD);

  Display_Primary_Partition_Information_SS();

  if(part_table[(flags.drive_number-128)].num_of_log_drives>0)
    {
    Position_Cursor(4,17);
    printf("The Extended DOS Partition contains Logical DOS Drives.");

    Position_Cursor(4,18);
    printf("Do you want to display the logical drive information (Y/N)......?");

    if(flags.extended_options_flag==TRUE)
      {
      Position_Cursor(4,19);
      printf("  (Optional:  Type the number of the partition to modify.)");

      input=Input(1,69,18,YN,0,0,ESCR,1,0,"1","4");

      if( ((input-48)>=1) && ((input-48)<=4) )
	{
	Modify_Primary_Partition_Information((input-48));
	goto Beginning;
	}
      }
    else input=Input(1,69,18,YN,0,0,ESCR,1,0,NULL,NULL);

    if(input==TRUE)
      {
      Display_Or_Modify_Logical_Drive_Information();
      if(flags.extended_options_flag==TRUE) goto Beginning;
      }
    }
  else
    {
    if(flags.extended_options_flag==FALSE)
     Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
    else
     {
     Position_Cursor(4,18);
     printf("Enter the number of the partition you want to modify (1-4)......?");

     flags.esc=FALSE;
     input=Input(1,69,18,NUM,1,4,ESCR,1,0,NULL,NULL);

     if(flags.esc==FALSE)
       {
       Modify_Primary_Partition_Information(input);
       goto Beginning;
       }
     }
    }
}

/* Display Primary Partition information Sub-screen */
void Display_Primary_Partition_Information_SS()
{
  int cursor_offset=0;
  int index=0;

  unsigned long usage=0;

  Determine_Drive_Letters();

  Position_Cursor(4,6);
  printf("Current fixed disk drive: ");
  cprintf("%d",(flags.drive_number-127));

  if( (part_table[(flags.drive_number-128)].pri_part_num_type[0]>0) || (part_table[(flags.drive_number-128)].pri_part_num_type[1]>0) || (part_table[(flags.drive_number-128)].pri_part_num_type[2]>0) || (part_table[(flags.drive_number-128)].pri_part_num_type[3]>0) )
    {
    if(flags.extended_options_flag==FALSE)
      {
      Position_Cursor(4,8);
      printf("Partition  Status   Type    Volume Label  Mbytes   System   Usage");

      index=0;
      do
	{
	if(part_table[(flags.drive_number-128)].pri_part_num_type[index]>0)
	  {
	  /* Drive Letter of Partition */
	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==1) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==4) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==6) )
	    {
	    Position_Cursor(5,(cursor_offset+9));
	    printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [index]);
	    }

	  if( ( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0b) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0c) ) && ( (flags.version==W95B) || (flags.version==W98) ) )
	    {
	    Position_Cursor(5,(cursor_offset+9));
	    printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [index]);
	    }

	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0e) && ( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) ) )
	    {
	    Position_Cursor(5,(cursor_offset+9));
	    printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [index]);
	    }

	  /* Partition Number */
	  Position_Cursor(8,(cursor_offset+9));
	  cprintf("%d",(index+1));

	  /* Status */
	  if(part_table[(flags.drive_number-128)].active_status[index]>0)
	    {
	    Position_Cursor(18,(cursor_offset+9));
	    printf("A");
	    }

	  /* Type */
	  if(  (part_table[(flags.drive_number-128)].pri_part_num_type[index]==1) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==4) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==6)  )
	    {
	    Position_Cursor(23,(cursor_offset+9));
	    printf("PRI DOS");
	    }

	  if(part_table[(flags.drive_number-128)].pri_part_num_type[index]==5)
	    {
	    Position_Cursor(23,(cursor_offset+9));
	    printf("EXT DOS");
	    }

	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]!=1) && (part_table[(flags.drive_number-128)].pri_part_num_type[index]!=4) && (part_table[(flags.drive_number-128)].pri_part_num_type[index]!=5) && (part_table[(flags.drive_number-128)].pri_part_num_type[index]!=6)  )
	    {
	    Position_Cursor(23,(cursor_offset+9));
	    printf("Non-DOS");
	    }

	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0e) && ( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) ) )
	    {
	    Position_Cursor(23,(cursor_offset+9));
	    printf("PRI DOS");
	    }

	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0f) && ( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) ) )
	    {
	    Position_Cursor(23,(cursor_offset+9));
	    printf("EXT DOS");
	    }

	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0b) && ( (flags.version==W95B) || (flags.version==W98) ) )
	    {
	    Position_Cursor(23,(cursor_offset+9));
	    printf("PRI DOS");
	    }

	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0c) && ( (flags.version==W95B) || (flags.version==W98) ) )
	    {
	    Position_Cursor(23,(cursor_offset+9));
	    printf("PRI DOS");
	    }

	  /* Volume Label */
	  Position_Cursor(33,(cursor_offset+9));
	  printf("%11s",part_table[(flags.drive_number-128)].pri_part_vol_label[index]);

	  /* Mbytes */
	  Position_Cursor(45,(cursor_offset+9));
	  Print_UL(part_table[(flags.drive_number-128)].pri_part_size_in_MB[index]);

	  /* System */
	  Position_Cursor(54,(cursor_offset+9));
	  printf("%s",partition_lookup_table_buffer_short[part_table[(flags.drive_number-128)].pri_part_num_type[(index)]]);

	  /* Usage */
	  usage=((part_table[(flags.drive_number-128)].pri_part_size_in_MB[index]*100)/part_table[(flags.drive_number-128)].total_hard_disk_size_in_MB);
	  if(usage>100) usage=100;

	  Position_Cursor(65,(cursor_offset+9));
	  printf("%3d%%",usage);

	  cursor_offset++;
	  }

	index++;
	}while(index<4);
      }
    else
      {
      Position_Cursor(4,8);
      printf("Partition   Status   Mbytes    Description    Usage  Start Cyl  End Cyl");

      index=0;
      do
	{
	if(part_table[(flags.drive_number-128)].pri_part_num_type[index]>0)
	  {
	  /* Drive Letter of Partition */
	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==1) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==4) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==6) )
	    {
	    Position_Cursor(5,(cursor_offset+9));
	    printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [index]);
	    }

	  if( ( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0b) || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0c) ) && ( (flags.version==W95B) || (flags.version==W98) ) )
	    {
	    Position_Cursor(5,(cursor_offset+9));
	    printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [index]);
	    }

	  if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0e) && ( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) ) )
	    {
	    Position_Cursor(5,(cursor_offset+9));
	    printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [index]);
	    }

	  /* Partition Number */
	  Position_Cursor(8,(cursor_offset+9));
	  cprintf("%d",(index+1));

	  /* Partition Type */
	  Position_Cursor(10,(cursor_offset+9));
	  printf("%3d",(part_table[(flags.drive_number-128)].pri_part_num_type[index]));

	  /* Status */
	  if(part_table[(flags.drive_number-128)].active_status[index]>0)
	    {
	    Position_Cursor(19,(cursor_offset+9));
	    printf("A");
	    }

	  /* Mbytes */
	  Position_Cursor(24,(cursor_offset+9));
	  Print_UL(part_table[(flags.drive_number-128)].pri_part_size_in_MB[index]);

	  /* Description */
	  Position_Cursor(33,(cursor_offset+9));
	  printf("%15s",partition_lookup_table_buffer_long[part_table[(flags.drive_number-128)].pri_part_num_type[index]]);

	  /* Usage */
	  usage=((part_table[(flags.drive_number-128)].pri_part_size_in_MB[index]*100)/part_table[(flags.drive_number-128)].total_hard_disk_size_in_MB);
	  if(usage>100) usage=100;

	  Position_Cursor(51,(cursor_offset+9));
	  printf("%3d%%",usage);

	  /* Starting Cylinder */
	  Position_Cursor(59,(cursor_offset+9));
	  /* */
	  printf("%4d",part_table[(flags.drive_number-128)].pri_part_start_cyl[index]);

	  /* Ending Cylinder */
	  Position_Cursor(69,(cursor_offset+9));
	  printf("%4d",part_table[(flags.drive_number-128)].pri_part_end_cyl[index]);

	  cursor_offset++;
	  }

	index++;
	}while(index<4);
      }
    }
  else
    {
    Position_Cursor(4,21);
    cprintf("No partitions defined");
    }

  Position_Cursor(4,14);
  printf("Total disk space is ");

  if( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) )
    Print_UL_B(part_table[(flags.drive_number-128)].total_hard_disk_size_in_MB);
  else cprintf("%4d",part_table[(flags.drive_number-128)].total_hard_disk_size_in_MB);

  printf(" Mbytes (1 Mbyte = 1048576 bytes)");
}

/* Dump the partition tables from all drives to screen */
void Dump_Partition_Information()
{
  int index=0;
  flags.extended_options_flag=TRUE;

  do
    {
    flags.drive_number=index+128;
    Display_CL_Partition_Table();
    index++;
    }while(index<=7);
}

/* List the Partition Types */
void List_Partition_Types()
{
  int index=0;
  int row=4;
  int column=0;
  do
    {
    if( (index==0) || (index==64) || (index==128) || (index==192) )
      {
      Clear_Screen(NULL);
      Print_Centered(1,"List Partition Types",BOLD);
      row=4;
      column=0;
      }

    if( (row==20) && (column==0) )
      {
      row=4;
      column=20;
      }

    if( (row==20) && (column==20) )
      {
      row=4;
      column=40;
      }

    if( (row==20) && (column==40) )
      {
      row=4;
      column=60;
      }

    Position_Cursor(column,row);
    cprintf("%3d ",index);
    printf("%s",partition_lookup_table_buffer_long[index]);

    if( (index==63) || (index==127) || (index==191) || (index==255) )
      {

     Position_Cursor(0,23);
     printf("Press ");
     cprintf("Any Key");
     printf(" to continue");

     asm{
       mov ah,7
       int 0x21
       }
      }

    row++;
    index++;
    }while(index<=255);
}

/* Modify Extended Partition Information */
void Modify_Extended_Partition_Information(int logical_drive_number)
{
  int finished=FALSE;
  int input;

  unsigned long new_partition_size_in_sectors;
  unsigned long usage;

  do
    {
    Clear_Screen(NULL);
    Print_Centered(4,"Display/Modify Logical Drive Information",BOLD);

    Determine_Drive_Letters();

    Position_Cursor(4,6);
    printf("Current fixed disk drive: ");
    cprintf("%d",(flags.drive_number-127));

    Position_Cursor(4,8);
    printf("Partition            Mbytes    Description    Usage  Start Cyl  End Cyl");

    /* Drive Letter of Partition */
    if( (part_table[(flags.drive_number-128)]
     .log_drive_num_type[logical_drive_number]==1)
     || (part_table[(flags.drive_number-128)]
     .log_drive_num_type[logical_drive_number]==4)
     || (part_table[(flags.drive_number-128)]
     .log_drive_num_type[logical_drive_number]==6) )
      {
      Position_Cursor(5,9);
      cprintf("%c:",drive_lettering_buffer[(flags.drive_number-128)]
       [(logical_drive_number+4)]);
      }

    if( ( (part_table[(flags.drive_number-128)]
     .log_drive_num_type[logical_drive_number]==0x0b)
     || (part_table[(flags.drive_number-128)]
     .log_drive_num_type[logical_drive_number]==0x0c) )
     && ( (flags.version==W95B) || (flags.version==W98) ) )
      {
      Position_Cursor(5,9);
      cprintf("%c:",drive_lettering_buffer[(flags.drive_number-128)]
       [(logical_drive_number+4)]);
      }

    if( (part_table[(flags.drive_number-128)]
     .log_drive_num_type[logical_drive_number]==0x0e)
     && ( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) ) )
      {
      Position_Cursor(5,9);
      cprintf("%c:",drive_lettering_buffer[(flags.drive_number-128)]
       [(logical_drive_number+4)]);
      }

    /* Partition Number */
    Position_Cursor(8,9);
    printf("%d",(logical_drive_number+1));

    /* Partition Type */
    Position_Cursor(10,9);
    printf("%3d",(part_table[(flags.drive_number-128)]
     .log_drive_num_type[logical_drive_number]));

    /* Mbytes */
    Position_Cursor(24,9);
    Print_UL(part_table[(flags.drive_number-128)]
     .log_drive_size_in_MB[logical_drive_number]);

    /* Description */
    Position_Cursor(33,9);
    printf("%15s",partition_lookup_table_buffer_long
     [part_table[(flags.drive_number-128)].log_drive_num_type
     [logical_drive_number]]);

    /* Usage */
    usage=((part_table[(flags.drive_number-128)]
     .log_drive_size_in_MB[logical_drive_number]*100)
     /part_table[(flags.drive_number-128)].ext_part_size_in_MB);
    if(usage>100) usage=100;

    Position_Cursor(51,9);
    printf("%3d%%",usage);

    /* Starting Cylinder */
    Position_Cursor(59,9);
    printf("%4d",part_table[(flags.drive_number-128)]
     .log_drive_start_cyl[logical_drive_number]);

    /* Ending Cylinder */
    Position_Cursor(69,9);
    printf("%4d",part_table[(flags.drive_number-128)]
     .log_drive_end_cyl[logical_drive_number]);

    Position_Cursor(4,12);
    printf("Choose one of the following:");

    Position_Cursor(4,14);
    cprintf("1.");
    printf("  Change partition type");
    Position_Cursor(4,15);
    cprintf("2.");
    printf("  List partition types");
    Position_Cursor(44,14);
    cprintf("3.");
    printf("  Hide/Unhide partition");
    Position_Cursor(44,15);
/*
    cprintf("4.");
    printf("  Reserved for future use.");
*/
    Position_Cursor(4,17);
    printf("Enter choice: ");

    flags.esc=FALSE;
    input=Input(1,19,17,NUM,1,3,ESCC,-1,0,NULL,NULL);
    if(flags.esc==TRUE)
      {
      input=99;
      finished=TRUE;
      }

    if(input==1)
      {
      /* Change partition type */
      Position_Cursor(4,19);
      printf("Enter new partition type (1-255)...................................");

      flags.esc=FALSE;
      input=Input(3,71,19,NUM,1,255,ESCC,-1,0,NULL,NULL);
      if(flags.esc==FALSE)
	{
	part_table[(flags.drive_number-128)]
	 .log_drive_num_type[logical_drive_number]=input;

	part_table[(flags.drive_number-128)].part_values_changed=TRUE;
	flags.partitions_have_changed=TRUE;
	input=99;
	}
      else input=99;
      }

    if(input==2)
      {
      List_Partition_Types();
      }

    if(input==3)
      {
      /* Hide/Unhide partition */

      if(part_table[(flags.drive_number-128)]
       .log_drive_num_type[logical_drive_number]>16)
	{
	part_table[(flags.drive_number-128)]
	 .log_drive_num_type[logical_drive_number]
	 =part_table[(flags.drive_number-128)]
	 .log_drive_num_type[logical_drive_number]-16;

	part_table[(flags.drive_number-128)].part_values_changed=TRUE;
	flags.partitions_have_changed=TRUE;
	input=99;
	}
      if( (input==3)
       && (part_table[(flags.drive_number-128)]
       .log_drive_num_type[logical_drive_number]<16) )
	{
	part_table[(flags.drive_number-128)]
	 .log_drive_num_type[logical_drive_number]
	 =part_table[(flags.drive_number-128)]
	 .log_drive_num_type[logical_drive_number]+16;

	part_table[(flags.drive_number-128)].part_values_changed=TRUE;
	flags.partitions_have_changed=TRUE;
	input=99;
	}
      }

    if(input==4)
      {
      /* Reserved */
      }

  }while(finished==FALSE);
}

/* Modify Primary Partition Information */
void Modify_Primary_Partition_Information(int partition_number)
{
  int finished=FALSE;
  int input;

  unsigned long new_partition_size_in_sectors;
  unsigned long usage;

  partition_number--;   /* Adjust partition number to start with 0. */

  do
    {
      Clear_Screen(NULL);
      Print_Centered(4,"Display/Modify Partition Information",BOLD);

      Determine_Drive_Letters();

      Position_Cursor(4,6);
      printf("Current fixed disk drive: ");
      cprintf("%d",(flags.drive_number-127));

      Position_Cursor(4,8);
      printf("Partition   Status   Mbytes    Description    Usage  Start Cyl  End Cyl");

      /* Drive Letter of Partition */
      if( (part_table[(flags.drive_number-128)].pri_part_num_type[partition_number]==1) || (part_table[(flags.drive_number-128)].pri_part_num_type[partition_number]==4) || (part_table[(flags.drive_number-128)].pri_part_num_type[partition_number]==6) )
	{
	Position_Cursor(5,9);
	printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [partition_number]);
	}

      if( ( (part_table[(flags.drive_number-128)].pri_part_num_type[partition_number]==0x0b) || (part_table[(flags.drive_number-128)].pri_part_num_type[partition_number]==0x0c) ) && ( (flags.version==W95B) || (flags.version==W98) ) )
	{
	Position_Cursor(5,9);
	printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [partition_number]);
	}

      if( (part_table[(flags.drive_number-128)].pri_part_num_type[partition_number]==0x0e) && ( (flags.version==W95) || (flags.version==W95B) || (flags.version==W98) ) )
	{
	Position_Cursor(5,9);
	printf("%c:",drive_lettering_buffer[(flags.drive_number-128)] [partition_number]);
	}

      /* Partition Number */
      Position_Cursor(8,9);
      cprintf("%d",(partition_number+1));

      /* Partition Type */
      Position_Cursor(10,9);
      printf("%3d",(part_table[(flags.drive_number-128)].pri_part_num_type[partition_number]));

      /* Status */
      if(part_table[(flags.drive_number-128)].active_status[partition_number]>0)
	{
	Position_Cursor(19,9);
	printf("A");
	}

      /* Mbytes */
      Position_Cursor(24,9);
      Print_UL(part_table[(flags.drive_number-128)].pri_part_size_in_MB[partition_number]);

      /* Description */
      Position_Cursor(33,9);
      printf("%15s",partition_lookup_table_buffer_long[part_table[(flags.drive_number-128)].pri_part_num_type[partition_number]]);

      /* Usage */
      usage=((part_table[(flags.drive_number-128)].pri_part_size_in_MB[partition_number]*100)/part_table[(flags.drive_number-128)].total_hard_disk_size_in_MB);
      if(usage>100) usage=100;

      Position_Cursor(51,9);
      printf("%3d%%",usage);

      /* Starting Cylinder */
      Position_Cursor(59,9);
      printf("%4d",part_table[(flags.drive_number-128)].pri_part_start_cyl[partition_number]);

      /* Ending Cylinder */
      Position_Cursor(69,9);
      printf("%4d",part_table[(flags.drive_number-128)].pri_part_end_cyl[partition_number]);

      Position_Cursor(4,12);
      printf("Choose one of the following:");

      Position_Cursor(4,14);
      cprintf("1.");
      printf("  Change partition type");
      Position_Cursor(4,15);
      cprintf("2.");
      printf("  List partition types");
      Position_Cursor(44,14);
      cprintf("3.");
      printf("  Hide/Unhide partition");
      Position_Cursor(44,15);
      cprintf("4.");
      printf("  Remove active status");

      Position_Cursor(4,17);
      printf("Enter choice: ");

      flags.esc=FALSE;
      input=Input(1,19,17,NUM,1,4,ESCC,-1,0,NULL,NULL);
      if(flags.esc==TRUE)
	{
	input=99;
	finished=TRUE;
	}

      if(input==1)
	{
	/* Change partition type */
	Position_Cursor(4,19);
	printf("Enter new partition type (1-255)...................................");

	flags.esc=FALSE;
	input=Input(3,71,19,NUM,1,255,ESCC,-1,0,NULL,NULL);
	if(flags.esc==FALSE)
	  {
	  Modify_Partition_Type(partition_number,input);
	  input=99;
	  }
	else input=99;
	}

      if(input==2)
	{
	List_Partition_Types();
	}

      if(input==3)
	{
	/* Hide/Unhide partition */

	if(part_table[(flags.drive_number-128)]
	 .pri_part_num_type[partition_number]>16)
	  {
	  part_table[(flags.drive_number-128)]
	   .pri_part_num_type[partition_number]
	   =part_table[(flags.drive_number-128)]
	   .pri_part_num_type[partition_number]-16;

	  part_table[(flags.drive_number-128)].part_values_changed=TRUE;
	  flags.partitions_have_changed=TRUE;
	  input=99;
	  }
	if( (input==3) && (part_table[(flags.drive_number-128)]
	 .pri_part_num_type[partition_number]<16) )
	  {
	  part_table[(flags.drive_number-128)]
	   .pri_part_num_type[partition_number]
	   =part_table[(flags.drive_number-128)]
	   .pri_part_num_type[partition_number]+16;

	  part_table[(flags.drive_number-128)].part_values_changed=TRUE;
	  flags.partitions_have_changed=TRUE;
	  input=99;
	  }
	}

      if(input==4)
	{
	/* Remove active status */
	Clear_Active_Partition();
	}

    }while(finished==FALSE);

}

/* Set Active Partition Interface */
int Set_Active_Partition_Interface()
{
  int correct_input=FALSE;
  int index=0;
  int input;

  int available_partition_counter=0;
  int first_available_partition_active=FALSE;
  int only_active_partition_active=FALSE;

  int partition_settable[4];

  /* Check to see if other partitions that can be set active exist.*/
  /* Also check to see what partitions are available to set active.*/
  do
    {
    partition_settable[index]=FALSE;

    if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==1)
     || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==4)
     || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==6)

     || ( ( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0b)
     || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0c) )
     && ( (flags.version==W95B) || (flags.version==W98) ) )

     || ( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==0x0e)
     && ( (flags.version==W95) || (flags.version==W95B)
     || (flags.version==W98) ) )
     && (flags.set_any_pri_part_active==FALSE) )
      {
      available_partition_counter++;
      if( (available_partition_counter==1)
       && (part_table[(flags.drive_number-128)]
       .active_status[index]==0x80) )first_available_partition_active=TRUE;
      partition_settable[index]=TRUE;
      }

    if( (part_table[(flags.drive_number-128)].pri_part_num_type[index]>0)
     && (flags.set_any_pri_part_active==TRUE) )
      {
      available_partition_counter++;
      if( (available_partition_counter==1)
       && (part_table[(flags.drive_number-128)]
       .active_status[index]==0x80) )first_available_partition_active=TRUE;
      partition_settable[index]=TRUE;
      }

    index++;
    }while(index<=3);

  if( (available_partition_counter==1) && (first_available_partition_active==TRUE) ) only_active_partition_active=TRUE;

  Clear_Screen(NULL);
  Print_Centered(4,"Set Active Partition",BOLD);

  Display_Primary_Partition_Information_SS();

  if(available_partition_counter==0)
    {
    Position_Cursor(4,22);
    cprintf("No partitions to make active.");

    Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
    }

  if( (only_active_partition_active==FALSE) && (available_partition_counter>0) )
    {
    Position_Cursor(4,16);
    printf("Enter the number of the partition you want to make active...........: ");

    do
      {
      flags.esc=FALSE;
      input=Input(1,70,16,NUM,1,4,ESCR,-1,0,NULL,NULL);
      if(flags.esc==TRUE) return(1);

      /* Ensure that input is valid. */
      if(partition_settable[(input-1)]==TRUE) correct_input=TRUE;
      else
	{
	Position_Cursor(4,23);
	cprintf("%d is not a choice. Please enter a valid choice.",input);
	}

      }while(correct_input==FALSE);

    Set_Active_Partition(input-1);

    Clear_Screen(NULL);
    Print_Centered(4,"Set Active Partition",BOLD);

    /* */
    Display_Primary_Partition_Information_SS();

    Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
    }

  if(only_active_partition_active==TRUE)
    {
    Position_Cursor(4,22);
    cprintf("The only startable partition on Drive %d is already set active.",(flags.drive_number-127));

    Input(0,0,0,ESC,0,0,ESCC,0,0,NULL,NULL);
    }

  return(0);
}

