/****************************************************************/
/*                                                              */
/*                           imager.c                           */
/*                                                              */
/*                Seal - free desktop environment               */
/*                                                              */
/*                    Copyright (c) 1999,2000                   */
/*                         Michal Stencl                        */
/*                     All Rights Reserved                      */
/*                                                              */
/* mail : stenclpmd@ba.telecom.sk                               */
/* web  : http://www.home.sk/public/seal/                       */
/*                                                              */
/* This file is part of Seal.                                   */
/*                                                              */
/* Seal is free software; you can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation; either version */
/* 2, or (at your option) any later version.                    */
/*                                                              */
/* Seal is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of   */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See    */
/* the GNU General Public License for more details.             */
/*                                                              */
/* You should have received a copy of the GNU General Public    */
/* License along with Seal; see the file COPYING.  If not,      */
/* write to the Free Software Foundation, 675 Mass Ave,         */
/* Cambridge, MA 02139, USA.                                    */
/*                                                              */
/****************************************************************/


#include"allegro.h"
#include"seal.h"
#include"app.h"
#include"button.h"
#include"dialogs.h"
#include"iodlg.h"

#ifndef TXT_CONVERTTOIMAGE
#define TXT_CONVERTTOIMAGE  INI_TEXT("Convert to image...")
#endif
#ifndef TXT_CONVERTNOW
#define TXT_CONVERTNOW      INI_TEXT("Convert now !")
#endif
#ifndef TXT_CLOSEBYALTF4
#define TXT_CLOSEBYALTF4    INI_TEXT("Close By Alt+F4")
#endif
#ifndef TXT_EXPORT
#endif
#ifndef TXT_IMAGEISCONVRTINGINTOFILE
#define TXT_IMAGEISCONVRTINGINTOFILE   INI_TEXT("Image is converting into file")
#endif
#ifndef TXT_PLEASEWAIT
#define TXT_PLEASEWAIT   INI_TEXT("Please wait...")
#endif

static BITMAP *image = NULL;

p_list get_imager_filelist ( void ) {

                                                /* function for free-ing items */
  p_list p = list_init(malloc(sizeof(t_list)), &free_filehistory_item, 0);

  if ( p ) {

     p->insert(p, new_filehistory_item("Gif files (*.gif)", "*.gif"));
     p->insert(p, new_filehistory_item("Jpeg files (*.jpg)", "*.jpg"));
     p->insert(p, new_filehistory_item("Bmp files (*.bmp)", "*.bmp"));
     p->insert(p, new_filehistory_item("Pcx files (*.pcx)", "*.pcx"));
     p->insert(p, new_filehistory_item("Tiff files (*.tif)", "*.tif"));
     p->insert(p, new_filehistory_item("Targa files (*.tga)", "*.tga"));
     p->insert(p, new_filehistory_item("Lbm files (*.lbm)", "*.lbm"));
     p->insert(p, new_filehistory_item("X Window Bitmap files (*.xbm)", "*.xbm"));
     p->insert(p, new_filehistory_item("Iax files (*.iax)", "*.iax"));
     p->insert(p, new_filehistory_item("Pse files (*.pse)", "*.pse"));
     p->insert(p, new_filehistory_item("Pixmap files (*.ppm)", "*.ppm"));
     p->insert(p, new_filehistory_item("Portable Greyscale-map files (*.pgm)", "*.pgm"));
     p->insert(p, new_filehistory_item("Vid files (*.vid)", "*.vid"));
     p->insert(p, new_filehistory_item("All files (*.*)", "*.*"));

  };


  return p;

};


void  imager_translate_event ( p_object o, p_event e )
{

   RETVIEW(o, e);

   win_translate_event(o, e);


   if ( e->type & EV_MOUSE && OBJECT(mouse)->state & MO_SF_MOUSELDOUBLE ) { /* right mouse button pressed */

         l_text file = NULL;

         clear_event(e);

         file = file_dialog(TXT_CONVERTTOIMAGE, TXT_CONVERTNOW, "c:/", "*.gif", get_imager_filelist(), FA_ALL, FL_SAVE, NULL);

         if ( file ) { /* no canceled dialog */


             l_text path = io_path(file);

             void *p = show_info(0, MW_INFO, "%s...\n\n%s %s...", TXT_PLEASEWAIT, TXT_IMAGEISCONVRTINGINTOFILE, file );

             save_bitmap(file, image, NULL);

             hide_info(p);

             RETYPE_FILES_IN_PATH(path); /* retype files is directory path,
                                            it's for redrawing listbox with
                                            files from dir path */

             _free(path);

         };

   };

};


app_begin ( void ) {

  if ( ap_process == AP_INIT ) {

    t_rect r;

    if ( !ap_args ) ap_args = open_dialog("c:/", NULL, get_imager_filelist());

    if ( !ap_args ) return;

    image = load_image(ap_args);

    if ( image ) {

      p_object o = NULL;

      r.a.x = 0;
      r.a.y = 0;
      r.b.x = lmax(300, r.a.x+image->w+10);
      r.b.y = lmax(300, r.a.y+image->h+50);

      o = OBJECT(frame_init(_malloc(sizeof(t_window)), r));

      o->translate_event = &imager_translate_event;

      VIEW(o)->align = TX_ALIGN_CENTER;

      VIEW(o)->brush.color = VIEW(o)->brush.color2 = COLOR(CO_BLACK);
      VIEW(o)->brush.background = image;
      VIEW(o)->brush.state = BRUSH_CENTER;
      VIEW(o)->info_text = _strdup(TXT_CLOSEBYALTF4);

      OBJECT(desktop)->insert(OBJECT(desktop), OBJECT(o));

    };


  } else

  if ( ap_process == AP_FREE ) {

    if ( image ) destroy_bitmap(image);

    image = NULL;

  };

} app_end;

