/*
  This file is a part of SEAL

  (c) Copyright 2001 Sealsystem / Point Mad. All rights reserved.

  Seal is under the Sealsystem license. Please read
    license.txt in the main directory for more informations.

  For more informations about copyrights, read about.txt
    in the main directory.

*/
#include<seal.h>
#include<checkbox.h>

p_checkbox (*checkbox_init) ( p_checkbox o, t_rect r, l_text caption, l_dword state, l_dword message ) = &_checkbox_init;
/////////////////////////////////////////////////////////////////////////////////
void checkbox_translate_event ( p_object o, t_event *event ) {
  RETVIEW(o,event);
  view_translate_event(o,event);
  if ( event->type & EV_MOUSE ) {
    if ( OBJECT(mouse)->state & MO_SF_MOUSELDOWN ) {
      if ( !( CHECKBOX(o)->state & CB_GREYED ) ) {
        CHECKBOX(o)->state |= CB_GREYED;
        VIEW(o)->draw_me(VIEW(o));
      };
    };
    if ( OBJECT(mouse)->state & MO_SF_MOUSELUP ) {
      if ( CHECKBOX(o)->state & CB_GREYED  )
        CHECKBOX(o)->state &= ~CB_GREYED;
      if ( CHECKBOX(o)->state & CB_CHECKED  )
        CHECKBOX(o)->state &= ~CB_CHECKED;
      else
        CHECKBOX(o)->state |= CB_CHECKED;

      VIEW(o)->draw_me(VIEW(o));

      if (CHECKBOX(o)->message) {
        set_event(event, EV_MESSAGE, CHECKBOX(o)->message, o);
        o->put_event(o, event);
      };
      clear_event(event);
    };
  };
};
/////////////////////////////////////////////////////////////////////////////////
void checkbox_draw ( p_view o ) {


  t_rect  r = o->size_limits(o);
  t_point p;

  BITMAP *out = o->begin_paint(o, &p, r);

  if ( out ) {
    p_checkbox cb = CHECKBOX(o);
    l_int      cy = ( r.b.y - 12 ) / 2;

    o->background(o, out, rect_move(r, p.x, p.y));

    rectfill ( out, p.x, p.y+cy, p.x+12, p.y+cy+12, ( cb->state & CB_GREYED ) ? color_3d_face : color_flat_face );

    button3d ( o, out, p.x, p.y+cy, p.x+12, p.y+cy+12, 1 );

    if ( cb->state & CB_CHECKED ) {
      l_color c = ( cb->state & CB_GREYED ) ? color_3d_text : color_flat_text;

      line(out, p.x+3, cy+p.y+3, p.x+9, cy+p.y+9, c);
      line(out, p.x+9, cy+p.y+3, p.x+3, cy+p.y+9, c);
      line(out, p.x+4, cy+p.y+3, p.x+9, cy+p.y+8, c);
      line(out, p.x+8, cy+p.y+3, p.x+3, cy+p.y+8, c);
      line(out, p.x+3, cy+p.y+4, p.x+8, cy+p.y+9, c);
      line(out, p.x+9, cy+p.y+4, p.x+4, cy+p.y+9, c);

    };

    textout_draw_rect(out, o->font, cb->caption, -1, r.a.x+p.x+18, r.a.y+p.y,
                           r.b.x+p.x, r.b.y+p.y, TX_ALIGN_CENTERY, cb->fcolor, TX_NOCOLOR, 0);


  };

  o->end_of_paint(o, r);

};
/////////////////////////////////////////////////////////////////////////////////
l_bool checkbox_done ( p_object o ) {

  if ( CHECKBOX(o)->caption ) _free(CHECKBOX(o)->caption);

  return view_done(o);

};
/////////////////////////////////////////////////////////////////////////////////
p_checkbox _checkbox_init ( p_checkbox o, t_rect r, l_text caption, l_dword state, l_dword message ) {

  if ( !o ) return NULL;

  clear_type(o,sizeof(t_checkbox));

  view_init(VIEW(o),r);

  o->caption = _strdup(caption);
  o->state   = state;
  o->message = message;
  o->fcolor = color_3d_text;
  OBJECT(o)->done = &checkbox_done;
  OBJECT(o)->translate_event = &checkbox_translate_event;
  VIEW(o)->brush.color = color_3d_face;
  VIEW(o)->draw = &checkbox_draw;

  return o;
};