/*
  This file is a part of SEAL

  (c) Copyright 2001 Sealsystem / Point Mad. All rights reserved.

  Seal is under the Sealsystem license. Please read
    license.txt in the main directory for more informations.

  For more informations about copyrights, read about.txt
    in the main directory.

*/

////////////////////////////////////////////////////////////////////////////////

#include<seal.h>
#include<savescr.h>

////////////////////////////////////////////////////////////////////////////////

l_big  screensaver_lastime = 0;
l_text screensaver_app = NULL;
l_bool screensaver_lauched = false;
l_uint screensaver_dif = 120; // 120 sec -> 2 min

void screensaver_timer ( p_object o ) {
  if ( !screensaver_lauched )
    if ( screensaver_dif <= time(NULL) - screensaver_lastime )
      if ( screensaver_app ) {
	    screensaver_lauched = true;
        run_file ( screensaver_app );
      };
};

void screensaver_translate_event ( p_object o , t_event *event ) {
  if ( event->type & EV_KEYBOARD || event->type & EV_MOUSE ) screensaver_lastime = time(NULL);
};

p_object screensaver_init ( p_object o ) {

  if ( !o ) return NULL;

  clear_type(o,sizeof(t_object));

  obj_init(o);

  o->func_callback = &screensaver_timer;
  o->process_tick = 1000;
  o->set_options(o, OB_OF_STILLPROCESS, true);
  o->set_options(o, OB_OF_NOTACTIVATE+OB_OF_TOPSELECT, true);

  screensaver_lastime = time(NULL);

  if ( key_exists("current/seal/screensaver/app") ) screensaver_app = get_key("current/seal/screensaver/app");
  if ( key_exists("current/seal/screensaver/dif") ) screensaver_dif = get_key_integer("current/seal/screensaver/dif");

  if ( screensaver_app ) if ( !io_exist(screensaver_app) ) screensaver_app = NULL;

  DEBUG_printf("ScreenSaver settings : %s %d\n",screensaver_app,screensaver_dif);

  return o;
};