CFLAGS   = -s -Iinclude/
CPPFLAGS = -s -Iinclude/

OBJ_DIR = obj

OBJ_LIST = \
$(OBJ_DIR)/dlxload.o \
$(OBJ_DIR)/data/registry.o\
$(OBJ_DIR)/data/dataini.o\
$(OBJ_DIR)/object/view.o\
$(OBJ_DIR)/controls/button.o\
$(OBJ_DIR)/controls/app.o\
$(OBJ_DIR)/controls/inputbox.o\
$(OBJ_DIR)/controls/menus.o\
$(OBJ_DIR)/controls/trackbar.o\
$(OBJ_DIR)/controls/treeview.o\
$(OBJ_DIR)/controls/checkbox.o\
$(OBJ_DIR)/controls/iodlg.o\
$(OBJ_DIR)/controls/dialogs.o\
$(OBJ_DIR)/controls/editor.o\
$(OBJ_DIR)/controls/scroller.o\
$(OBJ_DIR)/controls/stattext.o\
$(OBJ_DIR)/controls/tabbook.o\
$(OBJ_DIR)/engine.o

LIB_LIST = \
lib/libmss.a \
lib/liballeg.a \
lib/libalttf.a \
lib/gbm.a \
lib/Libjpeg.a \
lib/libldpng.a \
lib/libpng.a \
lib/libz.a \
lib/libaastr.a

all : $(OBJ_LIST) bin\kernel.exe
	@echo Seal kernel have been built.


$(OBJ_DIR)/%.o: %.c
	gcc $(CFLAGS) -c $< -o $@

$(OBJ_DIR)/%.o: %.cpp
	gcc $(CPPFLAGS) -c $< -o $@

$(OBJ_DIR)/%.o: %.cc
	gcc $(CPPFLAGS) -c $< -o $@

bin\kernel.exe : $(OBJ_LIST)
	gcc -o bin\kernel.exe $(OBJ_LIST) $(LIB_LIST)
	exe2coff bin\kernel.exe
	copy /B CWSDSTUB.EXE+bin\kernel bin\kernel.exe
	del bin\kernel

clean :
	del $(subst /,\,$(OBJ_DIR)/object/*.o
	del $(subst /,\,$(OBJ_DIR)/controls/*.o
	del $(subst /,\,$(OBJ_DIR)/data/*.o
	del $(subst /,\,$(OBJ_DIR)/*.o)
	del bin\kernel.exe