#ifndef _TABBOOK_SEAL_H_
#define _TABBOOK_SEAL_H_

typedef struct t_tab *p_tab;
typedef struct t_tabbook *p_tabbook;

typedef struct t_tab {
  struct t_view obclass;

  l_text  caption;
  BITMAP *icon16;

} t_tab;

#define TAB(o) ((p_tab)(o))

typedef struct t_tabbook {
  struct t_view obclass;

  p_list tabs;

  p_tab  sel;

  void   (*insert)   ( p_tabbook o, l_int tab, p_object ob );
  void   (*remove)   ( p_tabbook o, l_int tab, p_object ob );
  void   (*show_tab) ( p_tabbook o, l_int tab );
  l_int  (*add_tab)  ( p_tabbook o, l_text caption, BITMAP *icon16 );
  void   (*del_tab)  ( p_tabbook o, l_int tab );

} t_tabbook;
#define TABBOOK(o) ((p_tabbook)(o))

extern p_tabbook (*tabbook_init)( p_tabbook o, t_rect r );
p_tabbook _tabbook_init ( p_tabbook o, t_rect r );
p_tabbook tabbook_make ( t_rect r );

#endif